<?php

if (!function_exists('asset_public')) {
    function asset_public($url)
    {
        return base_url($url);
    }
}

if (!function_exists('asset_public_upload')) {
    function asset_public_upload($url)
    {
        return base_url() . '/upload/' . $url;
    }
}

if (!function_exists('asset_css')) {
    function asset_css($url)
    {
        return base_url('css/' . $url);
    }
}

if (!function_exists('asset_js')) {
    function asset_js($url)
    {
        return base_url('js/' . $url);
    }
}

if (!function_exists('has_error')) {
    function has_error($name)
    {
        $validator = \Config\Services::validation();
        return $validator->hasError($name);
    }
}

if (!function_exists('get_error')) {
    function get_error($name)
    {
        $validator = \Config\Services::validation();
        return $validator->getError($name);
    }
}

if (!function_exists('old_value')) {
    function old_value($oldName, $value)
    {
        $exit = false;
        eval('$exit= isset($' . $oldName . ');');
        if ($exit) {
            $valueOld = "";
            eval('$valueOld = old($' . $oldName . ')');
            return $valueOld;
        }
        return $value;
    }
}

//Page Helper
if (!function_exists('per_page_url')) {
    function per_page_url($url, $perPage)
    {
        if (preg_match_all('/(perpage=\d+)/', $url, $matches)) {
            return str_replace($matches[0][0], 'perpage=' . $perPage, $url);
        }
        if (preg_match('/(\?)/', $url, $matches)) {
            return $url . '&' . 'perpage=' . $perPage;
        }
        return $url . '?' . 'perpage=' . $perPage;
    }
}

if (!function_exists('show_format_page')) {
    function show_format_page($pages, $currentPage = 1)
    {
        if(is_array($pages)){
            $totalPage = count($pages);
            if($totalPage <= 5) return $pages;
            $resultPages = [];
            $endIndex = $totalPage;
            $pageIndex = $currentPage - 2;
            if($currentPage == $totalPage) $pageIndex-=2;
            if($currentPage == $totalPage - 1) $pageIndex--;

            for (; $pageIndex < $currentPage ; $pageIndex ++){
                if($pageIndex > 0){
                    $resultPages[] = $pages[$pageIndex-1];
                }
            }
            $showPage = 2 + (2 - count($resultPages));
            $resultPages[] = $pages[$currentPage-1];
            $pageIndex = $currentPage + 1;

            for (; $pageIndex <= $currentPage + $showPage ; $pageIndex ++){
                if($pageIndex <= $currentPage + $showPage && $pageIndex <= $totalPage){
                    $resultPages[] = $pages[$pageIndex-1];
                }
            }
            return $resultPages;

        }
        return $pages;
    }
}

if (!function_exists('show_text_dot')) {
    function show_text_dot($value, $limit = 100, $end = '...')
    {
        if (mb_strwidth($value, 'UTF-8') <= $limit) {
            return $value;
        }
        return rtrim(mb_strimwidth($value, 0, $limit, '', 'UTF-8')) . $end;
    }
}

if (!function_exists('str_pad_right')) {
    function str_pad_right($value, $length = 10, $pad_string = ' ', $escHtml = true)
    {
        $result = str_pad($value, $length, $pad_string, STR_PAD_RIGHT);
        return $result;
    }
}

if (!function_exists('str_pad_middle')) {
    function str_pad_middle($valueStart, $valueEnd, $length = 10, $pad_string = ' ')
    {
        $lengthStart = strlen($valueStart);
        $lengthEnd = strlen($valueEnd);
        if ($lengthStart + $lengthEnd >= $length) return $valueStart . $valueEnd;
        return str_pad($valueStart, $lengthStart + ($length - $lengthStart - $lengthEnd), $pad_string, STR_PAD_RIGHT) . $valueEnd;
    }
}


if (!function_exists('escape_output')) {
    function escape_output($string)
    {
        $newString = str_replace("\r\n", '<br/>', $string);
        $newString = str_replace("\n\r", '<br/>', $newString);
        $newString = str_replace("\r", '<br/>', $newString);
        $newString = str_replace("\n", '<br/>', $newString);
        $newString = str_replace('\'', '', $newString);
        return $newString;
    }
}

if (!function_exists('open_file_browser')) {
    function open_file_browser($fileName)
    {
        $target = '_self';
        if(isset($fileName)){
            $file_parts = pathinfo($fileName);
            if(isset($file_parts['extension'])){
                $ext = trim($file_parts['extension']);
                $allowed = array('jpg','jpge','png','gif');
                if( in_array( strtolower($ext), $allowed ) ) { $target = '_blank'; }
                if($ext == 'pdf') { $target = '_blank'; }
            }
        }
        return $target;
    }
}

if (!function_exists('show_no_row')) {
    function show_no_row($index , $perPage, $currentPage)
    {
        return $perPage * ($currentPage - 1 ) + $index;
    }
}

