<?php
namespace App\Helpers;

use CodeIgniter\I18n\Time;

class DateHelper{

    /**
     * Get default TimeZone
     *
     * @return \DateTimeZone
     */
    public static function timezone()
    {
        return new \DateTimeZone("Asia/seoul");
    }

    public static function now($truncateTime = false){
        if(!$truncateTime)
            return Time::now(self::timezone());
        return self::truncateTime(Time::now(self::timezone()));
    }

    public static function truncateTime(Time $date){
        if(isset($date)){
            $date->setTime(0,0,0,0);
        }
        return $date;
    }

    public static function setFirstHourMinuteDate($date){
        if($date instanceof Time){
            return self::toTimeString(self::truncateTime($date));
        }
        try{
            $dateParse = Time::parse($date);
            return self::toTimeString(self::truncateTime($dateParse));
        }catch (\Throwable $ex){}
        return '';
    }

    public static function setLastHourMinuteDate($date){
        if($date instanceof Time){
            $date->setTime(23,59,59,99);
            return self::toTimeString($date);
        }
        try{
            $dateParse = Time::parse($date);
            $dateParse->setTime(23,59,59,99);
            return self::toTimeString($dateParse);
        }catch (\Throwable $ex){}
        return '';
    }

    public static function addMonth(Time $date, $month){
        return $date->addMonths($month);
    }

    public static function toTimeString($date, $format = null){
        if(!isset($date)) return;
        if(!isset($format)) $format = 'yyyy-MM-dd HH:mm';
        if($date instanceof Time){
            return $date->toLocalizedString($format);
        }

        return Time::parse($date,self::timezone())->toLocalizedString($format);
    }

    public static function toTimeStringYMD($date, $format = null){
        if(!isset($date)) return;
        if(!isset($format)) $format = 'yyyy-MM-dd';
        if($date instanceof Time){
            return $date->toLocalizedString($format);
        }

        return Time::parse($date,self::timezone())->toLocalizedString($format);
    }

    public static function parseDate($strDate){
        try{
            $dateParse = Time::parse($strDate);
            return $dateParse;
        }catch (\Throwable $ex){}
        return null;
    }

    public static function firstDayOfMonth($date = null){
        if(!isset($date)){
            $date = self::now();
        }
        $date = $date->setDay(1);
        return $date;
    }

    public static function lastDayOfMonth($date = null){
        if(!isset($date)){
            $lastDay = new \DateTime('last day of this month', self::timezone());
            $strDate = $lastDay->format("yy-m-d");
            $dateParse = Time::parse($strDate);
            return $dateParse;
        }
        return self::now();
    }
}
