<?php
namespace App\Helpers;

class NumberHelper{

    public static function format($value, $nullShowZero = false, $maxDecimal = 5){
        if(!isset($value) && !$nullShowZero){
            return '';
        }
        if(!isset($value) || empty($value)) return '0';
        if(is_double($value) || is_float($value) || doubleval($value) || floatval($value)){
            if(preg_match_all('/[\d]+/',doubleval($value), $arrayData) > 1){
                $countDecimal = strlen($arrayData[0][1]);
                return number_format($value,$countDecimal > $maxDecimal ? $maxDecimal : $countDecimal, '.',',');
            }
        }
        return number_format($value,0,'.',',');
    }
    

    public static function roundDown($value){
        return floor($value);
    }

    public static function round($value){
        return round($value, 0);
    }

    public static function generateRandom($length = 10) {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }
}