<?php
namespace App\Helpers;

use CodeIgniter\Validation\Validation;
use CodeIgniter\View\RendererInterface;

class ValidatorHelper extends Validation{

    protected $validationMapFieldLabels;

    /**
     * Validation constructor.
     *
     * @param \Config\Validation $config
     * @param RendererInterface  $view
     */
    public function __construct($config, RendererInterface $view)
    {
        parent::__construct($config, $view);
    }

    public function validatorToJs(){
        //        $validator->addFailure('mobile_number','min',[2]);
        $rules = $this->getRules();
//        $messages = $validator->getMessageBag()->getMessages();
//        var_dump($this->getErrorMessage('min_length[3]','item_no'));die();
        $messages = [];
        $str_rules = "rules: { ";
        $str_messages = "messages: { ";
        foreach ($rules as $name => $rule){
            $str_rules.= "$name : { ";
            $str_messages.= "$name : { ";
            $label = null;
            if(isset($this->validationMapFieldLabels[$name])) $label = $this->validationMapFieldLabels[$name];
            if(is_array($rule)) {
                $rule = $rule['rules'];
            }
            $rule = explode('|', $rule);
            foreach ($rule as $index => $ruleItem){
                $str_rules.= ($index > 0 ? "," : "") . "$ruleItem";
                $message = $this->getErrorMessageCustom($ruleItem,$name,$label);
                if(isset($message)){
                    $str_messages.= ($index > 0 ? "," : "") . "$ruleItem : '" . $message. "'";
                }
//                if(isset($messages[$name][$index])){
//                    $str_messages.= ($index > 0 ? "," : "") . "$ruleItem : '" . $messages[$name][$index]. "'";
//                }
            }
            $str_rules.= " }, ";
            $str_messages.= " }, ";
        }
        $str_rules.= " } ";
        $str_messages.= " } ";

        $str_rules = str_replace('required', 'required : true ', $str_rules);
        $str_rules = str_replace('alpha_numeric', 'number : true ', $str_rules);
        $str_rules = str_replace('valid_email', 'email : true ', $str_rules);
        $this->replaceRuleAndMessageHaveParam('max_length','maxlength',$str_rules, $str_messages);
        $this->replaceRuleAndMessageHaveParam('min_length','minlength',$str_rules, $str_messages);
        $this->replaceMatches('matches','equalTo', $str_rules, $str_messages);

        //Replace rule file
        $this->replaceRuleFile('ext_in','extension',$str_rules, $str_messages);

        //Replace rule unique
        $this->replaceRuleUnique('is_unique','is_unique', $str_rules, $str_messages);

        $str_rules = str_replace('contain_alpha_and_numeric', 'contain_alpha_and_numeric : true ', $str_rules);
        return ['rules' => $str_rules,'messages' => $str_messages];
    }

    private function replaceRuleAndMessageHaveParam($ruleName,$ruleReplace , & $str_rules, & $str_messages){
        if(preg_match_all('('.$ruleName.'\[\d+\])',$str_rules,$matches)){
            foreach ($matches[0] as $match){
                preg_match('(\d+)',$match,$numbers);
                $number = $numbers[0];
                $str_rules = str_replace($match,$ruleReplace.' : ' . $number,$str_rules);
            }

        }
        if(preg_match('('.$ruleName.'\[\d+\])',$str_messages,$matches)){
            preg_match('(\d+)',$matches[0],$numbers);
            $number = $numbers[0];
            $str_messages = preg_replace('('.$ruleName.'\[\d+\])',$ruleReplace,$str_messages);
        }
    }

    private function replaceRuleUnique($ruleName,$ruleReplace , & $str_rules, & $str_messages){
        if(preg_match_all('('.$ruleName.'\[.\S+\])',$str_rules,$matches)){
            foreach ($matches[0] as $match){
                preg_match('(\[\S+\])',$match,$params);
                $param = substr($params[0],1,strlen($params[0]) - 2);
                $param = '"'.$param.'"';
                $str_rules = str_replace($match,$ruleReplace.' : ' . $param,$str_rules);
            }
        }
        if(preg_match_all('('.$ruleName.'\[.\S+\])',$str_messages,$matches)){
            foreach ($matches[0] as $match){
                preg_match('(\[\S+\])',$match,$params);
                $str_messages = str_replace($match,$ruleReplace,$str_messages);
            }
        }
    }

    private function replaceRuleFile($ruleName,$ruleReplace , & $str_rules, & $str_messages){
//        var_dump($str_rules);die();
        if(preg_match('('.$ruleName.'\[.+\])',$str_rules,$matches)){
            preg_match('(\[.+\])',$matches[0],$extensions);
            $index = strpos($extensions[0],',');
            $extension = substr($extensions[0], $index+1,strlen($extensions[0]) - 2 - $index);

            $str_rules = str_replace($matches[0],$ruleReplace.' : "' . $extension.'"',$str_rules);
            $str_messages = str_replace($matches[0],$ruleReplace,$str_messages);
        }
    }

    private function replaceMatches($ruleName,$ruleReplace , & $str_rules, & $str_messages){
        if(preg_match('('.$ruleName.'\[.+\])',$str_rules,$matches)){
            preg_match('(\[.+\])',$matches[0],$matchFields);
            $field = substr($matchFields[0], 1, strlen($matchFields[0]) - 2);

            $str_rules = str_replace($matches[0],$ruleReplace.' : \'input[name=' . $field.']\'',$str_rules);
            $str_messages = str_replace($matches[0],$ruleReplace,$str_messages);
        }
    }

    public function setMapFieldLabels($mapFiled = []){
        $this->validationMapFieldLabels = $mapFiled;
    }

    /**
     * Attempts to find the appropriate error message
     *
     * @param string      $rule
     * @param string      $field
     * @param string|null $label
     * @param string      $param
     *
     * @return string
     */
    protected function getErrorMessageCustom(string $rule, string $field, string $label = null, string $param = null, $value = null): string
    {
        // Check if custom message has been defined by user
        if (isset($this->customErrors[$field][$rule]))
        {
            $message = $this->customErrors[$field][$rule];
        }
        else
        {
            // Try to grab a localized version of the message...
            // lang() will return the rule name back if not found,
            // so there will always be a string being returned.
            $checkParam = explode('[',$rule);
            if(is_array($checkParam) && count($checkParam) > 1){
                $message = lang('Validation.' . $checkParam[0]);
                $message = str_replace('{param}', str_replace(']','',$checkParam[1]), $message);
            }else{
                $message = lang('Validation.' . $rule);
            }
        }

        $message = str_replace('{field}', $label ?? $field, $message);
        $message = str_replace('{param}', $this->rules[$param]['label'] ?? $param, $message);

        return $message;
    }
}