<?php

namespace App\Libraries\BreadCrumb;

use function MicrosoftAzure\Storage\Samples\basicStorageBlobOperationAsync;

class BreadCrumb{
    private const KEY_PARENT_BREAD_CRUMB = 'parent';

    protected $breadCrumbs;

    protected $viewRender = "admin/common/breadcrumb";

    protected $configFiles = ['BreadcrumbAdminConfig', 'BreadcrumbGuestConfig'];


    public function __construct($isConfigAdmin = true)
    {
        $this->breadCrumbs = [];
        if($isConfigAdmin){
            $file = $this->configFiles[0];
            $path = APPPATH . "Libraries/BreadCrumb/{$file}.php";
            $this->viewRender = "admin/common/breadcrumb";
        }else{
            $file = $this->configFiles[1];
            $path = APPPATH . "Libraries/BreadCrumb/{$file}.php";
            $this->viewRender = "guest/common/breadcrumb";
        }
        $this->loadConfig([$path]);
    }

    private function loadConfig($files){
        foreach ($files as $file){
            if(file_exists($file)){
                $defineBreadcrumbs = require $file;
                foreach ($defineBreadcrumbs as $key => $defineBreadcrumb){
                    $this->loadBreadcrumbComponent($key,$defineBreadcrumb);
                }
            }
        }
    }

    private function loadBreadcrumbComponent($keyBreadCrumb, $values){
        if(is_array($values)){
            $breadCrumbComponent = new BreadCrumbComponent();
            $parentKey = null;
            $valueBreadcrumbs = [];
            foreach ($values as $key =>$value){
                if($key != self::KEY_PARENT_BREAD_CRUMB){
                    $valueBreadcrumbs[$key] = $value;
                }else{
                    $parentKey = $value;
                }
            }
            $breadCrumbComponent->addData($valueBreadcrumbs);
            if(isset($parentKey) && isset($this->breadCrumbs[$parentKey]) ){
                $breadCrumbComponent->addFirstComponent($this->breadCrumbs[$parentKey]);
            }
            $this->breadCrumbs[$keyBreadCrumb] = $breadCrumbComponent;
        }
    }

    public function render($breadCrumbName, ...$params){
        if(isset($this->breadCrumbs[$breadCrumbName])){
            if(isset($params) && count($params) > 0){
                $this->breadCrumbs[$breadCrumbName]->formatTitleByParams(...$params);
            }
            return $this->breadCrumbs[$breadCrumbName]->output($this->viewRender);
        }
    }

}