<?php
namespace App\Libraries\BreadCrumb;

class BreadCrumbComponent
{
    private $breadcrumbs = array();
    private $separator = '  >  ';
    private $start = '<div id="breadcrumb">';
    private $end = '</div>';

    public function __construct($params = array())
    {
        if (count($params) > 0) {
            $this->initialize($params);
        }
    }

    private function initialize($params = array())
    {
        if (count($params) > 0) {
            foreach ($params as $key => $val) {
                if (isset($this->{'_' . $key})) {
                    $this->{'_' . $key} = $val;
                }
            }
        }
    }

    function addData($params = []){
        if(!isset($params) && count($params) == 0) return;
        if(!isset($params['title']) && !isset($params['href'])) return;
        $this->breadcrumbs[] = $params;
    }

    function add($title, $href)
    {
        if (!$title OR !$href)
            return;

        $this->breadcrumbs[] = array(
            'title' => $title,
            'href' => $href
        );
    }

    function addFirstComponent(BreadCrumbComponent $breadCrumbComponent){
        $breadcrumbs = $breadCrumbComponent->breadcrumbs;
        foreach (array_reverse($breadcrumbs) as $breadcrumb){
            array_unshift($this->breadcrumbs,$breadcrumb);
        }
    }

    function addComponent(BreadCrumbComponent $breadCrumbComponent){
        $breadcrumbs = $breadCrumbComponent->breadcrumbs;
        foreach ($breadcrumbs as $breadcrumb){
            $this->breadcrumbs[] = $breadcrumb;
        }
    }

    function formatTitleByParams($params){
        foreach ($this->breadcrumbs as $key => $breadcrumb){
            $this->breadcrumbs[$key]['title'] = sprintf($breadcrumb['title'], $params);
        }
    }

    function output($viewRender = null)
    {
//        if ($this->breadcrumbs) {
//            $output = $this->start;
//            foreach ($this->breadcrumbs as $key => $crumb) {
//                if ($key) {
//                    $output .= $this->separator;
//                }
//                if (end(array_keys($this->breadcrumbs)) == $key) {
//                    $output .= '<span>' . $crumb['title'] . '</span>';
//                } else {
//                    $output .= '<a href="' . $crumb['href'] . '">' . $crumb['title'] . '</a>';
//                }
//            }
//            return $output . $this->end . PHP_EOL;
//        }
//        return '';

        $view = \Config\Services::renderer();
        $view->setData([
            'breadcrumbs' => $this->breadcrumbs
        ]);
        return $view->render($viewRender);
    }
}