<?php
namespace App\Models;

use App\Entities\AccountManager;

class AccountManagerModel extends BaseModel {
    protected $table      = 'account_managers';
    protected $primaryKey = 'account_id';

    protected $allowedFields = ['full_name','account_name','email','account_type_id','avatar_dir','password'];

    protected $returnType = 'App\Entities\AccountManager';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules    = [
        'full_name'     => 'required|min_length[5]|max_length[50]',
        'email'        => 'required|valid_email|is_unique[account_managers.email]',
        'password'     => 'required|min_length[8]',
        'pass_confirm' => 'required|matches[password]'
    ];
    protected $validationMessages = [];
    protected $skipValidation     = true;

    /**
     * @param $email
     * @param $password
     * @return App\Entities\AccountManager|null
     */
    public function checkLogin($email, $password){
        $model = $this->where('email',esc($email))
            ->where('password',md5($password))->first();
        return $model;
    }

    public function getSearch($condition = [], $limit = 20){
        $tableAccountManager = $this::getTableName();
        $tableAccountType = AccountTypeModel::getTableName();
        $queryBuilder = $this->where("$tableAccountManager.del_flg", DELETE_FLG_OFF);
        
        if(isset($condition['full_name']) && $this->checkSearchItem($condition['full_name'])){
            $queryBuilder->like("$tableAccountManager.full_name", esc($condition['full_name']));
        }
        $queryBuilder->join($tableAccountType,"$tableAccountType.type_id = $tableAccountManager.account_type_id");
        $queryBuilder->select("$tableAccountManager.*, $tableAccountType.type_name");
        $queryBuilder->orderBy('created_at desc');
        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }
}