<?php
namespace App\Models;

use App\Helpers\DateHelper;

class ApiDatalogsModel extends BaseModel {
    protected $table      = 'api_datalogs';
    protected $primaryKey = 'id';

    protected $allowedFields = ['api_code', 'product_api_id', 'error_type', 'del_flg'];

    protected $returnType = 'App\Entities\ApiDatalogs';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';


    protected $validationRules    = [
        'product_api_id' => 'required'
    ];


    protected $validationMessages = [];
    protected $skipValidation     = true;

    public function getSearch($condition = [], $limit = 20){
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);
        if($this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where('created_at >=', DateHelper::setFirstHourMinuteDate(esc($condition['from_date'])));
        }
        if($this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where('created_at <=',DateHelper::setLastHourMinuteDate(esc($condition['to_date'])));
        }

        $queryBuilder->orderBy('created_at desc');

        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }

    public function getInfo(){
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);
        $queryBuilder->orderBy('created_at desc');
        return $this->executePaginate($queryBuilder, 1);
    }

    public function apidatalogs_add($data) {
        $tableApiDatalogs = $this::getTableName();
        $query = $this->table($tableApiDatalogs)->insert($data);
        
        return $this->insertID();
    }

    public function getApiLogsCount($error_type){
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);
        $queryBuilder = $this->where('error_type', $error_type);
        $queryBuilder = $this->countAllResults();
        //var_dump($queryBuilder);
        //exit;
        return $queryBuilder;
    }

    public function getTotalCount(){
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);
        $queryBuilder = $this->countAllResults();
        return $queryBuilder;
    }
}