<?php
namespace App\Models;

use App\Helpers\DateHelper;

class ApiPnDetaildataModel extends BaseModel {
    protected $table      = 'api_pndetaildata';
    protected $primaryKey = 'id';
    
    protected $allowedFields = ['api_code','api_partnumber','active_flg'];

    protected $returnType = 'App\Entities\ApiPnDetaildata';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

public function getRsApiId($api_code){
    $queryBuilder = $this->where('active_flg', 0);
    $queryBuilder = $this->like('api_code', $api_code);
    $queryBuilder = $this->select("api_partnumber");
    $queryBuilder = $this->findAll();
    
    return $queryBuilder;
}

public function findByProductSeq($product_api_id){
    $tableProduct = ProductModel::getTableName();
    return $this->where('product_api_id', esc($product_api_id))->select("$tableProduct.maker_seq")->first();
}

public function updateActiveFlg($api_partnumber){
    $queryBuilder = $this->set('active_flg', '1');
    $queryBuilder = $this->where('api_partnumber', $api_partnumber);
    $queryBuilder = $this->update();
 }


}
