<?php
namespace App\Models;

use App\Helpers\DateHelper;

class ApiProductinfoModel extends BaseModel {
    protected $table      = 'api_productinfo';
    protected $primaryKey = 'id';

	protected $allowedFields = ['api_code','api_partnumber','stock','baseUOM','salesUOM','MOQ','InMOQ','packSize','price1','mini_qty1','max_qty1','price2','mini_qty2','max_qty2','price3','mini_qty3','max_qty3', 'price4','mini_qty4','max_qty4','price5','mini_qty5','max_qty5','price6','mini_qty6','max_qty6','del_flg'];

    protected $returnType = 'App\Entities\ApiProductinfo';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules    = [
        'api_code' => 'required',
        'api_partnumber' => 'required|min_length[2]',
    ];
    protected $validationMessages = [];
    protected $skipValidation     = true;

    public function findInfoById($id){
        $tableApiProductinfo = $this::getTableName();
         return $this->where('id', esc($id))->select("$tableApiProductinfo.*")->first();
    }

    
    public function selectAll(){
        return $this->where('del_flg', DELETE_FLG_OFF,true)->findAll();
    }

    public function getAdmin($condition = [], $limit = 20 , $allData = false){

        if(!isset($condition)) $condition = [];
        $tableApiProductinfo = $this::getTableName();
        $queryBuilder = $this->where("$tableApiProductinfo.del_flg", DELETE_FLG_OFF);

        if(isset($condition['from_date']) && $this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where("$tableApiProductinfo.created_at >=", esc($condition['from_date']));
        }
        if(isset($condition['to_date']) && $this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where("$tableApiProductinfo.created_at <=", esc($condition['to_date']));
        }

        if(isset($condition['api_partnumber']) && $this->checkSearchItem($condition['api_partnumber'])){
            $queryBuilder->like("$tableApiProductinfo.api_partnumber", trim($condition['api_partnumber']));
        }

        $queryBuilder->select("$tableApiProductinfo.*");

        if(!isset($limit)) $limit = 20;
        
        if($allData){
            $dataResult = $queryBuilder->findAll($limit);
            return $dataResult;
        }

        $dataResult = $this->executePaginate($queryBuilder, $limit);
        return $dataResult;
    }

    public function getSearch($condition = [], $limit = 20){
        $tableApiProductinfo = $this::getTableName();
        $queryBuilder = $this->where("$tableApiProductinfo.del_flg", DELETE_FLG_OFF);
        
        if($this->checkSearchItem($condition['api_partnumber'])){
            $queryBuilder->like("$tableApiProductinfo.api_partnumber", esc($condition['api_partnumber']));
        }
        if($this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where("$tableApiProductinfo.created_at >=", DateHelper::setFirstHourMinuteDate(esc($condition['from_date'])));
        }
        if($this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where("$tableApiProductinfo.created_at <=",DateHelper::setLastHourMinuteDate(esc($condition['to_date'])));
        }
        
        $queryBuilder->orderBy("$tableApiProductinfo.created_at desc");
        $queryBuilder->select("$tableApiProductinfo.*");

        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }

    public function updateProducts(){
        $updateSql = 'UPDATE products t1, api_productinfo t2 SET t1.qty = t2.stock, t1.packing_code = t2.salesUOM, t1.packsize = t2.packSize, t1.moq = t2.MOQ, t1.in_moq = t2.InMOQ, t1.mpq = t2.packSize, t1.selling_price1 = t2.price1, t1.unit_mini_quantity1 = t2.mini_qty1, t1.unit_max_quantity1 = t2.max_qty1, t1.selling_price2 = t2.price2, t1.unit_mini_quantity2 = t2.mini_qty2, t1.unit_max_quantity2 = t2.max_qty2, t1.selling_price3 = t2.price3, t1.unit_mini_quantity3 = t2.mini_qty3, t1.unit_max_quantity3 = t2.max_qty3, t1.selling_price4 = t2.price4, t1.unit_mini_quantity4 = t2.mini_qty4, t1.unit_max_quantity4 = t2.max_qty4, t1.selling_price5 = t2.price5, t1.unit_mini_quantity5 = t2.mini_qty5, t1.unit_max_quantity5 = t2.max_qty5, t1.selling_price6 = t2.price6, t1.unit_mini_quantity6 = t2.mini_qty6, t1.unit_max_quantity6 = t2.max_qty6, t1.api_updated_at = NOW(), t1.updated_at = NOW() WHERE t1.product_api_id = t2.api_partnumber';

        $this->db->query($updateSql);
    }

    public function insertPndata(){
        $this->db->query('truncate `api_pndata`');
        $insertSql = 'INSERT INTO api_pndata (`api_code`, `api_partnumber`, `active_flg`, `created_at`, `updated_at`) SELECT `api_code`, `product_api_id`, 0, NOW(), NOW() FROM products';
        $this->db->query($insertSql);
    }

}