<?php
namespace App\Models;

use App\Helpers\DateHelper;

class ApiStatusModel extends BaseModel {
    protected $table      = 'api_status';
    protected $primaryKey = 'id';
    
    protected $allowedFields = ['api_code', 'active_flg'];

    protected $returnType = 'App\Entities\ApiStatus';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    
    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = true;

    public function getApiId($api_code, $limit){
        $queryBuilder = $this->where('active_flg', 0);
        $queryBuilder = $this->like('api_code', $api_code);
        return $this->executePaginate($queryBuilder, $limit);
    }

    public function getApiStatus(){
        return $this->where('active_flg', 0)->findAll();
    }

    public function findByApiCode($api_code){
        $tableProduct = ProductModel::getTableName();
        return $this->where('api_code', esc($api_code))->first();
    }

    public function updateActiveFlg($api_code){
        $queryBuilder = $this->set('active_flg', '1');
        $queryBuilder = $this->where('api_code', $api_code);
        $queryBuilder = $this->update();
    }

}
