<?php
namespace App\Models;

class ApiinfoModel extends BaseModel {
    protected $table      = 'api_info';
    protected $primaryKey = 'id';

    protected $allowedFields = ['api_code','provider_name','delivery_days','active_flg','del_flg'];

    protected $returnType = 'App\Entities\Apiinfo';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules    = [
        'provider_name' => 'required',
        'api_code' => 'required',
    ];
    
    protected $validationMessages = [];
    protected $skipValidation     = true;

    public function findInfoById($id){
        $tableApiinfo = $this::getTableName();
        return $this->where('id', esc($id))->select("$tableApiinfo.*")->first();
    }

    public function selectAll(){
        return $this->where('del_flg', DELETE_FLG_OFF,true)->findAll();
    }

    public function getSearch($condition = [], $limit = 20){
        $tableApiinfo = $this::getTableName();
        $queryBuilder = $this->where("$tableApiinfo.del_flg", DELETE_FLG_OFF);
        
        if(isset($condition['api_code']) && $this->checkSearchItem($condition['api_code'])){
            $queryBuilder->where("$tableApiinfo.api_code", esc($condition['api_code']));
        }
        if($this->checkSearchItem($condition['provider_name'])){
            $queryBuilder->like("$tableApiinfo.provider_name", esc($condition['provider_name']));
        }
        if($this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where("$tableApiinfo.created_at >=", DateHelper::setFirstHourMinuteDate(esc($condition['from_date'])));
        }
        if($this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where("$tableApiinfo.created_at <=",DateHelper::setLastHourMinuteDate(esc($condition['to_date'])));
        }
        
        $queryBuilder->orderBy("$tableApiinfo.created_at desc");
        $queryBuilder->select("$tableApiinfo.*");

        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }

    public function findByCategoryInfo($api_code){
        return $this->where('api_code', $api_code)->first();
    }
}