<?php
namespace App\Models;

class BannerinfoFileModel extends BaseModel {
    protected $table      = 'bannerinfo_files';
    protected $primaryKey = 'file_no';

    protected $allowedFields = ['bannerinfos_id','file_name','file_dir'];

    protected $returnType = 'App\Entities\BannerinfoFile';
    protected $useSoftDeletes = false;

    protected $useTimestamps = false;

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function findBannerinfosFile($bannerinfosId, $fileNo){
        return $this->where('file_no', $fileNo)->where('bannerinfos_id', $bannerinfosId)->first();
    }
}