<?php
namespace App\Models;

class BannermainFileModel extends BaseModel {
    protected $table      = 'bannermain_files';
    protected $primaryKey = 'file_no';

    protected $allowedFields = ['bannermains_id','file_name','file_dir'];

    protected $returnType = 'App\Entities\BannermainFile';
    protected $useSoftDeletes = false;

    protected $useTimestamps = false;

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function findBannermainsFile($bannermainsId, $fileNo){
        return $this->where('file_no', $fileNo)->where('bannermains_id', $bannermainsId)->first();
    }
}