<?php
namespace App\Models;

use App\Helpers\DateHelper;

class BannermainModel extends BaseModel {
    protected $table      = 'bannermains';
    protected $primaryKey = 'id';

    protected $allowedFields = ['title','category_id','sub_title','start_date','end_date','goto_URL','goto_type','image_dir','hit_number','active_flg','account_manager_id','public_flg','del_flg'];

    protected $returnType = 'App\Entities\Bannermains';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules    = [
        'category_id' => 'required',
        'title' => 'required|min_length[5]',
        'sub_title' => 'required',
    ];
    
    protected $validationMessages = [];
    protected $skipValidation     = true;

    public function getMainbanner($limit){
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);
        $queryBuilder = $this->where('active_flg', 1);
        $queryBuilder = $this->orderBy('category_id', 'ASC');

        return $this->executePaginate($queryBuilder, $limit);
    }

    public function findInfoById($id){
        $tableBannermains = $this::getTableName();
        $tableCategory = BannermainCategoryModel::getTableName();
        $tableAccountManager = AccountManagerModel::getTableName();
        return $this->where('id', esc($id))->join($tableCategory,"$tableBannermains.category_id = $tableCategory.category_id")
            ->join($tableAccountManager,"$tableAccountManager.account_id = $tableBannermains.account_manager_id")
            ->select("$tableBannermains.* , $tableCategory.category_name , $tableAccountManager.full_name")->first();
    }

    public function getSearch($condition = [], $limit = 20){
        $tableBannermainsCategory = BannermainCategoryModel::getTableName();
        $tableBannermains = $this::getTableName();
        $tableAccountManager = AccountManagerModel::getTableName();
        $queryBuilder = $this->where("$tableBannermains.del_flg", DELETE_FLG_OFF);
        if(isset($condition['category_id']) && $this->checkSearchItem($condition['category_id'])){
            $queryBuilder->where("$tableBannermains.category_id", esc($condition['category_id']));
        }
        if(isset($condition['title']) && $this->checkSearchItem($condition['title'])){
            $queryBuilder->like("$tableBannermains.title", esc($condition['title']));
        }
        if(isset($condition['title']) && $this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where("$tableBannermains.created_at >=", DateHelper::setFirstHourMinuteDate(esc($condition['from_date'])));
        }
        if(isset($condition['to_date']) && $this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where("$tableBannermains.created_at <=",DateHelper::setLastHourMinuteDate(esc($condition['to_date'])));
        }
        $queryBuilder->join($tableBannermainsCategory,"$tableBannermainsCategory.category_id = $tableBannermains.category_id");
        $queryBuilder->join($tableAccountManager,"$tableAccountManager.account_id = $tableBannermains.account_manager_id");
        $queryBuilder->select("$tableBannermains.* , $tableBannermainsCategory.category_name , $tableAccountManager.full_name");
        $queryBuilder->orderBy('created_at desc');
        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }

}