<?php
namespace App\Models;
use App\Helpers\ArrayHelper;
use App\Helpers\NumberHelper;
use CodeIgniter\Database\ConnectionInterface;
use CodeIgniter\Model;
use CodeIgniter\Validation\ValidationInterface;
use function PHPSTORM_META\type;

class BaseModel extends Model{

    protected const TYPE_VARCHAR= 'varchar';

    protected $mergeRuleMaxLength = true;

//    protected $columnCharacterControls = [];
//    protected $beforeInsert = ['beforeInsertData'];
//    protected $beforeUpdate = ['beforeUpdateData'];

//    protected function beforeUpdateData($data){
        //Check replace data before update
//        $fields = $this->db->getFieldData($this::getTableName());
//        if(isset($data) && isset($data['data'])){
//            foreach ($data['data'] as $key => $dataItem){
//                if(is_string($dataItem)){
//                    if(!in_array($key, $this->columnCharacterControls)){
//                        $data['data'][$key] = preg_replace('/[^\PC\s]/u', '', $data['data'][$key]);
//                    }
//                }
//            }
//        }
//    }
    public function getValidationRules(array $options = []): array
    {
        $rules = parent::getValidationRules($options); // TODO: Change the autogenerated stub
        if($this->mergeRuleMaxLength){
            $maxlengthRules = $this->getMaxLengthRules();
            foreach ($maxlengthRules as $name => $rule){
                if(isset($rules[$name])){
                    $ruleValue = $rules[$name];
                    if(is_string($ruleValue) && strpos($ruleValue,'max_length') === false){
                        if(empty($ruleValue)) $rules[$name] = $rule;
                        else $rules[$name] = $ruleValue.'|'.$rule;
                    }
                }
            }
        }
        if (isset($options['except_rule'])){
            $exceptRules = $options['except_rule'];
            foreach ($exceptRules as $key => $exceptRule){
                $ruleItems = explode('|', $rules[$key]);
                $keyExit = ArrayHelper::searchContentValue($ruleItems, $exceptRule);
                if($keyExit){
                    unset($ruleItems[$keyExit]);
                }
                $rules[$key] = implode('|', $ruleItems);
            }
        }
        return $rules;
    }

    public function getMaxLengthRules(){
        $fields = $this->db->getFieldData($this::getTableName());
        $rules = [];
        foreach ($fields as $field){
            $name = $field->name;
            $type = $field->type;
            $length = $field->max_length;
            if(self::TYPE_VARCHAR == $type){
                $rules[$name] = "max_length[$length]";
            }
        }
        return $rules;
    }

    protected function checkSearchItem($value){
        return (isset($value) && !empty($value));
    }

    protected function executePaginate($query, $limit = 20){
        $lists = $query->paginate($limit);
        $data = [
            'lists' => $lists,
            'pager' => $query->pager,
            'currentPage' => $query->pager->getCurrentPage(),
            'perPage' => $query->pager->getPerPage(),
            'pageUri' => $query->pager->getPageURI(),
            'nextPageUri' =>  $query->pager->getNextPageURI(),
            'nextPageUri' =>  $query->pager->getNextPageURI(),
            'previousPageUri' => $query->pager->getPreviousPageURI(),
            'totalRow' => $query->pager->getDetails()['total'],
            'totalRowStr' => NumberHelper::format($query->pager->getDetails()['total']),
        ];
        return $data;
    }

    public function getTable(){
        return $this->table;
    }

    public static function getTableName(){
        return (new static)->getTable();
    }

    public function getMaxId(){
        $model = $this->selectMax($this->primaryKey)->first();
        if(isset($model)){
            return $model->{$this->primaryKey};
        }
        return 1;
    }
}