<?php
namespace App\Models;

class Categorylevel2Model extends BaseModel {
	protected $table = 'categorylevel2';
	protected $primaryKey = 'categorylevel2_id';

	protected $allowedFields = ['categorylevel1_id', 'categorylevel2_code', 'categorylevel1_code', 'categorylevel2_name', 'categorylevel2_name_eng', 'active_flg', 'del_flg'];

	public function findByCategoryCode($category_category2_code){
        return $this->where('categorylevel2_code', $category_category2_code)->first();
    }

    public function findByCategoryName($categorylevel2_name){
        return $this->where('categorylevel2_name', $categorylevel2_name)->first();
    }

	public function findByCategoryInfo($categorylevel2_name_eng){
        return $this->where('categorylevel2_name_eng', $categorylevel2_name_eng)->first();
    }

	public function getCategory2List($category_category_code){
        return $this->where('categorylevel1_code', $category_category_code)->where('del_flg', 0)->findAll();
    }
}