<?php
namespace App\Models;

use App\Helpers\DateHelper;

class CategorysCollectModel extends BaseModel {
    protected $table      = 'categorysCollect';
    protected $primaryKey = 'seq_id';

    protected $allowedFields = ['level1_id','level1_name','level1_product_quantity','level2_id','level2_name','level2_product_quantity','del_flg'];

    protected $returnType = 'App\Entities\CategorysCollect';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = '';

    protected $validationRules    = [];
    protected $validationMessages = [];

    protected $skipValidation     = true;

    public function getSearch($limit = 20, $level1_id){
        $tableCategorysCollect = $this::getTableName();

        $queryBuilder = $this->where("$tableCategorysCollect.level1_id", $level1_id);
        if(isset($condition['level1_id']) && $this->checkSearchItem($condition['level1_id'])){
            $queryBuilder->like("$tableCategorysCollect.level1_id", esc($condition['level1_id']));
        }
        $queryBuilder->select("$tableCategorysCollect.*");
        $queryBuilder->orderBy('lcreated_at desc');
        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }


    public function getSearchtest($condition = [],$limit = 20, $level1_id){
        $tableCategorysCollect = $this::getTableName();

        $queryBuilder = $this->where("$tableCategorysCollect.level1_id", $level1_id);
        if(isset($condition['level1_name']) && $this->checkSearchItem($condition['level1_name'])){
            $queryBuilder->like("$tableCategorysCollect.level1_name", esc($condition['level1_name']));
        }
        $queryBuilder->select("$tableCategorysCollect.*");
        $queryBuilder->orderBy('created_at desc');
        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }

    
    public function getAdmSearch($condition = [], $limit = 20){
        $tableCategorysCollect = $this::getTableName();

        $queryBuilder = $this->where("$tableCategorysCollect.del_flg", DELETE_FLG_OFF);
        if(isset($condition['level1_id']) && $this->checkSearchItem($condition['level1_id'])){
            $queryBuilder->like("$tableCategorysCollect.level1_id", esc($condition['level1_id']));
        }
        if(isset($condition['level1_id']) && $this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where("$tableCategorysCollect.created_at >=", DateHelper::setFirstHourMinuteDate(esc($condition['from_date'])));
        }
        if(isset($condition['to_date']) && $this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where("$tableCategorysCollect.created_at <=",DateHelper::setLastHourMinuteDate(esc($condition['to_date'])));
        }
        $queryBuilder->select("$tableCategorysCollect.*");
        $queryBuilder->orderBy('created_at desc');
        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }


}