<?php
namespace App\Models;

class DeferredpayFileModel extends BaseModel {
    protected $table      = 'deferredpay_files';
    protected $primaryKey = 'file_no';

    protected $allowedFields = ['deferredpay_id','file_name','file_dir'];

    protected $returnType = 'App\Entities\DeferredpayFile';
    protected $useSoftDeletes = false;

    protected $useTimestamps = false;

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function findDeferredpayFile($deferredpaysId, $fileNo){
        return $this->where('file_no', $fileNo)->where('deferredpay_id', $deferredpaysId)->first();
    }
}