<?php
namespace App\Models;

use App\Helpers\DateHelper;

class DeliverycodeModel extends BaseModel {
    protected $table      = 'deliverycodes';
    protected $primaryKey = 'id';

    protected $allowedFields = ['title','category_id','info','price','public_flg','del_flg'];

    protected $returnType = 'App\Entities\Deliverycodes';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules    = [
        'category_id' => 'required',
        'title' => 'required|min_length[2]',
    ];
    
    protected $validationMessages = [];
    protected $skipValidation     = true;

    public function findInfoById($id){
        $tableDeliverycodes = $this::getTableName();
        $tableCategory = DeliverycodeCategoryModel::getTableName();
        $tableAccountManager = AccountManagerModel::getTableName();
        return $this->where('id', esc($id))->join($tableCategory,"$tableDeliverycodes.category_id = $tableCategory.category_id")
            ->select("$tableDeliverycodes.* , $tableCategory.category_name")->first();
    }

    public function getSearch($condition = [], $limit = 20){
        $tableDeliverycodesCategory = DeliverycodeCategoryModel::getTableName();
        $tableDeliverycodes = $this::getTableName();
        $tableAccountManager = AccountManagerModel::getTableName();
        $queryBuilder = $this->where("$tableDeliverycodes.del_flg", DELETE_FLG_OFF);
        if(isset($condition['category_id']) && $this->checkSearchItem($condition['category_id'])){
            $queryBuilder->where("$tableDeliverycodes.category_id", esc($condition['category_id']));
        }
        if(isset($condition['title']) && $this->checkSearchItem($condition['title'])){
            $queryBuilder->like("$tableDeliverycodes.title", esc($condition['title']));
        }
        if(isset($condition['title']) && $this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where("$tableDeliverycodes.created_at >=", DateHelper::setFirstHourMinuteDate(esc($condition['from_date'])));
        }
        if(isset($condition['to_date']) && $this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where("$tableDeliverycodes.created_at <=",DateHelper::setLastHourMinuteDate(esc($condition['to_date'])));
        }
        $queryBuilder->join($tableDeliverycodesCategory,"$tableDeliverycodesCategory.category_id = $tableDeliverycodes.category_id");
        $queryBuilder->select("$tableDeliverycodes.* , $tableDeliverycodesCategory.category_name");
        $queryBuilder->orderBy('created_at desc');
        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }

    public function findByCategoryInfo($delivery_code){
        return $this->where('id', $delivery_code)->first();
    }

}