<?php
namespace App\Models;

class EstimateFileModel extends BaseModel {
    protected $table      = 'estimate_files';
    protected $primaryKey = 'file_no';

    protected $allowedFields = ['estimate_id','file_name','file_dir'];

    protected $returnType = 'App\Entities\EstimateFile';
    protected $useSoftDeletes = false;

    protected $useTimestamps = false;

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function findEstimateFile($estimatesId, $fileNo){
        return $this->where('file_no', $fileNo)->where('estimate_id', $estimatesId)->first();
    }
}