<?php
namespace App\Models;

use App\Helpers\DateHelper;

class EstimatePartinfoModel extends BaseModel {
    protected $table      = 'estimate_partinfo';
    protected $primaryKey = 'estimate_id';

    protected $allowedFields = ['estimate_code','inquiry_code','member_id','part_sequence','category3_code','part_number','name','qty','price','q_qty','q_price','purchase_price','amount','stock_location','delivery_code','check_flg','active_flg','del_flg'];

    protected $returnType = 'App\Entities\EstimatePartinfo';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules    = [
        'inquiry_code'      => 'required',
        'part_number'       => 'required',
        'name'              => 'required',
        'qty'               => 'required'
    ];

    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function getSearch(){
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);
        $dataResult = $this->executePaginate($queryBuilder);

        return $dataResult;
    }

    public function getPartinfo($inquiry_code){
        $queryBuilder = $this->where('estimate_code', NULL);
        $queryBuilder = $this->where('inquiry_code', $inquiry_code);
        $queryBuilder = $this->where('active_flg', 0);
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);
        $queryBuilder = $this->orderBy('created_at desc');
        $dataResult = $this->executePaginate($queryBuilder);
        return $dataResult;
    }

    public function getEstimateParts($estimate_code){
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);
        $queryBuilder = $this->where('estimate_code', $estimate_code);
        $queryBuilder = $this->where('active_flg', 0);
        $queryBuilder = $this->orderBy('created_at desc');
        $dataResult = $this->executePaginate($queryBuilder);
        return $dataResult;
    }

    public function getChkPartinfo($inquiry_code){
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);
        $queryBuilder = $this->where('inquiry_code', $inquiry_code);
        $queryBuilder = $this->where('check_flg', 1);
        $queryBuilder = $this->where('active_flg', 0);
        $queryBuilder = $this->orderBy('created_at desc');
        $dataResult = $this->executePaginate($queryBuilder);
        return $dataResult;
    }

    public function getPartinfoCount($inquiry_code){
        $queryBuilder = $this->where('estimate_code', NULL);
        $queryBuilder = $this->where('inquiry_code', $inquiry_code);
        $queryBuilder = $this->where('active_flg', 0);
        $queryBuilder = $this->where('del_flg', 0);
        $queryBuilder = $this->countAllResults();
        return $queryBuilder;
    }


    public function deleteEstimateId($estimate_id){
        $this->delete(['estimate_id' => $estimate_id]);
    }

    public function offByCheckFlg($inquiry_code){
        $queryBuilder = $this->set('check_flg', '0');
        $queryBuilder = $this->where('inquiry_code', $inquiry_code);
        $queryBuilder = $this->update();
     }



     /*
     public function updatePartinfo($inquiry_code, $estimate_code){
        $queryBuilder = $this->set('estimate_code', $estimate_code);
        $queryBuilder = $this->where('inquiry_code', $inquiry_code);
        $queryBuilder = $this->update();
     }
        */

     public function updateQPartinfo($estimate_id, $q_qty, $q_price){
        $queryBuilder = $this->set('q_qty', $q_qty);
        $queryBuilder = $this->set('q_price', $q_price);
        $queryBuilder = $this->where('estimate_id', $estimate_id);
        $queryBuilder = $this->update();
     }
     
     public function updateCodeinfo($inquiry_code, $estimate_code){
        $queryBuilder = $this->set('estimate_code', $estimate_code);
        $queryBuilder = $this->where('estimate_code', NULL);
        $queryBuilder = $this->where('inquiry_code', $inquiry_code);
        $queryBuilder = $this->where('active_flg', 0);
        $queryBuilder = $this->where('del_flg', 0);
        $queryBuilder = $this->update();
     }

     public function updateIdActiveFlg($inquiry_code, $estimateids){
        $queryBuilder = $this->set('active_flg', '1');
        $queryBuilder = $this->where('inquiry_code', $inquiry_code);
        $queryBuilder = $this->where('estimate_id', $estimateids);
        $queryBuilder = $this->update();
     }

    public function updateByActiveFlg($inquiry_code){
        $queryBuilder = $this->set('active_flg', '1');
        $queryBuilder = $this->where('inquiry_code', $inquiry_code);
        $queryBuilder = $this->update();
     }

    public function getEstimatepartinfo($inquiry_code){
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);
        $queryBuilder = $this->where('inquiry_code', $inquiry_code);
        $queryBuilder = $this->where('active_flg', 1);
        $queryBuilder = $this->orderBy('created_at desc');

        $dataResult = $this->executePaginate($queryBuilder);
        return $dataResult;
    }

    public function findByEstimateId($estimate_id){
        $tableEstimate = $this::getTableName();
        return $this->where('estimate_id', esc($estimate_id))->select("$tableEstimate.*")->first();
    }

    public function estimate_update($where, $data) {
        $this->db->table($this->table)->update($data, $where);
        return $this->db->affectedRows();
    }
 
    /*
    public function deleteById($id) {
        $this->db->table($this->table)->delete(array('estimate_id' => $id)); 
    }
    */

}