<?php
namespace App\Models;

use App\Helpers\DateHelper;

class EventinfoModel extends BaseModel {
    protected $table      = 'event_info';
    protected $primaryKey = 'id';

	protected $allowedFields = ['event_title', 'event_start_date', 'event_end_date','width_size','height_size','file_dir','display_type', 'display_status', 'active_flg','del_flg'];

    protected $returnType = 'App\Entities\Eventinfo';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules    = [
        'event_title' => 'required|min_length[5]',
    ];
    protected $validationMessages = [];
    protected $skipValidation     = true;

    public function findInfoById($id){
        $tableEventinfo = $this::getTableName();
        return $this->where('id', esc($id))->select("$tableEventinfo.*")->first();
    }
    
    public function selectAll(){
        return $this->where('del_flg', DELETE_FLG_OFF,true)->findAll();
    }

    public function getEventinfo(){
        return $this->where('del_flg', DELETE_FLG_OFF,true)->where('display_status', 1)->orderBy('id', 'ASC')->findAll();
    }

    public function getSearch($condition = [], $limit = 20){
        $tableEventinfo = $this::getTableName();
        $queryBuilder = $this->where("$tableEventinfo.del_flg", DELETE_FLG_OFF);
        
        if($this->checkSearchItem($condition['event_title'])){
            $queryBuilder->like("$tableEventinfo.event_title", esc($condition['event_title']));
        }
        if($this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where("$tableEventinfo.created_at >=", DateHelper::setFirstHourMinuteDate(esc($condition['from_date'])));
        }
        if($this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where("$tableEventinfo.created_at <=",DateHelper::setLastHourMinuteDate(esc($condition['to_date'])));
        }
        
        $queryBuilder->orderBy("$tableEventinfo.created_at desc");
        $queryBuilder->select("$tableEventinfo.*");

        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }

}