<?php
namespace App\Models;

use App\Helpers\DateHelper;

class IcKingPndataModel extends BaseModel {
    protected $table      = 'icking_pndata';
    protected $primaryKey = 'id';
    
    protected $allowedFields = ['api_code','keyword','partnumber','active_flg'];

    protected $returnType = 'App\Entities\IcKingPndata';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = true;

    public function getIcKingId($api_code){
        $queryBuilder = $this->where('active_flg', 0);
        $queryBuilder = $this->like('api_code', $api_code);
        $queryBuilder = $this->select("keyword");
        $queryBuilder = $this->findAll();
        
        return $queryBuilder;
    }

    public function getPnStatus(){
        return $this->where('active_flg', 0)->findAll();
    }

    public function updateActiveFlg($keyword){
        $queryBuilder = $this->set('active_flg', '1');
        $queryBuilder = $this->where('keyword', $keyword);
        $queryBuilder = $this->update();

        return $queryBuilder;
    }

}