<?php
namespace App\Models;

use App\Helpers\DateHelper;

class InCategorylevel1Model extends BaseModel {
	protected $table = 'categorylevel1';
	protected $primaryKey = 'categorylevel1_id';
    protected $allowedFields = ['categorylevel1_code','categorylevel1_name', 'categorylevel1_name_eng', 'active_flg', 'del_flg'];

    protected $returnType = 'App\Entities\Categorylevel1';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules    = [
        'categorylevel1_name'     => 'required|min_length[5]|max_length[50]',
        'categorylevel1_id'        => 'required|valid_code|is_unique[categorylevel1.categorylevel1_id]'
    ];

    protected $validationMessages = [
        'is_unique' => 'Sorry. That code has already been taken. Please choose another.'
    ];

    protected $skipValidation     = true;

	public function findByCategoryCode($part_category_code){
        return $this->where('categorylevel1_code', $part_category_code)->first();
    }
	
	public function findByCategoryInfo($categorylevel1_name_eng){
        return $this->where('categorylevel1_name_eng', $categorylevel1_name_eng)->first();
    }

	public function getSearch($condition = [], $limit = 20){
        $tableCategorylevel1 = $this::getTableName();
        $queryBuilder = $this->where("$tableCategorylevel1.del_flg", DELETE_FLG_OFF);
        
        if($this->checkSearchItem($condition['categorylevel1_name'])){
            $queryBuilder->like("$tableCategorylevel1.categorylevel1_name", esc($condition['categorylevel1_name']));
        }

        $queryBuilder->orderBy("$tableCategorylevel1.created_at desc");
        $queryBuilder->select("$tableCategorylevel1.*");

        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }

    public function getSearchExl($limit){
        if(!isset($condition)) $condition = [];
        $tableCategorylevel1 = $this::getTableName();
        $queryBuilder = $this->where("$tableCategorylevel1.del_flg", DELETE_FLG_OFF);
        
        if($this->checkSearchItem($condition['categorylevel1_name'])){
            $queryBuilder->like("$tableCategorylevel1.categorylevel1_name", esc($condition['categorylevel1_name']));
        }
        
        $queryBuilder->select("$tableCategorylevel1.*");
        $queryBuilder->orderBy("$tableCategorylevel1.created_at desc");
        $dataResult = $this->executePaginate($queryBuilder, $limit);

        return $dataResult;
    }
}
