<?php
namespace App\Models;

use App\Helpers\DateHelper;

class InCategorylevel2Model extends BaseModel {
	protected $table = 'categorylevel2';
	protected $primaryKey = 'categorylevel2_id';

    protected $allowedFields = ['categorylevel1_id', 'categorylevel2_code', 'categorylevel1_code', 'categorylevel2_name', 'categorylevel2_name_eng', 'active_flg', 'del_flg'];

    protected $returnType = 'App\Entities\Categorylevel2';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules    = [
        'categorylevel2_name'     => 'required|min_length[5]|max_length[50]',
        'categorylevel2_id'        => 'required|valid_code|is_unique[categorylevel2.categorylevel2_id]'
    ];

    protected $validationMessages = [
        'is_unique' => 'Sorry. That code has already been taken. Please choose another.'
    ];

    protected $skipValidation     = true;

	public function findByCategoryName($part_category2_code){
        return $this->where('categorylevel2_code', $part_category2_code)->first();
    }

	public function findByCategoryInfo($categorylevel2_name_eng){
        return $this->where('categorylevel2_name_eng', $categorylevel2_name_eng)->first();
    }

	public function getCategory2List($part_category_code){
        return $this->where('categorylevel1_code', $part_category_code)->findAll();
    }

    public function getSearch($condition = [], $limit = 20){

        $tableCategorylevel2 = $this::getTableName();
        $queryBuilder = $this->where("$tableCategorylevel2.del_flg", DELETE_FLG_OFF);
        
        if ($condition['categorylevel1_code']) {
            $queryBuilder->where("$tableCategorylevel2.categorylevel1_code", esc($condition['categorylevel1_code']));
        }

        if($this->checkSearchItem($condition['categorylevel2_name'])){
            $queryBuilder->like("$tableCategorylevel2.categorylevel2_name", esc($condition['categorylevel2_name']));
        }

        $queryBuilder->orderBy("$tableCategorylevel2.created_at desc");

        $queryBuilder->select("$tableCategorylevel2.*");

        if(!isset($limit)) $limit = 20;

        return $this->executePaginate($queryBuilder, $limit);
    }

    public function getSearchExl($limit){
        if(!isset($condition)) $condition = [];
        $tableCategorylevel2 = $this::getTableName();
        $queryBuilder = $this->where("$tableCategorylevel2.del_flg", DELETE_FLG_OFF);

        if($this->checkSearchItem($condition['categorylevel2_name'])){
            $queryBuilder->like("$tableCategorylevel2.categorylevel2_name", esc($condition['categorylevel2_name']));
        }

        $queryBuilder->select("$tableCategorylevel2.*");
        $queryBuilder->orderBy("$tableCategorylevel2.created_at desc");
        $dataResult = $this->executePaginate($queryBuilder, $limit);

        return $dataResult;
    }

}