<?php
namespace App\Models;

use App\Helpers\DateHelper;

class InCategorylevel3Model extends BaseModel {
    protected $table      = 'categorylevel3';
    protected $primaryKey = 'categorylevel3_id';
    protected $allowedFields = ['categorylevel2_id', 'categorylevel3_code', 'categorylevel2_code', 'categorylevel3_name', 'categorylevel3_name_eng', 'categorylevel3_name_eng',  'active_flg', 'del_flg'];

    protected $returnType = 'App\Entities\Categorylevel3';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules    = [
        'categorylevel3_name'     => 'required|min_length[5]|max_length[50]',
        'categorylevel3_id'        => 'required|valid_code|is_unique[categorylevel3.categorylevel3_id]'
    ];

    protected $validationMessages = [
        'is_unique' => 'Sorry. That code has already been taken. Please choose another.'
    ];

    protected $skipValidation     = true;


    public function getSearch($condition = [], $limit = 20, $categorylevel3_id){
        $tableCategorylevel3 = InCategorylevel3Model::getTableName();
        $tableCategorylevel3 = $this::getTableName();
        $tableMember = MemberModel::getTableName();
        // var_dump($tableCategorylevel3);
        // var_dump($member_id);

        $queryBuilder = $this->where("$tableCategorylevel3.del_flg", DELETE_FLG_OFF);
        $queryBuilder->where("$tableCategorylevel3.categorylevel3_id", $categorylevel3_id);

        if(isset($condition['categorylevel3_id']) && $this->checkSearchItem($condition['categorylevel3_id'])){
            $queryBuilder->where("$tableCategorylevel3.categorylevel3_id", esc($condition['categorylevel3_id']));
        }
        if(isset($condition['categorylevel3_name']) && $this->checkSearchItem($condition['categorylevel3_name'])){
            $queryBuilder->like("$tableCategorylevel3.categorylevel3_name", esc($condition['categorylevel3_name']));
        }
        if(isset($condition['categorylevel3_name']) && $this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where("$tableCategorylevel3.created_at >=", DateHelper::setFirstHourMinuteDate(esc($condition['from_date'])));
        }
        if(isset($condition['to_date']) && $this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where("$tableCategorylevel3.created_at <=",DateHelper::setLastHourMinuteDate(esc($condition['to_date'])));
        }

        $queryBuilder->select("$tableCategorylevel3.*");
        $queryBuilder->orderBy('created_at desc');

        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }


    public function getAdmSearch($condition = [], $limit = 20){
        $tableCategorylevel3 = InCategorylevel3Model::getTableName();
        $tableCategorylevel3 = $this::getTableName();
        $tableMember = MemberModel::getTableName();
        // var_dump($tableCategorylevel3);

        $queryBuilder = $this->where("$tableCategorylevel3.del_flg", DELETE_FLG_OFF);

        if(isset($condition['categorylevel3_id']) && $this->checkSearchItem($condition['categorylevel3_id'])){
            $queryBuilder->where("$tableCategorylevel3.categorylevel3_id", esc($condition['categorylevel3_id']));
        }
        if(isset($condition['categorylevel3_name']) && $this->checkSearchItem($condition['categorylevel3_name'])){
            $queryBuilder->like("$tableCategorylevel3.categorylevel3_name", esc($condition['categorylevel3_name']));
        }
        if(isset($condition['categorylevel3_name']) && $this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where("$tableCategorylevel3.created_at >=", DateHelper::setFirstHourMinuteDate(esc($condition['from_date'])));
        }
        if(isset($condition['to_date']) && $this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where("$tableCategorylevel3.created_at <=",DateHelper::setLastHourMinuteDate(esc($condition['to_date'])));
        }

        $queryBuilder->select("$tableCategorylevel3.*");
        $queryBuilder->orderBy('created_at desc');

        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }


}