<?php
namespace App\Models;

class InquiryFileModel extends BaseModel {
    protected $table      = 'inquiry_files';
    protected $primaryKey = 'file_no';

    protected $allowedFields = ['inquiry_id','file_name','file_dir'];

    protected $returnType = 'App\Entities\InquiryFile';
    protected $useSoftDeletes = false;

    protected $useTimestamps = false;

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function findInquiryFile($inquirysId, $fileNo){
        return $this->where('file_no', $fileNo)->where('inquiry_id', $inquirysId)->first();
    }
}