<?php
namespace App\Models;

use App\Helpers\DateHelper;

class InquiryInfoModel extends BaseModel {
    protected $table      = 'inquiries_info';
    protected $primaryKey = 'info_id';

    protected $allowedFields = ['inquiry_code','member_id','name','email','tel','title','memo_content','payment_mode','active_flg','del_flg'];

    protected $returnType = 'App\Entities\InquiryInfo';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    /*
    protected $validationRules    = [
        'inquiry_code'      => 'required',
        'name'              => 'required',
        'email'             => 'required|valid_email',
        'tel'               => 'required',
        'title'             => 'required',
        'memo_content'      => 'required'
    ];
    */

    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function getSearch($condition = [], $limit = 20){
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);
        if($this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where('created_at >=', DateHelper::setFirstHourMinuteDate(esc($condition['from_date'])));
        }
        if($this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where('created_at <=',DateHelper::setLastHourMinuteDate(esc($condition['to_date'])));
        }
        $queryBuilder->orderBy('created_at desc');
        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }


    public function getInquiryinfo($CALL_ID){
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);
        $queryBuilder = $this->where('member_id', $CALL_ID);
        $queryBuilder = $this->where('active_flg', 0);
        $queryBuilder = $this->orderBy('created_at desc');

        $dataResult = $this->executePaginate($queryBuilder);
        return $dataResult;
    }

    public function updateByActiveFlg($CALL_ID){
        $queryBuilder = $this->set('active_flg', '1');
        $queryBuilder = $this->where('member_id', $CALL_ID);
        $queryBuilder = $this->where('active_flg', 0);
        $queryBuilder = $this->update();
     }

     public function getPrintinfo($CALL_ID, $IQRY_NO){
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);
        $queryBuilder = $this->where('member_id', $CALL_ID);
        $queryBuilder = $this->where('inquiry_code', $IQRY_NO);
        $queryBuilder = $this->where('active_flg', 1);
        $queryBuilder = $this->orderBy('created_at desc');

        $dataResult = $this->executePaginate($queryBuilder);
        return $dataResult;
    }

    public function printByActiveFlg($CALL_ID, $IQRY_NO){
        $queryBuilder = $this->set('active_flg', '2');
        $queryBuilder = $this->where('member_id', $CALL_ID);
        $queryBuilder = $this->where('inquiry_code', $IQRY_NO);
        $queryBuilder = $this->where('active_flg', 1);
        $queryBuilder = $this->update();
     }

    public function findByInquiryId($info_id){
        $tableInquiry = $this::getTableName();
        return $this->where('info_id', esc($info_id))->select("$tableInquiry.*")->first();
    }

    public function findByInquiryCode($inquiry_code){
        $tableInquiry = $this::getTableName();
        return $this->where('inquiry_code', esc($inquiry_code))->select("$tableInquiry.*")->first();
    }

    public function findByInquiryUser($phone_num){
        $tableInquiry = $this::getTableName();
        return $this->where('tel', esc($phone_num))->select("$tableInquiry.*")->first();
    }

}