<?php
namespace App\Models;

use App\Helpers\DateHelper;

class InquiryModel extends BaseModel {
    protected $table      = 'inquiry';
    protected $primaryKey = 'id';

    protected $allowedFields = ['title','category_id','situation','item_code','part_number','manufacturer_name','member_code','user_name','user_email','replyemeil_chk','user_phone','password','content','answer_content','hit_number','public_flg','account_manager_id','active_flg','answer_created_at','del_flg'];

    protected $returnType = 'App\Entities\Inquiry';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';


    protected $validationRules    = [
        'category_id' => 'required',
        'title' => 'required|min_length[5]',
        'content' => 'required',
    ];


    protected $validationMessages = [];
    protected $skipValidation     = true;


    public function findInfoById($id){
        $tableInquiry = $this::getTableName();
        $tableCategory = InquiryCategoryModel::getTableName();
        return $this->where('id', esc($id))->join($tableCategory,"$tableInquiry.category_id = $tableCategory.category_id")
            ->select("$tableInquiry.* , $tableCategory.category_name")->first();
    }

    public function getSearch($condition = [], $limit = 20){
        $tableInquiryCategory = InquiryCategoryModel::getTableName();
        $tableInquiry = $this::getTableName();
        // $tableAccountManager = AccountManagerModel::getTableName();
        $queryBuilder = $this->where("$tableInquiry.del_flg", DELETE_FLG_OFF);
        if(isset($condition['category_id']) && $this->checkSearchItem($condition['category_id'])){
            $queryBuilder->where("$tableInquiry.category_id", esc($condition['category_id']));
        }
        if(isset($condition['title']) && $this->checkSearchItem($condition['title'])){
            $queryBuilder->like("$tableInquiry.title", esc($condition['title']));
        }
        if(isset($condition['title']) && $this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where("$tableInquiry.created_at >=", DateHelper::setFirstHourMinuteDate(esc($condition['from_date'])));
        }
        if(isset($condition['to_date']) && $this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where("$tableInquiry.created_at <=",DateHelper::setLastHourMinuteDate(esc($condition['to_date'])));
        }

        // 관리자 정보 사용
        // $queryBuilder->join($tableInquiryCategory,"$tableInquiryCategory.category_id = $tableInquiry.category_id");
        // $queryBuilder->join($tableAccountManager,"$tableAccountManager.account_id = $tableInquiry.account_manager_id");
        // $queryBuilder->select("$tableInquiry.* , $tableInquiryCategory.category_name , $tableAccountManager.full_name");
        // $queryBuilder->orderBy('created_at desc');

        $queryBuilder->join($tableInquiryCategory,"$tableInquiryCategory.category_id = $tableInquiry.category_id");
        $queryBuilder->select("$tableInquiry.* , $tableInquiryCategory.category_name");
        $queryBuilder->orderBy('created_at desc');


        if(!isset($limit)) $limit = 20;

        return $this->executePaginate($queryBuilder, $limit);
    }

    public function getSearchSale($itemCode, $limit = 10){
        $tableInquiryCategory = InquiryCategoryModel::getTableName();
        $tableInquiry = $this::getTableName();
        $queryBuilder = $this->where("$tableInquiry.del_flg", DELETE_FLG_OFF);

        $queryBuilder->like("$tableInquiry.item_code", $itemCode);

        $queryBuilder->join($tableInquiryCategory,"$tableInquiryCategory.category_id = $tableInquiry.category_id");
        $queryBuilder->select("$tableInquiry.* , $tableInquiryCategory.category_name");
        $queryBuilder->orderBy('created_at desc');


        if(!isset($limit)) $limit = 10;
        return $this->executePaginate($queryBuilder, $limit);
    }


    public function getSearchCount($condition = [],$situation){
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);
        $queryBuilder = $this->where('situation', $situation);
        if(isset($condition['category_id']) && $this->checkSearchItem($condition['category_id'])){
            $queryBuilder->where('category_id', esc($condition['category_id']));
        }
        if(isset($condition['title']) && $this->checkSearchItem($condition['title'])){
            $queryBuilder->like('title', esc($condition['title']));
        }
        if(isset($condition['title']) && $this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where('created_at >=', DateHelper::setFirstHourMinuteDate(esc($condition['from_date'])));
        }
        if(isset($condition['to_date']) && $this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where('created_at <=',DateHelper::setLastHourMinuteDate(esc($condition['to_date'])));
        }

        $queryBuilder = $this->countAllResults();
        return $queryBuilder;
    }

    public function inquiry_add($data) {
        $tableInquiry = $this::getTableName();
        $query = $this->table($tableInquiry)->insert($data);
        
        return $this->insertID();
    }

}