<?php
namespace App\Models;

class LeadtimeCategoryModel extends BaseModel {
    protected $table      = 'leadtime_categories';
    protected $primaryKey = 'leadtime_id';

    protected $allowedFields = ['days','leadtime_info','leadtime_info_eng','active_flg','del_flg'];

    protected $returnType = 'App\Entities\LeadtimeCategory';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules    = [
        'leadtime_info' => 'required',
        'days' => 'required',
    ];
    
    protected $validationMessages = [];
    protected $skipValidation     = true;

    public function getSearch($condition = [], $limit = 20){
        $tableLeadtimeCategory = $this::getTableName();
        $queryBuilder = $this->where("$tableLeadtimeCategory.del_flg", DELETE_FLG_OFF);
        if(isset($condition['leadtime_info']) && $this->checkSearchItem($condition['leadtime_info'])){
            $queryBuilder->like("$tableLeadtimeCategory.leadtime_info", esc($condition['leadtime_info']));
        }
        $queryBuilder->orderBy('created_at desc');
        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }

    public function findByCategoryInfo($days){
        return $this->where('days', $days)->first();
    }

    public function findInfoById($leadtime_id){
        return $this->where('leadtime_id', $leadtime_id)->first();
    }


}