<?php
namespace App\Models;

use App\Helpers\DateHelper;

class MemberInquiryModel extends BaseModel {
    protected $table      = 'member_inquiries';
    protected $primaryKey = 'inquiry_id';

    protected $allowedFields = ['name','email','tel','title','memo_content','del_flg'];

    protected $returnType = 'App\Entities\MemberInquiry';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules    = [
        'name'     => 'required',
        'email'    => 'required|valid_email',
        'tel'      => 'required',
        'title' => 'required',
        'memo_content' => 'required'
    ];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function getSearch($condition = [], $limit = 20){
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);
        if($this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where('created_at >=', DateHelper::setFirstHourMinuteDate(esc($condition['from_date'])));
        }
        if($this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where('created_at <=',DateHelper::setLastHourMinuteDate(esc($condition['to_date'])));
        }
        $queryBuilder->orderBy('created_at desc');
        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }
}