<?php
namespace App\Models;

use App\Helpers\DateHelper;

class MemberModel extends BaseModel {
    protected $table      = 'members';
    protected $primaryKey = 'member_id';

    protected $allowedFields = ['member_code','member_name','member_email','password','category_id','member_phone',
                    'member_zipcode','member_address1','member_address2','last_login_date','api_type','avatar_dir',
                    'active_flg','del_flg', 'access_code', 'access_flg', 'password_random'];

    protected $returnType = 'App\Entities\Member';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules    = [
        'member_name'     => 'required|min_length[2]|max_length[50]',
        'member_email'        => 'required|valid_email|is_unique[members.member_email]',
        'password'     => 'required|min_length[8]|max_length[20]|contain_alpha_and_numeric',
        'pass_confirm' => 'required|matches[password]'
    ];
    protected $validationMessages = [
        'is_unique' => 'Sorry. That email has already been taken. Please choose another.'
    ];
    protected $skipValidation     = true;

    public function findByEmail($email){
        $model = $this->where('del_flg', DELETE_FLG_OFF)
            ->where('active_flg', MEMBER_ACCEPT_ON)
            ->where('member_email',$email)->first();
        return $model;
    }

    public function findByAccessCode($accessCode){
        $model = $this->where('del_flg', DELETE_FLG_OFF)
            ->where('access_code',$accessCode)->first();
        return $model;
    }

    public function checkLogin($email, $password){
        $model = $this->where('del_flg', DELETE_FLG_OFF)
            ->where('active_flg', MEMBER_ACCEPT_ON)
            ->where('member_email',esc($email))
            ->where('password',md5($password))->first();
        return $model;
    }

    public function checkCode($member_code, $password){
        $model = $this->where('del_flg', DELETE_FLG_OFF)
            ->where('active_flg', MEMBER_ACCEPT_ON)
            ->where('member_code',esc($member_code))
            ->where('password',md5($password))->first();
        return $model;
    }

    public function checkNeverLogin($email, $mobile){
        $model = $this->where('del_flg', DELETE_FLG_OFF)
            ->where('active_flg', MEMBER_ACCEPT_ON)
            ->where('member_email',esc($email))
            ->where('member_phone',esc($mobile))->first();
        return $model;
    }

    public function checkSNSLogin($email, $name){
        $model = $this->where('del_flg', DELETE_FLG_OFF)
            ->where('active_flg', MEMBER_ACCEPT_ON)
            ->where('member_email',esc($email))
            ->where('member_name',esc($name))->first();
        return $model;
    }

    public function checkLoginCode($member_code){
        $model = $this->where('del_flg', DELETE_FLG_OFF)
            ->where('active_flg', MEMBER_ACCEPT_ON)
            ->where('member_code',esc($member_code))->first();
        return $model;
    }

    public function getSearch($condition = [], $limit = 20){
        $tableMember = $this::getTableName();
        $queryBuilder = $this->where("$tableMember.del_flg", DELETE_FLG_OFF);
        if($this->checkSearchItem($condition['member_name'])){
            $queryBuilder->like("$tableMember.member_name", esc($condition['member_name']));
        }
        if($this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where("$tableMember.created_at >=", DateHelper::setFirstHourMinuteDate(esc($condition['from_date'])));
        }
        if($this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where("$tableMember.created_at <=",DateHelper::setLastHourMinuteDate(esc($condition['to_date'])));
        }
        $queryBuilder->orderBy("$tableMember.created_at desc");
        $queryBuilder->select("$tableMember.*");
        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }

    public function getSearchExl($limit){

        if(!isset($condition)) $condition = [];
        $tableMember = $this::getTableName();
        $queryBuilder = $this->where("$tableMember.del_flg", DELETE_FLG_OFF);

        if($this->checkSearchItem($condition['member_name'])){
            $queryBuilder->like("$tableMember.member_name", esc($condition['member_name']));
        }

        $queryBuilder->select("$tableMember.*");
        $queryBuilder->orderBy("$tableMember.created_at desc");
        $dataResult = $this->executePaginate($queryBuilder, $limit);

        return $dataResult;
    }

}