<?php
namespace App\Models;

use App\Helpers\DateHelper;

class MemberSubModel extends BaseModel {
    protected $table      = 'members_sub';
    protected $primaryKey = 'id';

    protected $allowedFields = ['member_code','com_name','com_englishname','biz_number','ceo_name','com_zipcode','com_address1','com_address2',
                'com_phone','com_fax','invoice_email','homepage','sectors','condition','account_bankname',
                'account_number','account_depositor','del_flg'];

    protected $returnType = 'App\Entities\MemberSub';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    // protected $validationRules    = [ ];

    protected $validationMessages = [
        'is_unique' => 'Sorry. That email has already been taken. Please choose another.'
    ];
    protected $skipValidation     = true;

    public function findByMemberCode($membercode){
        $model = $this->where('del_flg', DELETE_FLG_OFF)
            ->where('member_code',$membercode)->first();
        return $model;
    }

    public function findByAccessCode($accessCode){
        $model = $this->where('del_flg', DELETE_FLG_OFF)
            ->where('access_code',$accessCode)->first();
        return $model;
    }

    public function getSearch($condition = [], $limit = 20){
        $tableMemberSub = $this::getTableName();
        $queryBuilder = $this->where("$tableMemberSub.del_flg", DELETE_FLG_OFF);
        if($this->checkSearchItem($condition['member_name'])){
            $queryBuilder->like("$tableMemberSub.member_name", esc($condition['member_name']));
        }
        if($this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where("$tableMemberSub.created_at >=", DateHelper::setFirstHourMinuteDate(esc($condition['from_date'])));
        }
        if($this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where("$tableMemberSub.created_at <=",DateHelper::setLastHourMinuteDate(esc($condition['to_date'])));
        }
        $queryBuilder->orderBy("$tableMemberSub.created_at desc");
        $queryBuilder->select("$tableMemberSub.*");
        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }
}