<?php
namespace App\Models;

class One2oneFileModel extends BaseModel {
    protected $table      = 'one2one_files';
    protected $primaryKey = 'file_no';

    protected $allowedFields = ['one2one_id','file_name','file_dir'];

    protected $returnType = 'App\Entities\One2oneFile';
    protected $useSoftDeletes = false;

    protected $useTimestamps = false;

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function findOne2oneFile($one2onesId, $fileNo){
        return $this->where('file_no', $fileNo)->where('one2one_id', $one2onesId)->first();
    }
}