<?php
namespace App\Models;

use App\Helpers\DateHelper;

class One2oneModel extends BaseModel {
    protected $table      = 'one2one';
    protected $primaryKey = 'id';

    protected $allowedFields = ['title','category_id','situation','member_code','user_name','user_email','replyemeil_chk','user_phone','password','content','answer_content','hit_number','public_flg','account_manager_id','active_flg','answer_created_at','del_flg'];


    protected $returnType = 'App\Entities\One2one';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';


    protected $validationRules    = [
        'category_id' => 'required',
        'title' => 'required|min_length[5]',
        'content' => 'required',
    ];


    protected $validationMessages = [];
    protected $skipValidation     = true;


    public function findInfoById($id){
        $tableOne2one = $this::getTableName();
        $tableCategory = One2oneCategoryModel::getTableName();
        return $this->where('id', esc($id))->join($tableCategory,"$tableOne2one.category_id = $tableCategory.category_id")
            ->select("$tableOne2one.* , $tableCategory.category_name")->first();
    }

    public function getSearch($condition = [], $limit = 20){
        $tableOne2oneCategory = One2oneCategoryModel::getTableName();
        $tableOne2one = $this::getTableName();
        $queryBuilder = $this->where("$tableOne2one.del_flg", DELETE_FLG_OFF);
        if(isset($condition['category_id']) && $this->checkSearchItem($condition['category_id'])){
            $queryBuilder->where("$tableOne2one.category_id", esc($condition['category_id']));
        }
        if(isset($condition['title']) && $this->checkSearchItem($condition['title'])){
            $queryBuilder->like("$tableOne2one.title", esc($condition['title']));
        }
        if(isset($condition['title']) && $this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where("$tableOne2one.created_at >=", DateHelper::setFirstHourMinuteDate(esc($condition['from_date'])));
        }
        if(isset($condition['to_date']) && $this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where("$tableOne2one.created_at <=",DateHelper::setLastHourMinuteDate(esc($condition['to_date'])));
        }

        $queryBuilder->join($tableOne2oneCategory,"$tableOne2oneCategory.category_id = $tableOne2one.category_id");
        $queryBuilder->select("$tableOne2one.* , $tableOne2oneCategory.category_name");
        $queryBuilder->orderBy('created_at desc');


        if(!isset($limit)) $limit = 20;

        return $this->executePaginate($queryBuilder, $limit);
    }

    public function getSearchMem($condition = [], $limit = 20){
        $tableOne2oneCategory = One2oneCategoryModel::getTableName();
        $tableOne2one = $this::getTableName();
        $queryBuilder = $this->where("$tableOne2one.del_flg", DELETE_FLG_OFF);
        $queryBuilder = $this->where("$tableOne2one.member_code", $condition['member_code']);

        if(isset($condition['category_id']) && $this->checkSearchItem($condition['category_id'])){
            $queryBuilder->where("$tableOne2one.category_id", esc($condition['category_id']));
        }
        if(isset($condition['title']) && $this->checkSearchItem($condition['title'])){
            $queryBuilder->like("$tableOne2one.title", esc($condition['title']));
        }
        if(isset($condition['title']) && $this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where("$tableOne2one.created_at >=", DateHelper::setFirstHourMinuteDate(esc($condition['from_date'])));
        }
        if(isset($condition['to_date']) && $this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where("$tableOne2one.created_at <=",DateHelper::setLastHourMinuteDate(esc($condition['to_date'])));
        }

        $queryBuilder->join($tableOne2oneCategory,"$tableOne2oneCategory.category_id = $tableOne2one.category_id");
        $queryBuilder->select("$tableOne2one.* , $tableOne2oneCategory.category_name");
        $queryBuilder->orderBy('created_at desc');


        if(!isset($limit)) $limit = 20;

        return $this->executePaginate($queryBuilder, $limit);
    }

    public function getSearchMemCount($condition = [],$situation){
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);
        $queryBuilder = $this->where('member_code', $condition['member_code']);
        $queryBuilder = $this->where('situation', $situation);
        if(isset($condition['category_id']) && $this->checkSearchItem($condition['category_id'])){
            $queryBuilder->where('category_id', esc($condition['category_id']));
        }
        if(isset($condition['title']) && $this->checkSearchItem($condition['title'])){
            $queryBuilder->like('title', esc($condition['title']));
        }
        if(isset($condition['title']) && $this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where('created_at >=', DateHelper::setFirstHourMinuteDate(esc($condition['from_date'])));
        }
        if(isset($condition['to_date']) && $this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where('created_at <=',DateHelper::setLastHourMinuteDate(esc($condition['to_date'])));
        }

        $queryBuilder = $this->countAllResults();
        return $queryBuilder;
    }


}