<?php
namespace App\Models;

use App\Helpers\DateHelper;

class OrderInfoModel extends BaseModel {
    protected $table      = 'orders_info';
    protected $primaryKey = 'info_id';

    protected $allowedFields = ['order_code','order_type','order_status','member_code','orderer_name','orderer_email','orderer_phone','shipping_recipient','shipping_name','delivery_phone','shipping_phone','company_name','shipping_zipocode',
    'shipping_add1','shipping_add2','shipping_message','notice','invoice_type','invoice_com','invoice_biznum','invoice_ceo','ship_method_flg','ship_code','ship_company','ship_date','invoice_num','firstitem_code','firstitem_number','firstitem_image',
    'item_counts','supply_price','vat','amount_total','delivery_fee','delivery_date','change_flg','refund_flg','payment_date','payment_flg','deposit_name','deposit_bank','deposit_date','resultCode','resultMsg','tid','MOID','TotPrice',
    'goodName','applDate','applTime','payMethod','applNum','P_FN_NM','VACT_Num','VACT_BankCode','vactBankName','VACT_Date','payDevice','sales_proof_flg','amount_payment','taxinvoice_status','taxinvoice_created','active_flg','del_flg'];

    protected $returnType = 'App\Entities\OrderInfo';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    /*
    protected $validationRules    = [
        'order_code'        => 'required',
        'orderer_name'      => 'required',
        'orderer_email'     => 'required|valid_email',
        'orderer_phone'     => 'required',
        'shipping_message'  => 'required',
        'notice'            => 'required'
    ];
    */

    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function getSearch($condition = [], $limit = 20){
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);
        if($this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where('created_at >=', DateHelper::setFirstHourMinuteDate(esc($condition['from_date'])));
        }
        if($this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where('created_at <=',DateHelper::setLastHourMinuteDate(esc($condition['to_date'])));
        }

        if($this->checkSearchItem($condition['status_code'])){
            $queryBuilder = $this->where('order_status', esc($condition['status_code']));
        }
        
        $queryBuilder->orderBy('created_at desc');

        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }

    public function getBuyerOrder($condition = [], $limit = 20){
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);
        $queryBuilder->like("member_code", trim($condition['member_code']));
        $queryBuilder->orderBy('created_at desc');

        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }

    public function getBuyerSearch($condition = [], $limit = 20){
        $tableOrderInfo = $this::getTableName();
        $tableMember = MemberModel::getTableName();
        $queryBuilder = $this->where("$tableOrderInfo.del_flg", DELETE_FLG_OFF);

        if($this->checkSearchItem($condition['keyword'])){
            $queryBuilder->like('orderer_name', esc($condition['keyword']));
        }

        $queryBuilder->join($tableMember,"$tableMember.member_code = $tableOrderInfo.member_code");
        $queryBuilder->distinct();
        $queryBuilder->select("$tableMember.member_id, $tableOrderInfo.member_code, $tableMember.member_name, $tableMember.member_email, $tableMember.created_at");
        $queryBuilder->orderBy("$tableOrderInfo.created_at desc");

        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }

    public function getSearchExcel($condition = [], $limit = 30000 , $allData = false){
        if(!isset($condition)) $condition = [];

        $tableOrderInfo = $this::getTableName();
        $tableOrderStatus = OrderStatusModel::getTableName();
        $queryBuilder = $this->where("$tableOrderInfo.del_flg", DELETE_FLG_OFF);

        if ($condition['keyword_item']) {
            if($condition['keyword_item'] == "order_code"){
                $queryBuilder->like('order_code', esc($condition['keyword']));
            }
            if($condition['keyword_item'] == "orderer_name"){
                $queryBuilder->like('orderer_name', esc($condition['keyword']));
            }
            if($condition['keyword_item'] == "orderer_email"){
                $queryBuilder->like('orderer_email', esc($condition['keyword']));
            }
            if($condition['keyword_item'] == "orderer_phone"){
                $queryBuilder->like('orderer_phone', esc($condition['keyword']));
            }
        
        } elseif ($condition['status_code']) {
                $queryBuilder = $this->where('order_status', esc($condition['status_code']));

        } else {
            if(isset($condition['from_date']) && $this->checkSearchItem($condition['from_date'])){
                $queryBuilder->where("$tableOrderInfo.created_at >=", esc($condition['from_date']));
            }
            if(isset($condition['to_date']) && $this->checkSearchItem($condition['to_date'])){
                $queryBuilder->where("$tableOrderInfo.created_at <=", esc($condition['to_date']));
            }
            if(isset($condition['status_code']) && $this->checkSearchItem($condition['status_code'])){
                $queryBuilder->like("$tableOrderInfo.status_code", trim($condition['status_code']));
            }

        }

        $queryBuilder->join($tableOrderStatus,"$tableOrderStatus.status_code = $tableOrderInfo.order_status");
        $queryBuilder->select("$tableOrderInfo.*, $tableOrderStatus.status_info");
        $queryBuilder->orderBy("$tableOrderInfo.created_at desc");

        if(!isset($limit)) $limit = 30000;

        if($allData){
            $dataResult = $queryBuilder->findAll($limit);
            return $dataResult;
        }

        $dataResult = $this->executePaginate($queryBuilder, $limit);
        return $dataResult;
    }


    public function getTexExcel($item_id_array) {
        if(!isset($condition)) $condition = [];

        $tableOrderInfo = $this::getTableName();
        $queryBuilder = $this->where("$tableOrderInfo.del_flg", DELETE_FLG_OFF);
        $queryBuilder = $this->whereIn('info_id', $item_id_array);

        $queryBuilder->select('"01" AS info_id, DATE_FORMAT(NOW(), "%Y%m%d") AS order_code, "2158735572" AS order_type, "" AS order_status, "주식회사 셀파세미컴" AS member_code, "김현철" AS orderer_name, "경기도 남양주시 다산중앙로 19번길 21(다산동 다산진건블루웨일지식산업센터1차 F223 F224호)" AS orderer_email, "도소매 제조업" AS orderer_phone, "전자부품 수출입업" AS shipping_recipient, "selpa@selpasemicom.com" AS shipping_name,
            REPLACE(invoice_biznum, "-" , "") AS delivery_phone, "" AS shipping_phone, invoice_com AS company_name,  invoice_ceo AS shipping_zipocode, CONCAT(shipping_add1, shipping_add2) AS shipping_add1, "" AS shipping_add2, "" AS shipping_message, orderer_email AS notice, "" AS invoice_com, supply_price AS invoice_biznum, vat AS invoice_ceo, "" AS ship_method_flg,
            DATE_FORMAT(created_at, "%d") AS ship_code, CONCAT(firstitem_number, IF(item_counts > 1, ".외", "")) AS ship_company, "" AS ship_date, "" AS invoice_num, "" AS firstitem_code, IF(item_counts > 1, "", supply_price) AS firstitem_number, IF(item_counts > 1, "", vat) AS firstitem_image, "0" AS VACT_BankCode, "0" AS vactBankName, "0" AS VACT_Date, (supply_price + vat) AS payDevice, "02" AS sales_proof_flg');

        $queryBuilder->orderBy("$tableOrderInfo.created_at desc");

        if(!isset($limit)) $limit = 30000;

        $dataResult = $this->executePaginate($queryBuilder, $limit);
        return $dataResult;
    }

    public function getSearchKeyword($condition = [], $limit = 20){
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);

        if($condition['keyword_item'] == "order_code"){
            $queryBuilder->like('order_code', esc($condition['keyword']));
        }
        if($condition['keyword_item'] == "orderer_name"){
            $queryBuilder->like('orderer_name', esc($condition['keyword']));
        }
        if($condition['keyword_item'] == "orderer_email"){
            $queryBuilder->like('orderer_email', esc($condition['keyword']));
        }
        if($condition['keyword_item'] == "orderer_phone"){
            $queryBuilder->like('orderer_phone', esc($condition['keyword']));
        }

        $queryBuilder->orderBy('created_at desc');

        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }

    public function getSearchPartinfo($condition = [], $limit = 20){
        $tableOrderInfo = $this::getTableName();
        $tableOrderPartinfo = OrderPartinfoModel::getTableName();
        
        $queryBuilder = $this->like("$tableOrderPartinfo.part_number", esc($condition['keyword']));

        $queryBuilder->join($tableOrderPartinfo,"$tableOrderPartinfo.order_code = $tableOrderInfo.order_code  AND  $tableOrderPartinfo.item_code = $tableOrderInfo.firstitem_code");
        $queryBuilder->select("$tableOrderInfo.* , $tableOrderPartinfo.part_number");
        
        $queryBuilder->orderBy('created_at desc');

        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }

    public function getSearchTax($condition = [], $limit = 20){
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);
        if($this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where('created_at >=', DateHelper::setFirstHourMinuteDate(esc($condition['from_date'])));
        }
        if($this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where('created_at <=',DateHelper::setLastHourMinuteDate(esc($condition['to_date'])));
        }

        if($this->checkSearchItem($condition['status_code'])){
            $queryBuilder = $this->where('order_status', esc($condition['status_code']));
        }
        $queryBuilder = $this->where('invoice_biznum !=',"");
        $queryBuilder = $this->where('order_status !=',"12");
        $queryBuilder->orderBy('created_at desc');

        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }

    public function getSearchKeywordTax($condition = [], $limit = 20){
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);

        if($condition['keyword_item'] == "order_code"){
            $queryBuilder->like('order_code', esc($condition['keyword']));
        }
        if($condition['keyword_item'] == "orderer_name"){
            $queryBuilder->like('orderer_name', esc($condition['keyword']));
        }
        if($condition['keyword_item'] == "orderer_email"){
            $queryBuilder->like('orderer_email', esc($condition['keyword']));
        }
        if($condition['keyword_item'] == "orderer_phone"){
            $queryBuilder->like('orderer_phone', esc($condition['keyword']));
        }
        $queryBuilder = $this->where('invoice_biznum !=',"");
        $queryBuilder = $this->where('order_status !=',"12");
        $queryBuilder->orderBy('created_at desc');

        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }

    public function getSearchPartinfoTax($condition = [], $limit = 20){
        $tableOrderInfo = $this::getTableName();
        $tableOrderPartinfo = OrderPartinfoModel::getTableName();
        
        $queryBuilder = $this->like("$tableOrderPartinfo.part_number", esc($condition['keyword']));
        $queryBuilder->join($tableOrderPartinfo,"$tableOrderPartinfo.order_code = $tableOrderInfo.order_code  AND  $tableOrderPartinfo.item_code = $tableOrderInfo.firstitem_code");
        $queryBuilder->select("$tableOrderInfo.* , $tableOrderPartinfo.part_number");
        $queryBuilder = $this->where('invoice_biznum !=',"");
        $queryBuilder = $this->where('order_status !=',"12");
        $queryBuilder->orderBy('created_at desc');

        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }

    public function getSearchMem($condition = [], $limit = 20){
        $tableOrderInfo = $this::getTableName();
        $tableOrderPartinfo = OrderPartinfoModel::getTableName();

        $queryBuilder = $this->where("$tableOrderInfo.del_flg", DELETE_FLG_OFF);
        $queryBuilder = $this->where("$tableOrderInfo.member_code", esc($condition['member_code']));

        if($this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where("$tableOrderInfo.created_at >=",DateHelper::setLastHourMinuteDate(esc($condition['from_date'])));
        }
        if($this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where("$tableOrderInfo.created_at <=",DateHelper::setLastHourMinuteDate(esc($condition['to_date'])));
        }

        $queryBuilder->join($tableOrderPartinfo,"$tableOrderPartinfo.order_code = $tableOrderInfo.order_code  AND  $tableOrderPartinfo.item_code = $tableOrderInfo.firstitem_code");
        $queryBuilder->select("$tableOrderInfo.* , $tableOrderPartinfo.part_number");
        
        $queryBuilder->orderBy('created_at desc');

        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }

    public function findInfoById($orderInfoId){
        $tableOrder = $this::getTableName();
        return $this->where('info_id', esc($orderInfoId))->select("$tableOrder.*")->first();
    }

    public function findByOrderCode($order_code){
        $tableOrder = $this::getTableName();
        return $this->where('order_code', esc($order_code))->select("$tableOrder.*")->first();
    }

    public function findOrder($order_code,$orderer_email){
        $tableOrder = $this::getTableName();
        return $this->where('order_code', esc($order_code))->where('orderer_email', esc($orderer_email))->select("$tableOrder.*")->first();
    }

    public function findByOrderUser($phone_num){
        $tableOrder = $this::getTableName();
        return $this->where('orderer_phone', esc($phone_num))->select("$tableOrder.*")->first();
    }


    public function updateStatus($order_code, $order_status){
        $queryBuilder = $this->set('order_status', $order_status);
        $queryBuilder = $this->where('order_code', $order_code);
        $queryBuilder = $this->update();
     }


}
