<?php
namespace App\Models;

use App\Helpers\DateHelper;

class PackagingUnitModel extends BaseModel {
    protected $table      = 'packaging_unit';
    protected $primaryKey = 'packing_id';

    protected $allowedFields = ['supplier_code','packing_code','packing_name','packing_name_eng','active_flg','del_flg'];

    protected $returnType = 'App\Entities\PackagingUnit';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules    = [
        'supplier_code' => 'required',
        'packing_code' => 'required',
    ];
    
    protected $validationMessages = [];
    protected $skipValidation     = true;

    public function getSearch($condition = [], $limit = 20){
        $tablePackagingunit = $this::getTableName();
        $queryBuilder = $this->where("$tablePackagingunit.del_flg", DELETE_FLG_OFF);
        if(isset($condition['packing_code']) && $this->checkSearchItem($condition['packing_code'])){
            $queryBuilder->where("$tablePackagingunit.packing_code", esc($condition['packing_code']));
        }
        if(isset($condition['packing_name']) && $this->checkSearchItem($condition['packing_name'])){
            $queryBuilder->like("$tablePackagingunit.packing_name", esc($condition['packing_name']));
        }
        $queryBuilder->orderBy('created_at desc');
        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }

    public function findByCategoryInfo($packing_code){
        return $this->where('packing_id', $packing_code)->first();
    }

    public function findByPackingName($packing_name_eng){
        return $this->where('packing_name_eng', $packing_name_eng)->first();
    }

}