<?php
namespace App\Models;

use App\Helpers\DateHelper;

class PackingcodeModel extends BaseModel {
    protected $table      = 'packing_code';
    protected $primaryKey = 'id';

	protected $allowedFields = ['use','code','kor_name','eng_name','active_flg','del_flg'];

    protected $returnType = 'App\Entities\Packingcode';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules    = [
        'code' => 'required',
        'kor_name' => 'required|min_length[2]',
        'eng_name' => 'required',
    ];
    protected $validationMessages = [];
    protected $skipValidation     = true;

    public function findInfoById($id){
        $tablePackingcode = $this::getTableName();
        return $this->where('id', esc($id))->select("$tablePackingcode.*")->first();
    }

    public function findByPackingName($eng_name){
        return $this->where('eng_name', $eng_name)->first();
    }
    
    public function selectAll(){
        return $this->where('del_flg', DELETE_FLG_OFF,true)->findAll();
    }

    public function getSearch($condition = [], $limit = 20){
        $tablePackingcode = $this::getTableName();
        $queryBuilder = $this->where("$tablePackingcode.del_flg", DELETE_FLG_OFF);
        
        if($this->checkSearchItem($condition['kor_name'])){
            $queryBuilder->like("$tablePackingcode.kor_name", esc($condition['kor_name']));
        }
        if($this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where("$tablePackingcode.created_at >=", DateHelper::setFirstHourMinuteDate(esc($condition['from_date'])));
        }
        if($this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where("$tablePackingcode.created_at <=",DateHelper::setLastHourMinuteDate(esc($condition['to_date'])));
        }
        
        $queryBuilder->orderBy("$tablePackingcode.created_at desc");
        $queryBuilder->select("$tablePackingcode.*");

        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }

}