<?php
namespace App\Models;

use App\Helpers\ArrayHelper;
use http\QueryString;

class ProductExportModel extends BaseModel {
    protected $table      = 'products';
    protected $primaryKey = 'product_id';
    
    protected $allowedFields = ['product_code','part_category','part_category2','part_category3','maker_seq','maker_name','location_code','display_set','newproduct_chk','bestproduct_chk',
        'recomproduct_chk','brandproduct_chk','event_set','part_number','part_number_sequence','search_word','brief_description','situation','exposure','product_related','replacement_items',
        'date_code','image_dir','delivery_code','api_flg','api_code','tariff_rate','product_api_id','qty','packing_code','packing_name','packsize','wearing_price','price','margin_rate',
        'discount_rate','leadtime','moq','in_moq','mpq','stock_location','taxable','selling_price1','prices_price1','prices_currency1','margin_rate1','unit_mini_quantity1','unit_max_quantity1',
        'selling_price2','prices_price2','prices_currency2','margin_rate2','unit_mini_quantity2','unit_max_quantity2','selling_price3','prices_price3','prices_currency3','margin_rate3','unit_mini_quantity3','unit_max_quantity3',
        'selling_price4','prices_price4','prices_currency4','margin_rate4','unit_mini_quantity4','unit_max_quantity4','selling_price5','prices_price5','prices_currency5','margin_rate5','unit_mini_quantity5','unit_max_quantity5',
        'selling_price6','prices_price6','prices_currency6','margin_rate6','unit_mini_quantity6','unit_max_quantity6','navershop_chk','navershop_status','qty_flag','virtualpn','active_flg','del_flg','api_updated_at'];

    //protected $returnType = 'App\Entities\Product';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    /*
    protected $validationRules    = [
        'part_number' => 'required|min_length[3]',
        'qty' => 'required|alpha_numeric',
        'id' => 'required',
    ];
    */

    protected $validationMessages = [];
    protected $skipValidation     = true;

    /*
    public function save($data): bool{
        $data->part_number_sequence = strrev($data->part_number);
        return parent::save($data);
    }
    */

    public function getAdmin($condition = [], $limit = 20 , $allData = false){

        if(!isset($condition)) $condition = [];
        // var_dump($condition);

        $tableProduct = ProductModel::getTableName();
        $tableManufacturer = ManufacturerModel::getTableName();

        $queryBuilder = $this->where("$tableProduct.del_flg", DELETE_FLG_OFF);
        //$queryBuilder = $this->where("$tableProduct.exposure", DELETE_FLG_OFF);

        if(isset($condition['from_date']) && $this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where("$tableProduct.created_at >=", esc($condition['from_date']));
        }
        if(isset($condition['to_date']) && $this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where("$tableProduct.created_at <=", esc($condition['to_date']));
        }

        if(isset($condition['part_number']) && $this->checkSearchItem($condition['part_number'])){
            $queryBuilder->like("$tableProduct.part_number", trim($condition['part_number']));
        }

        if(isset($condition['search_code']) && $this->checkSearchItem($condition['search_code'])){
            $queryBuilder->like("$tableProduct.part_category", trim($condition['search_code']));
        }

        if(isset($condition['part_category']) && $this->checkSearchItem($condition['part_category'])){
            $queryBuilder->like("$tableProduct.part_category", trim($condition['part_category']));
        }
        
        if(isset($condition['part_category2']) && $this->checkSearchItem($condition['part_category2'])){
            $queryBuilder->like("$tableProduct.part_category2", trim($condition['part_category2']));
        }

        if(isset($condition['part_category3']) && $this->checkSearchItem($condition['part_category3'])){
            $queryBuilder->like("$tableProduct.part_category3", trim($condition['part_category3']));
        }

        $queryBuilder->select("$tableProduct.*");

        if($condition['sort'] == "recent") {
            // var_dump($condition['sort']);
            $queryBuilder->orderBy("$tableProduct.created_at desc");
        } elseif($condition['sort'] == "hprice") {
            // var_dump($condition['sort']);
            $queryBuilder->orderBy("$tableProduct.selling_price1 desc");
        } elseif($condition['sort'] == "lprice") {
            // var_dump($condition['sort']);
            $queryBuilder->orderBy("$tableProduct.selling_price1 ASC");
        } elseif($condition['sort'] == "brand") {
            // var_dump($condition['sort']);
            $queryBuilder->orderBy("$tableProduct.maker_seq ASC");
        } else {
            $queryBuilder->orderBy("$tableProduct.created_at desc");
        }


        if(!isset($limit)) $limit = 20;
        if($allData){
            $dataResult = $queryBuilder->findAll($limit);
            if(count($dataResult) > 0){
                //Get data manufacturer for product
                $manufacturerModel = new ManufacturerModel();
                $listManufacturer = $manufacturerModel->findAll();
                if(count($listManufacturer) > 0){
                    $mapManufacturer = ArrayHelper::parseListObjectToArrayKey($listManufacturer,'maker_seq');
                    foreach ($dataResult as $product){
                        if(isset($mapManufacturer[$product->maker_seq])){
                            $manufacturer = $mapManufacturer[$product->maker_seq];
                            $product->maker_code = $manufacturer->maker_code;
                            $product->name = $manufacturer->name;
                        }
                    }
                }

                $deliverycodeModel = new DeliverycodeModel();
                $listdeliverycodes = $deliverycodeModel->findAll();
                if(count($listdeliverycodes) > 0){
                    $mapDeliverycode = ArrayHelper::parseListObjectToArrayKey($listdeliverycodes,'id');
                    foreach ($dataResult['lists'] as $product){
                        if(isset($mapDeliverycode[$product->delivery_code])){
                            $deliverycode = $mapDeliverycode[$product->delivery_code];
                            $product->delivery_code = $deliverycode->id;
                            $product->delivery_info = $deliverycode->info;
                            $product->delivery_price = $deliverycode->price;
                            
                        }
                    }
                }

                $stocklocationCategoryModel = new StocklocationCategoryModel();
                $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
                if(count($liststocklocationCategorys) > 0){
                    $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
                    foreach ($dataResult['lists'] as $product){
                        if(isset($mapStocklocationCategory[$product->stock_location])){
                            $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                            $product->stock_location = $stocklocationCategory->location_id;
                            $product->location_info = $stocklocationCategory->location_info;
                            
                        }
                    }
                }

                $stocklocationCategoryModel = new StocklocationCategoryModel();
                $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
                if(count($liststocklocationCategorys) > 0){
                    $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
                    foreach ($dataResult['lists'] as $product){
                        if(isset($mapStocklocationCategory[$product->stock_location])){
                            $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                            $product->stock_location = $stocklocationCategory->location_id;
                            $product->location_info = $stocklocationCategory->location_info;
                            
                        }
                    }
                }

                $leadtimeCategoryModel = new LeadtimeCategoryModel();
                $listleadtimeCategorys = $leadtimeCategoryModel->findAll();
                if(count($listleadtimeCategorys) > 0){
                    $mapLeadtimeCategory = ArrayHelper::parseListObjectToArrayKey($listleadtimeCategorys,'leadtime_id');
                    foreach ($dataResult['lists'] as $product){
                        if(isset($mapLeadtimeCategory[$product->leadtime])){
                            $leadtimeCategory = $mapLeadtimeCategory[$product->leadtime];
                            $product->leadtime = $leadtimeCategory->leadtime_id;
                            $product->leadtime_info = $leadtimeCategory->leadtime_info;
                            
                        }
                    }
                }                
    
            }
            return $dataResult;
        }


        $dataResult = $this->executePaginate($queryBuilder, $limit);
 
    // MDI2020 test
    //var_dump($dataResult);

        if(count($dataResult['lists']) > 0){
            //Get data manufacturer for product
            $manufacturerModel = new ManufacturerModel();
            $listManufacturer = $manufacturerModel->findAll();
            //var_dump($listManufacturer);
            //exit;
            if(count($listManufacturer) > 0){
                $mapManufacturer = ArrayHelper::parseListObjectToArrayKey($listManufacturer,'maker_seq');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapManufacturer[$product->maker_seq])){
                        $manufacturer = $mapManufacturer[$product->maker_seq];
                        $product->maker_code = $manufacturer->maker_code;
                        $product->name = $manufacturer->name;

                    }
                }
            }

            $deliverycodeModel = new DeliverycodeModel();
            $listdeliverycodes = $deliverycodeModel->findAll();
            if(count($listdeliverycodes) > 0){
                $mapDeliverycode = ArrayHelper::parseListObjectToArrayKey($listdeliverycodes,'id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapDeliverycode[$product->delivery_code])){
                        $deliverycode = $mapDeliverycode[$product->delivery_code];
                        $product->delivery_code = $deliverycode->id;
                        $product->delivery_info = $deliverycode->info;
                        $product->delivery_price = $deliverycode->price;
                        
                    }
                }
            }

            $stocklocationCategoryModel = new StocklocationCategoryModel();
            $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
            if(count($liststocklocationCategorys) > 0){
                $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapStocklocationCategory[$product->stock_location])){
                        $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                        $product->stock_location = $stocklocationCategory->location_id;
                        $product->location_info = $stocklocationCategory->location_info;
                        
                    }
                }
            }         
                        
            $leadtimeCategoryModel = new LeadtimeCategoryModel();
            $listleadtimeCategorys = $leadtimeCategoryModel->findAll();
            if(count($listleadtimeCategorys) > 0){
                $mapLeadtimeCategory = ArrayHelper::parseListObjectToArrayKey($listleadtimeCategorys,'leadtime_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapLeadtimeCategory[$product->leadtime])){
                        $leadtimeCategory = $mapLeadtimeCategory[$product->leadtime];
                        $product->leadtime = $leadtimeCategory->leadtime_id;
                        $product->leadtime_info = $leadtimeCategory->leadtime_info;
                        
                    }
                }
            }   

            //var_dump($product);
            //exit;
        }

      if(count($dataResult['lists']) > 0){

      }

        return $dataResult;
    }

/******************************************************************************************/

/** 쿼리향상 테스트 **/
public function getSearch($condition = [], $limit = 20 , $allData = false){

    if(!isset($condition)) $condition = [];

    $tableProduct = ProductModel::getTableName();
    $tableManufacturer = ManufacturerModel::getTableName();
    $tableCategorylevel1 = Categorylevel1Model::getTableName();
    $tableCategorylevel2 = Categorylevel2Model::getTableName();
    $tableCategorylevel3 = Categorylevel3Model::getTableName();



    $queryBuilder = $this->where("$tableProduct.del_flg", DELETE_FLG_OFF);
    $queryBuilder = $this->where("$tableProduct.exposure", DELETE_FLG_OFF);

    if(isset($condition['from_date']) && $this->checkSearchItem($condition['from_date'])){
        $queryBuilder->where("$tableProduct.created_at >=", esc($condition['from_date']));
    }
    if(isset($condition['to_date']) && $this->checkSearchItem($condition['to_date'])){
        $queryBuilder->where("$tableProduct.created_at <=", esc($condition['to_date']));
    }

    if(isset($condition['keyword']) && $this->checkSearchItem($condition['keyword'])){
            //$queryBuilder->join($tableManufacturer,"$tableManufacturer.maker_seq = $tableProduct.maker_seq");

            $str = preg_replace("/\s+/", "", $condition['keyword']);
            $keyword = str_replace(array("/", "-", "_", "[", "]", "(", ")", "."), '', $str);

            if(isset($condition['search_code']) && $this->checkSearchItem($condition['search_code'])) {
                $queryBuilder->where("$tableProduct.part_category", trim($condition['search_code']));
            }

            $queryBuilder->like("$tableProduct.virtualpn", trim($keyword));

            //$queryBuilder->orlike("$tableManufacturer.name", trim($condition['keyword']));

    }

    if(isset($condition['part_number']) && $this->checkSearchItem($condition['part_number'])){
        $queryBuilder->like("$tableProduct.part_number", trim($condition['part_number']));
    }

    if(isset($condition['part_category']) && $this->checkSearchItem($condition['part_category'])){
        $queryBuilder->like("$tableProduct.part_category", trim($condition['part_category']));
    }
    
    if(isset($condition['part_category2']) && $this->checkSearchItem($condition['part_category2'])){
        $queryBuilder->like("$tableProduct.part_category2", trim($condition['part_category2']));
    }

    if(isset($condition['part_category3']) && $this->checkSearchItem($condition['part_category3'])){
        $queryBuilder->like("$tableProduct.part_category3", trim($condition['part_category3']));
    }
    
    $queryBuilder->select("$tableProduct.*");

    if($condition['sort'] == "recent") {
        $queryBuilder->orderBy("$tableProduct.created_at desc");
    } elseif($condition['sort'] == "hprice") {
        $queryBuilder->orderBy("$tableProduct.selling_price1 desc");
    } elseif($condition['sort'] == "lprice") {
        $queryBuilder->orderBy("$tableProduct.selling_price1 ASC");
    } elseif($condition['sort'] == "brand") {
        $queryBuilder->orderBy("$tableProduct.maker_seq ASC");
    } else {
        // $queryBuilder->orderBy("$tableProduct.created_at desc");
        // $queryBuilder->orderBy("rand()"); //랜덤 검색
        $queryBuilder->orderBy("$tableProduct.qty_flag ASC");
        $queryBuilder->orderBy("$tableProduct.part_number ASC");
    }


    if(!isset($limit)) $limit = 20;

    if($allData){

        $dataResult = $queryBuilder->findAll($limit);


        if(count($dataResult) > 0){
            //Get data manufacturer for product
            $manufacturerModel = new ManufacturerModel();
            $listManufacturer = $manufacturerModel->findAll();
            if(count($listManufacturer) > 0){
                $mapManufacturer = ArrayHelper::parseListObjectToArrayKey($listManufacturer,'maker_seq');
                foreach ($dataResult as $product){
                    if(isset($mapManufacturer[$product->maker_seq])){
                        $manufacturer = $mapManufacturer[$product->maker_seq];
                        $product->maker_code = $manufacturer->maker_code;
                        $product->name = $manufacturer->name;
                    }
                }
            }

            $deliverycodeModel = new DeliverycodeModel();
            $listdeliverycodes = $deliverycodeModel->findAll();
            if(count($listdeliverycodes) > 0){
                $mapDeliverycode = ArrayHelper::parseListObjectToArrayKey($listdeliverycodes,'id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapDeliverycode[$product->delivery_code])){
                        $deliverycode = $mapDeliverycode[$product->delivery_code];
                        $product->delivery_code = $deliverycode->id;
                        $product->delivery_info = $deliverycode->info;
                        $product->delivery_price = $deliverycode->price;
                        
                    }
                }
            }

            $stocklocationCategoryModel = new StocklocationCategoryModel();
            $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
            if(count($liststocklocationCategorys) > 0){
                $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapStocklocationCategory[$product->stock_location])){
                        $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                        $product->stock_location = $stocklocationCategory->location_id;
                        $product->location_info = $stocklocationCategory->location_info;
                        
                    }
                }
            }

            $stocklocationCategoryModel = new StocklocationCategoryModel();
            $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
            if(count($liststocklocationCategorys) > 0){
                $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapStocklocationCategory[$product->stock_location])){
                        $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                        $product->stock_location = $stocklocationCategory->location_id;
                        $product->location_info = $stocklocationCategory->location_info;
                        
                    }
                }
            }

            $leadtimeCategoryModel = new LeadtimeCategoryModel();
            $listleadtimeCategorys = $leadtimeCategoryModel->findAll();
            if(count($listleadtimeCategorys) > 0){
                $mapLeadtimeCategory = ArrayHelper::parseListObjectToArrayKey($listleadtimeCategorys,'leadtime_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapLeadtimeCategory[$product->leadtime])){
                        $leadtimeCategory = $mapLeadtimeCategory[$product->leadtime];
                        $product->leadtime = $leadtimeCategory->leadtime_id;
                        $product->leadtime_info = $leadtimeCategory->leadtime_info;
                        
                    }
                }
            }                

        }
        return $dataResult;
    }


    $dataResult = $this->executePaginate($queryBuilder, $limit);

// MDI2020 test
//var_dump($dataResult);

    if(count($dataResult['lists']) > 0){
        //Get data manufacturer for product
        $manufacturerModel = new ManufacturerModel();
        $listManufacturer = $manufacturerModel->findAll();
        //var_dump($listManufacturer);
        //exit;
        if(count($listManufacturer) > 0){
            $mapManufacturer = ArrayHelper::parseListObjectToArrayKey($listManufacturer,'maker_seq');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapManufacturer[$product->maker_seq])){
                    $manufacturer = $mapManufacturer[$product->maker_seq];
                    $product->maker_code = $manufacturer->maker_code;
                    $product->name = $manufacturer->name;

                }
            }
        }

        $deliverycodeModel = new DeliverycodeModel();
        $listdeliverycodes = $deliverycodeModel->findAll();
        if(count($listdeliverycodes) > 0){
            $mapDeliverycode = ArrayHelper::parseListObjectToArrayKey($listdeliverycodes,'id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapDeliverycode[$product->delivery_code])){
                    $deliverycode = $mapDeliverycode[$product->delivery_code];
                    $product->delivery_code = $deliverycode->id;
                    $product->delivery_info = $deliverycode->info;
                    $product->delivery_price = $deliverycode->price;
                    
                }
            }
        }

        $stocklocationCategoryModel = new StocklocationCategoryModel();
        $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
        if(count($liststocklocationCategorys) > 0){
            $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapStocklocationCategory[$product->stock_location])){
                    $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                    $product->stock_location = $stocklocationCategory->location_id;
                    $product->location_info = $stocklocationCategory->location_info;
                    
                }
            }
        }         
                    
        $leadtimeCategoryModel = new LeadtimeCategoryModel();
        $listleadtimeCategorys = $leadtimeCategoryModel->findAll();
        if(count($listleadtimeCategorys) > 0){
            $mapLeadtimeCategory = ArrayHelper::parseListObjectToArrayKey($listleadtimeCategorys,'leadtime_id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapLeadtimeCategory[$product->leadtime])){
                    $leadtimeCategory = $mapLeadtimeCategory[$product->leadtime];
                    $product->leadtime = $leadtimeCategory->leadtime_id;
                    $product->leadtime_info = $leadtimeCategory->leadtime_info;
                    
                }
            }
        }   

        //var_dump($product);
        //exit;
    }

  if(count($dataResult['lists']) > 0){

  }

    return $dataResult;
}


/******************************************************************************************/

public function getSupplierCode($condition = []){

    if(!isset($condition)) $condition = [];

    $tableProduct = ProductModel::getTableName();
    $queryBuilder = $this->where("$tableProduct.del_flg", DELETE_FLG_OFF);

    $navershop_chk = ['1', '2', '3'];
    $queryBuilder->whereIn("$tableProduct.navershop_chk", $navershop_chk);

    $queryBuilder->select("$tableProduct.product_code, $tableProduct.part_number, $tableProduct.product_api_id");
    $queryBuilder->orderBy("$tableProduct.created_at desc");
    $dataResult = $queryBuilder->findAll();

    return $dataResult;
}

/******************************************************************************************/
/******************************************************************************************/

/*
    public function getAdminTSV($condition = []){

        if(!isset($condition)) $condition = [];

        $tableProduct = ProductModel::getTableName();
        $tableManufacturer = ManufacturerModel::getTableName();
        $tableCategorylevel1 = Categorylevel1Model::getTableName();
        $tableCategorylevel2 = Categorylevel2Model::getTableName();
        $tableCategorylevel3 = Categorylevel3Model::getTableName();

        $queryBuilder = $this->where("$tableProduct.del_flg", DELETE_FLG_OFF);

        $navershop_chk = ['1', '2', '3'];
        $queryBuilder->whereIn("$tableProduct.navershop_chk", $navershop_chk);

        $queryBuilder->join($tableManufacturer,"$tableManufacturer.maker_seq = $tableProduct.maker_seq",'LEFT');
        $queryBuilder->join($tableCategorylevel1,"$tableCategorylevel1.categorylevel1_code = $tableProduct.part_category",'LEFT');
        $queryBuilder->join($tableCategorylevel2,"$tableCategorylevel2.categorylevel2_code = $tableProduct.part_category2",'LEFT');
        $queryBuilder->join($tableCategorylevel3,"$tableCategorylevel3.categorylevel3_code = $tableProduct.part_category3",'LEFT');
        $queryBuilder->select("$tableProduct.product_code as id, $tableProduct.part_number as title, $tableProduct.selling_price1 as price_pc, '' as price_mobile,'' as normal_price,$tableProduct.product_code as link, '' as mobile_link, $tableProduct.image_dir as image_link, '' as add_image_link, 
        '' as video_url, $tableCategorylevel1.categorylevel1_name as category_name1, $tableCategorylevel2.categorylevel2_name as category_name2, $tableCategorylevel3.categorylevel3_name as category_name3, '' as category_name4, '' as naver_category, '' as naver_product_id, '' as product_option_id, '' as conditions, '' as import_flag, 
        '' as parallel_import, '' as order_made, '' as product_flag, '' as adult, '' as goods_type, '' as barcode, '' as manufacture_define_number, $tableManufacturer.name as brand, '' as brand_certification, '' as maker, '' as origin, '' as card_event, '' as event_words, '' as coupon, '' as partner_coupon_download, 
        '' as interest_free_event, '' as point, '' as installation_costs, '' as rental_info, '' as search_tag, '' as group_id, $tableProduct.product_api_id as vendor_id, '' as coordi_id, $tableProduct.moq as minimum_purchase_quantity, '' as review_count, '4000' as shipping, '' as delivery_grade, '' as delivery_detail, '' as attribute, 
        '' as option_detail, '' as seller_id, '' as age_group, '' as gender, '' as shipping_settings, '' as fast_delivery, '' as regular_delivery, '' as dawn_delivery, '' as npay_unable, '' as npay_unable_acum, '' as isbn, $tableProduct.navershop_status as Class, DATE_FORMAT(NOW(),'%Y-%m-%d %H:%i:%s') as update_time");

        $queryBuilder->orderBy("$tableProduct.created_at desc");
        $dataResult = $queryBuilder->findAll();

        return $dataResult;
    }
    */

    public function getAdminTSV($condition = []){

        if(!isset($condition)) $condition = [];
        $tableProduct = ProductModel::getTableName();
        $tableManufacturer = ManufacturerModel::getTableName();
        $tableCategorylevel1 = Categorylevel1Model::getTableName();
        $tableCategorylevel2 = Categorylevel2Model::getTableName();
        $tableCategorylevel3 = Categorylevel3Model::getTableName();

        $queryBuilder = $this->where("$tableProduct.del_flg", DELETE_FLG_OFF);

        $navershop_chk = ['1', '2', '3'];
        $queryBuilder->whereIn("$tableProduct.navershop_chk", $navershop_chk);

        $queryBuilder->join($tableManufacturer,"$tableManufacturer.maker_seq = $tableProduct.maker_seq",'LEFT');
        $queryBuilder->join($tableCategorylevel1,"$tableCategorylevel1.categorylevel1_code = $tableProduct.part_category",'LEFT');
        $queryBuilder->join($tableCategorylevel2,"$tableCategorylevel2.categorylevel2_code = $tableProduct.part_category2",'LEFT');
        $queryBuilder->join($tableCategorylevel3,"$tableCategorylevel3.categorylevel3_code = $tableProduct.part_category3",'LEFT');
        $queryBuilder->select("$tableProduct.product_code as id, $tableProduct.part_number as title, $tableProduct.selling_price1 as price_pc, '' as price_mobile,'' as normal_price,$tableProduct.product_code as link, '' as mobile_link, $tableProduct.image_dir as image_link, '' as add_image_link, 
        '' as video_url, $tableCategorylevel1.categorylevel1_name as category_name1, $tableCategorylevel2.categorylevel2_name as category_name2, $tableCategorylevel3.categorylevel3_name as category_name3, '' as category_name4, '50003459' as naver_category, '' as naver_product_id, '' as product_option_id, '' as conditions, '' as import_flag, 
        '' as parallel_import, '' as order_made, '' as product_flag, '' as adult, '' as goods_type, '' as barcode, '' as manufacture_define_number, $tableManufacturer.name as brand, '' as brand_certification, '' as maker, '' as origin, '' as card_event, '' as event_words, '' as coupon, '' as partner_coupon_download, 
        '' as interest_free_event, '' as point, '' as installation_costs, '' as rental_info, '' as search_tag, '' as group_id, $tableProduct.product_api_id as vendor_id, '' as coordi_id, $tableProduct.moq as minimum_purchase_quantity, '' as review_count, '4000' as shipping, '' as delivery_grade, '' as delivery_detail, '' as attribute, 
        '' as option_detail, '' as seller_id, '' as age_group, '' as gender, '' as shipping_settings, '' as fast_delivery, '' as regular_delivery, '' as dawn_delivery, '' as npay_unable, '' as npay_unable_acum, '' as isbn, $tableProduct.navershop_status as Class, DATE_FORMAT(NOW(),'%Y-%m-%d %H:%i:%s') as update_time");

        $queryBuilder->orderBy("$tableProduct.created_at desc");
        $dataResult = $queryBuilder->findAll();

        return $dataResult;
    }

    public function getAdminTSVnotprice($condition = []){

        if(!isset($condition)) $condition = [];

        $tableProduct = ProductModel::getTableName();
        $tableManufacturer = ManufacturerModel::getTableName();
        $tableCategorylevel1 = Categorylevel1Model::getTableName();
        $tableCategorylevel2 = Categorylevel2Model::getTableName();
        $tableCategorylevel3 = Categorylevel3Model::getTableName();

        $queryBuilder = $this->where("$tableProduct.del_flg", DELETE_FLG_OFF);
        $queryBuilder->where("$tableProduct.selling_price1", 0);
        
        $navershop_chk = ['1', '2'];
        $queryBuilder->whereIn("$tableProduct.navershop_chk", $navershop_chk);

        $queryBuilder->orderBy("$tableProduct.created_at desc");
        $dataResult = $queryBuilder->findAll();

        return $dataResult;
    }

/******************************************************************************************/

public function getSearchTSV($limit){

    if(!isset($condition)) $condition = [];
    // var_dump($condition);

    $tableProduct = ProductModel::getTableName();
    $tableManufacturer = ManufacturerModel::getTableName();

    $queryBuilder = $this->where("$tableProduct.del_flg", DELETE_FLG_OFF);
    $queryBuilder = $this->like("$tableProduct.navershop_chk", trim('1'));

    $queryBuilder->select("$tableProduct.*");
    $queryBuilder->orderBy("$tableProduct.created_at desc");

    $dataResult = $this->executePaginate($queryBuilder, $limit);

    return $dataResult;
}


/******************************************************************************************/


public function getSearchExl($limit){

    if(!isset($condition)) $condition = [];
    // var_dump($condition);

    $tableProduct = ProductModel::getTableName();
    $tableManufacturer = ManufacturerModel::getTableName();

    $queryBuilder = $this->where("$tableProduct.del_flg", DELETE_FLG_OFF);
    //$queryBuilder = $this->where("$tableProduct.exposure", DELETE_FLG_OFF);

    $queryBuilder->select("$tableProduct.*");
    $queryBuilder->orderBy("$tableProduct.created_at desc");

    $dataResult = $this->executePaginate($queryBuilder, $limit);

    return $dataResult;
}

/******************************************************************************************/


public function getProduct($condition, $limit = 20 , $allData = false){

    if(!isset($condition)) $condition = [];

    $tableProduct = ProductModel::getTableName();
    $tableManufacturer = ManufacturerModel::getTableName();

    $queryBuilder = $this->where("$tableProduct.del_flg", DELETE_FLG_OFF);
    $queryBuilder = $this->where("$tableProduct.exposure", DELETE_FLG_OFF);

    if($condition['product_sctype'] == "newproduct") {
        $queryBuilder->like("$tableProduct.newproduct_chk", trim('1'));
    } elseif($condition['product_sctype'] == "bestproduct") {
        $queryBuilder->like("$tableProduct.bestproduct_chk", trim('1'));
    } elseif($condition['product_sctype'] == "brandproduct") {
        $id = $condition['id'];
        $queryBuilder->where("$tableProduct.maker_seq", trim($id));
    } elseif($condition['product_sctype'] == "eventproduct") {
        $id = $condition['id'];
        $queryBuilder->where("$tableProduct.event_set", trim($id));
    } else {

    }

    $queryBuilder->select("$tableProduct.*");

    // echo  $condition['product_sctype'];
    // echo  '<br>';
    // echo  $condition['sort'];

    if($condition['sort'] == "recent") {
        $queryBuilder->orderBy("$tableProduct.created_at desc");

    } elseif($condition['sort'] == "hprice") {
        $queryBuilder->orderBy("$tableProduct.selling_price1 desc");

    } elseif($condition['sort'] == "lprice") {
        $queryBuilder->orderBy("$tableProduct.selling_price1 ASC");

    } elseif($condition['sort'] == "brand") {
        $queryBuilder->orderBy("$tableProduct.maker_seq ASC");

    } else {
        // $queryBuilder->orderBy("$tableProduct.created_at desc");
        $queryBuilder->orderBy("$tableProduct.qty_flag ASC");
        $queryBuilder->orderBy("$tableProduct.part_number ASC");

    }

    if(!isset($limit)) $limit = 20;
    if($allData){

        $dataResult = $queryBuilder->findAll($limit);
        if(count($dataResult) > 0){
            //Get data manufacturer for product
            $manufacturerModel = new ManufacturerModel();
            $listManufacturer = $manufacturerModel->findAll();
            if(count($listManufacturer) > 0){
                $mapManufacturer = ArrayHelper::parseListObjectToArrayKey($listManufacturer,'maker_seq');
                foreach ($dataResult as $product){
                    if(isset($mapManufacturer[$product->maker_seq])){
                        $manufacturer = $mapManufacturer[$product->maker_seq];
                        $product->maker_code = $manufacturer->maker_code;
                        $product->name = $manufacturer->name;
                    }
                }
            }

            $deliverycodeModel = new DeliverycodeModel();
            $listdeliverycodes = $deliverycodeModel->findAll();
            if(count($listdeliverycodes) > 0){
                $mapDeliverycode = ArrayHelper::parseListObjectToArrayKey($listdeliverycodes,'id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapDeliverycode[$product->delivery_code])){
                        $deliverycode = $mapDeliverycode[$product->delivery_code];
                        $product->delivery_code = $deliverycode->id;
                        $product->delivery_info = $deliverycode->info;
                        $product->delivery_price = $deliverycode->price;
                        
                    }
                }
            }

            $stocklocationCategoryModel = new StocklocationCategoryModel();
            $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
            if(count($liststocklocationCategorys) > 0){
                $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapStocklocationCategory[$product->stock_location])){
                        $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                        $product->stock_location = $stocklocationCategory->location_id;
                        $product->location_info = $stocklocationCategory->location_info;
                        
                    }
                }
            }

            $stocklocationCategoryModel = new StocklocationCategoryModel();
            $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
            if(count($liststocklocationCategorys) > 0){
                $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapStocklocationCategory[$product->stock_location])){
                        $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                        $product->stock_location = $stocklocationCategory->location_id;
                        $product->location_info = $stocklocationCategory->location_info;
                        
                    }
                }
            }

            $leadtimeCategoryModel = new LeadtimeCategoryModel();
            $listleadtimeCategorys = $leadtimeCategoryModel->findAll();
            if(count($listleadtimeCategorys) > 0){
                $mapLeadtimeCategory = ArrayHelper::parseListObjectToArrayKey($listleadtimeCategorys,'leadtime_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapLeadtimeCategory[$product->leadtime])){
                        $leadtimeCategory = $mapLeadtimeCategory[$product->leadtime];
                        $product->leadtime = $leadtimeCategory->leadtime_id;
                        $product->leadtime_info = $leadtimeCategory->leadtime_info;
                        
                    }
                }
            }                

        }
        return $dataResult;
    }


    $dataResult = $this->executePaginate($queryBuilder, $limit);

// MDI2020 test
//var_dump($dataResult);

    if(count($dataResult['lists']) > 0){
        //Get data manufacturer for product
        $manufacturerModel = new ManufacturerModel();
        $listManufacturer = $manufacturerModel->findAll();
        //var_dump($listManufacturer);
        //exit;
        if(count($listManufacturer) > 0){
            $mapManufacturer = ArrayHelper::parseListObjectToArrayKey($listManufacturer,'maker_seq');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapManufacturer[$product->maker_seq])){
                    $manufacturer = $mapManufacturer[$product->maker_seq];
                    $product->maker_code = $manufacturer->maker_code;
                    $product->name = $manufacturer->name;

                }
            }
        }

        $deliverycodeModel = new DeliverycodeModel();
        $listdeliverycodes = $deliverycodeModel->findAll();
        if(count($listdeliverycodes) > 0){
            $mapDeliverycode = ArrayHelper::parseListObjectToArrayKey($listdeliverycodes,'id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapDeliverycode[$product->delivery_code])){
                    $deliverycode = $mapDeliverycode[$product->delivery_code];
                    $product->delivery_code = $deliverycode->id;
                    $product->delivery_info = $deliverycode->info;
                    $product->delivery_price = $deliverycode->price;
                    
                }
            }
        }

        $stocklocationCategoryModel = new StocklocationCategoryModel();
        $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
        if(count($liststocklocationCategorys) > 0){
            $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapStocklocationCategory[$product->stock_location])){
                    $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                    $product->stock_location = $stocklocationCategory->location_id;
                    $product->location_info = $stocklocationCategory->location_info;
                    
                }
            }
        }         
                    
        $leadtimeCategoryModel = new LeadtimeCategoryModel();
        $listleadtimeCategorys = $leadtimeCategoryModel->findAll();
        if(count($listleadtimeCategorys) > 0){
            $mapLeadtimeCategory = ArrayHelper::parseListObjectToArrayKey($listleadtimeCategorys,'leadtime_id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapLeadtimeCategory[$product->leadtime])){
                    $leadtimeCategory = $mapLeadtimeCategory[$product->leadtime];
                    $product->leadtime = $leadtimeCategory->leadtime_id;
                    $product->leadtime_info = $leadtimeCategory->leadtime_info;
                    
                }
            }
        }   

        //var_dump($product);
        //exit;
    }

  if(count($dataResult['lists']) > 0){

  }

    return $dataResult;
}


public function getNewproduct($condition, $limit = 20 , $allData = false){

    $day_7ago = date('Y-m-d H:i:s', strtotime('-7 Day'));
    //var_dump($day_7ago);
    //exit;

    if(!isset($condition)) $condition = [];

    $tableProduct = ProductModel::getTableName();
    $tableManufacturer = ManufacturerModel::getTableName();

    $queryBuilder = $this->where("$tableProduct.del_flg", DELETE_FLG_OFF);
    $queryBuilder = $this->where("$tableProduct.exposure", DELETE_FLG_OFF);
    $queryBuilder = $this->where("$tableProduct.created_at >=", $day_7ago);
    $queryBuilder = $this->orLike("$tableProduct.newproduct_chk", trim('1'));

    // select * from products where `created_at` > date_add(now(),interval -7 day)

    $queryBuilder->select("$tableProduct.*");

    if($condition['sort'] == "recent") {
        $queryBuilder->orderBy("$tableProduct.created_at desc");
    } elseif($condition['sort'] == "hprice") {
        $queryBuilder->orderBy("$tableProduct.selling_price1 desc");
    } elseif($condition['sort'] == "lprice") {
        $queryBuilder->orderBy("$tableProduct.selling_price1 ASC");
    } elseif($condition['sort'] == "brand") {
        $queryBuilder->orderBy("$tableProduct.maker_seq ASC");
    } else {
        $queryBuilder->orderBy("$tableProduct.newproduct_chk desc");
    }

    if(!isset($limit)) $limit = 20;
    if($allData){

        $dataResult = $queryBuilder->findAll($limit);
        if(count($dataResult) > 0){
            //Get data manufacturer for product
            $manufacturerModel = new ManufacturerModel();
            $listManufacturer = $manufacturerModel->findAll();
            if(count($listManufacturer) > 0){
                $mapManufacturer = ArrayHelper::parseListObjectToArrayKey($listManufacturer,'maker_seq');
                foreach ($dataResult as $product){
                    if(isset($mapManufacturer[$product->maker_seq])){
                        $manufacturer = $mapManufacturer[$product->maker_seq];
                        $product->maker_code = $manufacturer->maker_code;
                        $product->name = $manufacturer->name;
                    }
                }
            }

            $deliverycodeModel = new DeliverycodeModel();
            $listdeliverycodes = $deliverycodeModel->findAll();
            if(count($listdeliverycodes) > 0){
                $mapDeliverycode = ArrayHelper::parseListObjectToArrayKey($listdeliverycodes,'id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapDeliverycode[$product->delivery_code])){
                        $deliverycode = $mapDeliverycode[$product->delivery_code];
                        $product->delivery_code = $deliverycode->id;
                        $product->delivery_info = $deliverycode->info;
                        $product->delivery_price = $deliverycode->price;
                        
                    }
                }
            }

            $stocklocationCategoryModel = new StocklocationCategoryModel();
            $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
            if(count($liststocklocationCategorys) > 0){
                $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapStocklocationCategory[$product->stock_location])){
                        $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                        $product->stock_location = $stocklocationCategory->location_id;
                        $product->location_info = $stocklocationCategory->location_info;
                        
                    }
                }
            }

            $stocklocationCategoryModel = new StocklocationCategoryModel();
            $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
            if(count($liststocklocationCategorys) > 0){
                $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapStocklocationCategory[$product->stock_location])){
                        $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                        $product->stock_location = $stocklocationCategory->location_id;
                        $product->location_info = $stocklocationCategory->location_info;
                        
                    }
                }
            }

            $leadtimeCategoryModel = new LeadtimeCategoryModel();
            $listleadtimeCategorys = $leadtimeCategoryModel->findAll();
            if(count($listleadtimeCategorys) > 0){
                $mapLeadtimeCategory = ArrayHelper::parseListObjectToArrayKey($listleadtimeCategorys,'leadtime_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapLeadtimeCategory[$product->leadtime])){
                        $leadtimeCategory = $mapLeadtimeCategory[$product->leadtime];
                        $product->leadtime = $leadtimeCategory->leadtime_id;
                        $product->leadtime_info = $leadtimeCategory->leadtime_info;
                        
                    }
                }
            }                

        }
        return $dataResult;
    }


    $dataResult = $this->executePaginate($queryBuilder, $limit);

// MDI2020 test
//var_dump($dataResult);

    if(count($dataResult['lists']) > 0){
        //Get data manufacturer for product
        $manufacturerModel = new ManufacturerModel();
        $listManufacturer = $manufacturerModel->findAll();
        //var_dump($listManufacturer);
        //exit;
        if(count($listManufacturer) > 0){
            $mapManufacturer = ArrayHelper::parseListObjectToArrayKey($listManufacturer,'maker_seq');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapManufacturer[$product->maker_seq])){
                    $manufacturer = $mapManufacturer[$product->maker_seq];
                    $product->maker_code = $manufacturer->maker_code;
                    $product->name = $manufacturer->name;

                }
            }
        }

        $deliverycodeModel = new DeliverycodeModel();
        $listdeliverycodes = $deliverycodeModel->findAll();
        if(count($listdeliverycodes) > 0){
            $mapDeliverycode = ArrayHelper::parseListObjectToArrayKey($listdeliverycodes,'id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapDeliverycode[$product->delivery_code])){
                    $deliverycode = $mapDeliverycode[$product->delivery_code];
                    $product->delivery_code = $deliverycode->id;
                    $product->delivery_info = $deliverycode->info;
                    $product->delivery_price = $deliverycode->price;
                    
                }
            }
        }

        $stocklocationCategoryModel = new StocklocationCategoryModel();
        $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
        if(count($liststocklocationCategorys) > 0){
            $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapStocklocationCategory[$product->stock_location])){
                    $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                    $product->stock_location = $stocklocationCategory->location_id;
                    $product->location_info = $stocklocationCategory->location_info;
                    
                }
            }
        }         
                    
        $leadtimeCategoryModel = new LeadtimeCategoryModel();
        $listleadtimeCategorys = $leadtimeCategoryModel->findAll();
        if(count($listleadtimeCategorys) > 0){
            $mapLeadtimeCategory = ArrayHelper::parseListObjectToArrayKey($listleadtimeCategorys,'leadtime_id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapLeadtimeCategory[$product->leadtime])){
                    $leadtimeCategory = $mapLeadtimeCategory[$product->leadtime];
                    $product->leadtime = $leadtimeCategory->leadtime_id;
                    $product->leadtime_info = $leadtimeCategory->leadtime_info;
                    
                }
            }
        }   

        //var_dump($product);
        //exit;
    }

  if(count($dataResult['lists']) > 0){

  }

    return $dataResult;
}


/**** 2020-12-05 ***********/
public function getCategorySearch($condition = [], $condition2 = [], $limit = 20 , $allData = false){
    if(!isset($condition)) $condition = [];
    if(!isset($condition2)) $condition2 = [];

    $tableProduct = ProductModel::getTableName();
    $tableManufacturer = ManufacturerModel::getTableName();
    $queryBuilder = $this->where("$tableProduct.del_flg", DELETE_FLG_OFF);
    $queryBuilder = $this->where("$tableProduct.exposure", DELETE_FLG_OFF);

    if(isset($condition2['category']) && $this->checkSearchItem($condition2['category'])){
        $queryBuilder->where("$tableProduct.part_category", trim($condition2['category']));
    }

    if(isset($condition['part_number']) && $this->checkSearchItem($condition['part_number'])){
        $queryBuilder->like("$tableProduct.part_number", trim($condition['part_number'])); //검색어 포함 검색
        //$queryBuilder->where("$tableProduct.part_number", trim($condition['part_number'])); //검색어만 검색
    }

        
	// MDI2020 test
    // var_dump($condition2);
    // var_dump($condition);

    $queryBuilder->select("$tableProduct.*");

    if($condition['sort'] == "recent") {
        // var_dump($condition['sort']);
        $queryBuilder->orderBy("$tableProduct.created_at desc");
    } elseif($condition['sort'] == "hprice") {
        //var_dump($condition['sort']);
        $queryBuilder->orderBy("$tableProduct.selling_price1 desc");
    } elseif($condition['sort'] == "lprice") {
        //var_dump($condition['sort']);
        $queryBuilder->orderBy("$tableProduct.selling_price1 ASC");
    } elseif($condition['sort'] == "brand") {
        // var_dump($condition['sort']);
        $queryBuilder->orderBy("$tableProduct.maker_seq ASC");
    } else {
        $queryBuilder->orderBy("$tableProduct.created_at desc");
    }

    if(!isset($limit)) $limit = 20;

    $dataResult = $this->executePaginate($queryBuilder, $limit);

    if(count($dataResult['lists']) > 0){
        //Get data manufacturer for product
        $manufacturerModel = new ManufacturerModel();
        $listManufacturer = $manufacturerModel->findAll();
        if(count($listManufacturer) > 0){
            $mapManufacturer = ArrayHelper::parseListObjectToArrayKey($listManufacturer,'maker_seq');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapManufacturer[$product->maker_seq])){
                    $manufacturer = $mapManufacturer[$product->maker_seq];
                    $product->maker_code = $manufacturer->maker_code;
                    $product->name = $manufacturer->name;
                }
            }
        }
    }

    return $dataResult;
}

    public function findByProductId($productId){
        $tableProduct = ProductModel::getTableName();
        $tableManufacturer = ManufacturerModel::getTableName();
        $tableDeliverycode = DeliverycodeModel::getTableName();
        $tableStocklocationCategory = StocklocationCategoryModel::getTableName();
        $tableLeadtimeCategory = LeadtimeCategoryModel::getTableName();

        $this->join($tableManufacturer,"$tableManufacturer.maker_seq = $tableProduct.maker_seq");
        $this->join($tableDeliverycode,"$tableDeliverycode.id = $tableProduct.delivery_code");
        $this->join($tableStocklocationCategory,"$tableStocklocationCategory.location_id = $tableProduct.stock_location");
        $this->join($tableLeadtimeCategory,"$tableLeadtimeCategory.leadtime_id = $tableProduct.leadtime");
        $this->where('product_id', esc($productId));
        $this->select("$tableProduct.*, $tableManufacturer.maker_seq, $tableManufacturer.name, $tableDeliverycode.info as delivery_info, $tableDeliverycode.price as delivery_price, 
            $tableStocklocationCategory.location_id, $tableStocklocationCategory.location_info, $tableLeadtimeCategory.leadtime_id, $tableLeadtimeCategory.leadtime_info");
        return  $this->first();
    }


    public function findByProductCode($productCode){
        $tableProduct = ProductModel::getTableName();
        $tableManufacturer = ManufacturerModel::getTableName();
        $tableDeliverycode = DeliverycodeModel::getTableName();
        $tableStocklocationCategory = StocklocationCategoryModel::getTableName();
        $tableLeadtimeCategory = LeadtimeCategoryModel::getTableName();

        $this->join($tableManufacturer,"$tableManufacturer.maker_seq = $tableProduct.maker_seq");
        $this->join($tableDeliverycode,"$tableDeliverycode.id = $tableProduct.delivery_code");
        $this->join($tableStocklocationCategory,"$tableStocklocationCategory.location_id = $tableProduct.stock_location");
        $this->join($tableLeadtimeCategory,"$tableLeadtimeCategory.leadtime_id = $tableProduct.leadtime");
        $this->where('product_code', esc($productCode));
        $this->select("$tableProduct.*, $tableManufacturer.maker_seq, $tableManufacturer.name, $tableDeliverycode.info as delivery_info, $tableDeliverycode.price as delivery_price, 
            $tableStocklocationCategory.location_id, $tableStocklocationCategory.location_info, $tableLeadtimeCategory.leadtime_id, $tableLeadtimeCategory.leadtime_info");
        return  $this->first();
    }

    /**
     * @param string $partNumber
     * @return ProductModel|null
     */
    public function findByPartNumber($partNumber){
        $tableProduct = ProductModel::getTableName();
        $tableManufacturer = ManufacturerModel::getTableName();
        $tableDeliverycode = DeliverycodeModel::getTableName();
        $tableStocklocationCategory = StocklocationCategoryModel::getTableName();
        $tableLeadtimeCategory = LeadtimeCategoryModel::getTableName();

        $this->join($tableManufacturer,"$tableManufacturer.maker_seq = $tableProduct.maker_seq");
        $this->join($tableDeliverycode,"$tableDeliverycode.id = $tableProduct.delivery_code");
        $this->join($tableStocklocationCategory,"$tableStocklocationCategory.location_id = $tableProduct.stock_location");
        $this->join($tableLeadtimeCategory,"$tableLeadtimeCategory.leadtime_id = $tableProduct.leadtime");
        $this->where('part_number', esc($partNumber));
        $this->select("$tableProduct.*, $tableManufacturer.maker_seq, $tableManufacturer.name, $tableDeliverycode.info as delivery_info, $tableDeliverycode.price as delivery_price, 
            $tableStocklocationCategory.location_id, $tableStocklocationCategory.location_info, $tableLeadtimeCategory.leadtime_id, $tableLeadtimeCategory.leadtime_info");
        return  $this->first();
    }

    public function getByPartNumber($partNumber){
        if(!is_array($partNumber)) $partNumber = [$partNumber];
        $result = [];
        foreach (array_chunk($partNumber, 10000) as $partNumberIds){
            $resultProduct = $this->where('del_flg', DELETE_FLG_OFF)
                ->whereIn('part_number', $partNumberIds)->findAll();
            $result = array_merge($result, $resultProduct);
        }
        return $result;

    }

    public function getByProductNo($productIds){
        if(!is_array($productIds)) $productIds = [$productIds];
        $result = [];
        foreach (array_chunk($productIds, 10000) as $partProductIds){
            $resultProduct = $this->where('del_flg', DELETE_FLG_OFF)
                ->whereIn('product_id', $partProductIds)->findAll();
            $result = array_merge($result, $resultProduct);
        }
        return $result;

    }

    public function findInfo($productId){
        $tableProduct = ProductModel::getTableName();
        $tableManufacturer = ManufacturerModel::getTableName();
        $tableDeliverycode = DeliverycodeModel::getTableName();
        $tableStocklocationCategory = StocklocationCategoryModel::getTableName();
        $tableLeadtimeCategory = LeadtimeCategoryModel::getTableName();

        $this->join($tableManufacturer,"$tableManufacturer.maker_seq = $tableProduct.maker_seq");
        $this->join($tableDeliverycode,"$tableDeliverycode.id = $tableProduct.delivery_code");
        $this->join($tableStocklocationCategory,"$tableStocklocationCategory.location_id = $tableProduct.stock_location");
        $this->join($tableLeadtimeCategory,"$tableLeadtimeCategory.leadtime_id = $tableProduct.leadtime");
        $this->where("$tableProduct.del_flg", DELETE_FLG_OFF)->where("$tableProduct.product_id", $productId);
        $this->select("$tableProduct.*, $tableManufacturer.maker_seq, $tableManufacturer.name, $tableDeliverycode.info as delivery_info, $tableDeliverycode.price as delivery_price, 
            $tableStocklocationCategory.location_id, $tableStocklocationCategory.location_info, $tableLeadtimeCategory.leadtime_id, $tableLeadtimeCategory.leadtime_info");
        return  $this->first();
    }

    public function findByProductInfo($part_sequence){
        return $this->where('product_code', $part_sequence)->first();
    }


/******* Main Info Start *******************************************************************/

public function getRecommended($condition, $limit = 10 , $allData = false){

    $tableProduct = ProductModel::getTableName();
    $tableManufacturer = ManufacturerModel::getTableName();

    $queryBuilder = $this->where("$tableProduct.del_flg", DELETE_FLG_OFF);
    $queryBuilder = $this->where("$tableProduct.exposure", DELETE_FLG_OFF);

    $queryBuilder->like("$tableProduct.part_category2", trim($condition));

    $queryBuilder->select("$tableProduct.*");

    // $queryBuilder->orderBy("$tableProduct.created_at desc");
    $queryBuilder->orderBy("$tableProduct.qty_flag ASC");
    $queryBuilder->orderBy("$tableProduct.part_number ASC");

    if(!isset($limit)) $limit = 10;

    if($allData){
        $dataResult = $queryBuilder->findAll($limit);
        if(count($dataResult) > 0){
            $manufacturerModel = new ManufacturerModel();
            $listManufacturer = $manufacturerModel->findAll();
            if(count($listManufacturer) > 0){
                $mapManufacturer = ArrayHelper::parseListObjectToArrayKey($listManufacturer,'maker_seq');
                foreach ($dataResult as $product){
                    if(isset($mapManufacturer[$product->maker_seq])){
                        $manufacturer = $mapManufacturer[$product->maker_seq];
                        $product->maker_code = $manufacturer->maker_code;
                        $product->name = $manufacturer->name;
                    }
                }
            }

            $deliverycodeModel = new DeliverycodeModel();
            $listdeliverycodes = $deliverycodeModel->findAll();
            if(count($listdeliverycodes) > 0){
                $mapDeliverycode = ArrayHelper::parseListObjectToArrayKey($listdeliverycodes,'id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapDeliverycode[$product->delivery_code])){
                        $deliverycode = $mapDeliverycode[$product->delivery_code];
                        $product->delivery_code = $deliverycode->id;
                        $product->delivery_info = $deliverycode->info;
                        $product->delivery_price = $deliverycode->price;
                        
                    }
                }
            }

            $stocklocationCategoryModel = new StocklocationCategoryModel();
            $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
            if(count($liststocklocationCategorys) > 0){
                $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapStocklocationCategory[$product->stock_location])){
                        $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                        $product->stock_location = $stocklocationCategory->location_id;
                        $product->location_info = $stocklocationCategory->location_info;
                        
                    }
                }
            }

            $stocklocationCategoryModel = new StocklocationCategoryModel();
            $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
            if(count($liststocklocationCategorys) > 0){
                $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapStocklocationCategory[$product->stock_location])){
                        $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                        $product->stock_location = $stocklocationCategory->location_id;
                        $product->location_info = $stocklocationCategory->location_info;
                        
                    }
                }
            }

            $leadtimeCategoryModel = new LeadtimeCategoryModel();
            $listleadtimeCategorys = $leadtimeCategoryModel->findAll();
            if(count($listleadtimeCategorys) > 0){
                $mapLeadtimeCategory = ArrayHelper::parseListObjectToArrayKey($listleadtimeCategorys,'leadtime_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapLeadtimeCategory[$product->leadtime])){
                        $leadtimeCategory = $mapLeadtimeCategory[$product->leadtime];
                        $product->leadtime = $leadtimeCategory->leadtime_id;
                        $product->leadtime_info = $leadtimeCategory->leadtime_info;
                        
                    }
                }
            }                

        }
        return $dataResult;
    }

    $dataResult = $this->executePaginate($queryBuilder, $limit);

    if(count($dataResult['lists']) > 0){
        $manufacturerModel = new ManufacturerModel();
        $listManufacturer = $manufacturerModel->findAll();
        if(count($listManufacturer) > 0){
            $mapManufacturer = ArrayHelper::parseListObjectToArrayKey($listManufacturer,'maker_seq');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapManufacturer[$product->maker_seq])){
                    $manufacturer = $mapManufacturer[$product->maker_seq];
                    $product->maker_code = $manufacturer->maker_code;
                    $product->name = $manufacturer->name;

                }
            }
        }

        $deliverycodeModel = new DeliverycodeModel();
        $listdeliverycodes = $deliverycodeModel->findAll();
        if(count($listdeliverycodes) > 0){
            $mapDeliverycode = ArrayHelper::parseListObjectToArrayKey($listdeliverycodes,'id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapDeliverycode[$product->delivery_code])){
                    $deliverycode = $mapDeliverycode[$product->delivery_code];
                    $product->delivery_code = $deliverycode->id;
                    $product->delivery_info = $deliverycode->info;
                    $product->delivery_price = $deliverycode->price;
                    
                }
            }
        }

        $stocklocationCategoryModel = new StocklocationCategoryModel();
        $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
        if(count($liststocklocationCategorys) > 0){
            $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapStocklocationCategory[$product->stock_location])){
                    $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                    $product->stock_location = $stocklocationCategory->location_id;
                    $product->location_info = $stocklocationCategory->location_info;
                    
                }
            }
        }         
                    
        $leadtimeCategoryModel = new LeadtimeCategoryModel();
        $listleadtimeCategorys = $leadtimeCategoryModel->findAll();
        if(count($listleadtimeCategorys) > 0){
            $mapLeadtimeCategory = ArrayHelper::parseListObjectToArrayKey($listleadtimeCategorys,'leadtime_id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapLeadtimeCategory[$product->leadtime])){
                    $leadtimeCategory = $mapLeadtimeCategory[$product->leadtime];
                    $product->leadtime = $leadtimeCategory->leadtime_id;
                    $product->leadtime_info = $leadtimeCategory->leadtime_info;
                    
                }
            }
        }   

    }

    return $dataResult;
}

/******* Main Info Stop ********************************************************************/


/******* Main Info Start *******************************************************************/

public function getBestproduct($condition, $limit = 10 , $allData = false){

    $tableProduct = ProductModel::getTableName();
    $tableManufacturer = ManufacturerModel::getTableName();

    $queryBuilder = $this->where("$tableProduct.del_flg", DELETE_FLG_OFF);
    $queryBuilder = $this->where("$tableProduct.exposure", DELETE_FLG_OFF);

    $queryBuilder->like("$tableProduct.part_category2", trim($condition));

    $queryBuilder->select("$tableProduct.*");

    // $queryBuilder->orderBy("$tableProduct.created_at desc");
    $queryBuilder->orderBy("$tableProduct.qty_flag ASC");
    $queryBuilder->orderBy("$tableProduct.part_number ASC");

    if(!isset($limit)) $limit = 10;

    if($allData){
        $dataResult = $queryBuilder->findAll($limit);
        if(count($dataResult) > 0){
            $manufacturerModel = new ManufacturerModel();
            $listManufacturer = $manufacturerModel->findAll();
            if(count($listManufacturer) > 0){
                $mapManufacturer = ArrayHelper::parseListObjectToArrayKey($listManufacturer,'maker_seq');
                foreach ($dataResult as $product){
                    if(isset($mapManufacturer[$product->maker_seq])){
                        $manufacturer = $mapManufacturer[$product->maker_seq];
                        $product->maker_code = $manufacturer->maker_code;
                        $product->name = $manufacturer->name;
                    }
                }
            }

            $deliverycodeModel = new DeliverycodeModel();
            $listdeliverycodes = $deliverycodeModel->findAll();
            if(count($listdeliverycodes) > 0){
                $mapDeliverycode = ArrayHelper::parseListObjectToArrayKey($listdeliverycodes,'id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapDeliverycode[$product->delivery_code])){
                        $deliverycode = $mapDeliverycode[$product->delivery_code];
                        $product->delivery_code = $deliverycode->id;
                        $product->delivery_info = $deliverycode->info;
                        $product->delivery_price = $deliverycode->price;
                        
                    }
                }
            }

            $stocklocationCategoryModel = new StocklocationCategoryModel();
            $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
            if(count($liststocklocationCategorys) > 0){
                $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapStocklocationCategory[$product->stock_location])){
                        $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                        $product->stock_location = $stocklocationCategory->location_id;
                        $product->location_info = $stocklocationCategory->location_info;
                        
                    }
                }
            }

            $stocklocationCategoryModel = new StocklocationCategoryModel();
            $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
            if(count($liststocklocationCategorys) > 0){
                $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapStocklocationCategory[$product->stock_location])){
                        $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                        $product->stock_location = $stocklocationCategory->location_id;
                        $product->location_info = $stocklocationCategory->location_info;
                        
                    }
                }
            }

            $leadtimeCategoryModel = new LeadtimeCategoryModel();
            $listleadtimeCategorys = $leadtimeCategoryModel->findAll();
            if(count($listleadtimeCategorys) > 0){
                $mapLeadtimeCategory = ArrayHelper::parseListObjectToArrayKey($listleadtimeCategorys,'leadtime_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapLeadtimeCategory[$product->leadtime])){
                        $leadtimeCategory = $mapLeadtimeCategory[$product->leadtime];
                        $product->leadtime = $leadtimeCategory->leadtime_id;
                        $product->leadtime_info = $leadtimeCategory->leadtime_info;
                        
                    }
                }
            }                

        }
        return $dataResult;
    }

    $dataResult = $this->executePaginate($queryBuilder, $limit);

    if(count($dataResult['lists']) > 0){
        $manufacturerModel = new ManufacturerModel();
        $listManufacturer = $manufacturerModel->findAll();
        if(count($listManufacturer) > 0){
            $mapManufacturer = ArrayHelper::parseListObjectToArrayKey($listManufacturer,'maker_seq');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapManufacturer[$product->maker_seq])){
                    $manufacturer = $mapManufacturer[$product->maker_seq];
                    $product->maker_code = $manufacturer->maker_code;
                    $product->name = $manufacturer->name;

                }
            }
        }

        $deliverycodeModel = new DeliverycodeModel();
        $listdeliverycodes = $deliverycodeModel->findAll();
        if(count($listdeliverycodes) > 0){
            $mapDeliverycode = ArrayHelper::parseListObjectToArrayKey($listdeliverycodes,'id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapDeliverycode[$product->delivery_code])){
                    $deliverycode = $mapDeliverycode[$product->delivery_code];
                    $product->delivery_code = $deliverycode->id;
                    $product->delivery_info = $deliverycode->info;
                    $product->delivery_price = $deliverycode->price;
                    
                }
            }
        }

        $stocklocationCategoryModel = new StocklocationCategoryModel();
        $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
        if(count($liststocklocationCategorys) > 0){
            $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapStocklocationCategory[$product->stock_location])){
                    $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                    $product->stock_location = $stocklocationCategory->location_id;
                    $product->location_info = $stocklocationCategory->location_info;
                    
                }
            }
        }         
                    
        $leadtimeCategoryModel = new LeadtimeCategoryModel();
        $listleadtimeCategorys = $leadtimeCategoryModel->findAll();
        if(count($listleadtimeCategorys) > 0){
            $mapLeadtimeCategory = ArrayHelper::parseListObjectToArrayKey($listleadtimeCategorys,'leadtime_id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapLeadtimeCategory[$product->leadtime])){
                    $leadtimeCategory = $mapLeadtimeCategory[$product->leadtime];
                    $product->leadtime = $leadtimeCategory->leadtime_id;
                    $product->leadtime_info = $leadtimeCategory->leadtime_info;
                    
                }
            }
        }   

    }

    return $dataResult;
}

/******* Main Info Stop ********************************************************************/


/******* Main Info Start *******************************************************************/

public function getSelectproduct($condition, $limit, $allData = false){

    $tableProduct = ProductModel::getTableName();
    $tableManufacturer = ManufacturerModel::getTableName();

    $queryBuilder = $this->where("$tableProduct.del_flg", DELETE_FLG_OFF);
    $queryBuilder = $this->where("$tableProduct.exposure", DELETE_FLG_OFF);
    // $queryBuilder->like("$tableProduct.part_category2", trim($condition));

    if ($condition == "new") {
    $queryBuilder->like("$tableProduct.newproduct_chk", trim('1'));
    }

    $queryBuilder->select("$tableProduct.*");

    // $queryBuilder->orderBy("$tableProduct.created_at desc");
    $queryBuilder->orderBy("$tableProduct.qty_flag ASC");
    $queryBuilder->orderBy("$tableProduct.part_number ASC");

    if(!isset($limit)) $limit = 5;

    if($allData){
        $dataResult = $queryBuilder->findAll($limit);
        if(count($dataResult) > 0){
            $manufacturerModel = new ManufacturerModel();
            $listManufacturer = $manufacturerModel->findAll();
            if(count($listManufacturer) > 0){
                $mapManufacturer = ArrayHelper::parseListObjectToArrayKey($listManufacturer,'maker_seq');
                foreach ($dataResult as $product){
                    if(isset($mapManufacturer[$product->maker_seq])){
                        $manufacturer = $mapManufacturer[$product->maker_seq];
                        $product->maker_code = $manufacturer->maker_code;
                        $product->name = $manufacturer->name;
                    }
                }
            }

            $deliverycodeModel = new DeliverycodeModel();
            $listdeliverycodes = $deliverycodeModel->findAll();
            if(count($listdeliverycodes) > 0){
                $mapDeliverycode = ArrayHelper::parseListObjectToArrayKey($listdeliverycodes,'id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapDeliverycode[$product->delivery_code])){
                        $deliverycode = $mapDeliverycode[$product->delivery_code];
                        $product->delivery_code = $deliverycode->id;
                        $product->delivery_info = $deliverycode->info;
                        $product->delivery_price = $deliverycode->price;
                        
                    }
                }
            }

            $stocklocationCategoryModel = new StocklocationCategoryModel();
            $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
            if(count($liststocklocationCategorys) > 0){
                $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapStocklocationCategory[$product->stock_location])){
                        $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                        $product->stock_location = $stocklocationCategory->location_id;
                        $product->location_info = $stocklocationCategory->location_info;
                        
                    }
                }
            }

            $stocklocationCategoryModel = new StocklocationCategoryModel();
            $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
            if(count($liststocklocationCategorys) > 0){
                $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapStocklocationCategory[$product->stock_location])){
                        $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                        $product->stock_location = $stocklocationCategory->location_id;
                        $product->location_info = $stocklocationCategory->location_info;
                        
                    }
                }
            }

            $leadtimeCategoryModel = new LeadtimeCategoryModel();
            $listleadtimeCategorys = $leadtimeCategoryModel->findAll();
            if(count($listleadtimeCategorys) > 0){
                $mapLeadtimeCategory = ArrayHelper::parseListObjectToArrayKey($listleadtimeCategorys,'leadtime_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapLeadtimeCategory[$product->leadtime])){
                        $leadtimeCategory = $mapLeadtimeCategory[$product->leadtime];
                        $product->leadtime = $leadtimeCategory->leadtime_id;
                        $product->leadtime_info = $leadtimeCategory->leadtime_info;
                        
                    }
                }
            }                

        }
        return $dataResult;
    }

    $dataResult = $this->executePaginate($queryBuilder, $limit);

    if(count($dataResult['lists']) > 0){
        $manufacturerModel = new ManufacturerModel();
        $listManufacturer = $manufacturerModel->findAll();
        if(count($listManufacturer) > 0){
            $mapManufacturer = ArrayHelper::parseListObjectToArrayKey($listManufacturer,'maker_seq');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapManufacturer[$product->maker_seq])){
                    $manufacturer = $mapManufacturer[$product->maker_seq];
                    $product->maker_code = $manufacturer->maker_code;
                    $product->name = $manufacturer->name;

                }
            }
        }

        $deliverycodeModel = new DeliverycodeModel();
        $listdeliverycodes = $deliverycodeModel->findAll();
        if(count($listdeliverycodes) > 0){
            $mapDeliverycode = ArrayHelper::parseListObjectToArrayKey($listdeliverycodes,'id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapDeliverycode[$product->delivery_code])){
                    $deliverycode = $mapDeliverycode[$product->delivery_code];
                    $product->delivery_code = $deliverycode->id;
                    $product->delivery_info = $deliverycode->info;
                    $product->delivery_price = $deliverycode->price;
                    
                }
            }
        }

        $stocklocationCategoryModel = new StocklocationCategoryModel();
        $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
        if(count($liststocklocationCategorys) > 0){
            $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapStocklocationCategory[$product->stock_location])){
                    $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                    $product->stock_location = $stocklocationCategory->location_id;
                    $product->location_info = $stocklocationCategory->location_info;
                    
                }
            }
        }         
                    
        $leadtimeCategoryModel = new LeadtimeCategoryModel();
        $listleadtimeCategorys = $leadtimeCategoryModel->findAll();
        if(count($listleadtimeCategorys) > 0){
            $mapLeadtimeCategory = ArrayHelper::parseListObjectToArrayKey($listleadtimeCategorys,'leadtime_id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapLeadtimeCategory[$product->leadtime])){
                    $leadtimeCategory = $mapLeadtimeCategory[$product->leadtime];
                    $product->leadtime = $leadtimeCategory->leadtime_id;
                    $product->leadtime_info = $leadtimeCategory->leadtime_info;
                    
                }
            }
        }   

    }

    return $dataResult;
}

/******* Main Info Stop ********************************************************************/


/******* Main Info Start *******************************************************************/

public function getBrandproduct($condition, $limit, $allData = false){

    $tableProduct = ProductModel::getTableName();
    $tableManufacturer = ManufacturerModel::getTableName();

    $queryBuilder = $this->where("$tableProduct.del_flg", DELETE_FLG_OFF);
    $queryBuilder = $this->where("$tableProduct.exposure", DELETE_FLG_OFF);

    $queryBuilder->where("$tableProduct.maker_seq", trim($condition));

    $queryBuilder->select("$tableProduct.*");

    //$queryBuilder->orderBy("$tableProduct.created_at desc");
    $queryBuilder->orderBy("$tableProduct.qty_flag ASC");
    $queryBuilder->orderBy("$tableProduct.part_number ASC");

    if(!isset($limit)) $limit = 3;

    if($allData){
        $dataResult = $queryBuilder->findAll($limit);
        if(count($dataResult) > 0){
            $manufacturerModel = new ManufacturerModel();
            $listManufacturer = $manufacturerModel->findAll();
            if(count($listManufacturer) > 0){
                $mapManufacturer = ArrayHelper::parseListObjectToArrayKey($listManufacturer,'maker_seq');
                foreach ($dataResult as $product){
                    if(isset($mapManufacturer[$product->maker_seq])){
                        $manufacturer = $mapManufacturer[$product->maker_seq];
                        $product->maker_code = $manufacturer->maker_code;
                        $product->name = $manufacturer->name;
                    }
                }
            }

            $deliverycodeModel = new DeliverycodeModel();
            $listdeliverycodes = $deliverycodeModel->findAll();
            if(count($listdeliverycodes) > 0){
                $mapDeliverycode = ArrayHelper::parseListObjectToArrayKey($listdeliverycodes,'id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapDeliverycode[$product->delivery_code])){
                        $deliverycode = $mapDeliverycode[$product->delivery_code];
                        $product->delivery_code = $deliverycode->id;
                        $product->delivery_info = $deliverycode->info;
                        $product->delivery_price = $deliverycode->price;
                        
                    }
                }
            }

            $stocklocationCategoryModel = new StocklocationCategoryModel();
            $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
            if(count($liststocklocationCategorys) > 0){
                $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapStocklocationCategory[$product->stock_location])){
                        $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                        $product->stock_location = $stocklocationCategory->location_id;
                        $product->location_info = $stocklocationCategory->location_info;
                        
                    }
                }
            }

            $stocklocationCategoryModel = new StocklocationCategoryModel();
            $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
            if(count($liststocklocationCategorys) > 0){
                $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapStocklocationCategory[$product->stock_location])){
                        $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                        $product->stock_location = $stocklocationCategory->location_id;
                        $product->location_info = $stocklocationCategory->location_info;
                        
                    }
                }
            }

            $leadtimeCategoryModel = new LeadtimeCategoryModel();
            $listleadtimeCategorys = $leadtimeCategoryModel->findAll();
            if(count($listleadtimeCategorys) > 0){
                $mapLeadtimeCategory = ArrayHelper::parseListObjectToArrayKey($listleadtimeCategorys,'leadtime_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapLeadtimeCategory[$product->leadtime])){
                        $leadtimeCategory = $mapLeadtimeCategory[$product->leadtime];
                        $product->leadtime = $leadtimeCategory->leadtime_id;
                        $product->leadtime_info = $leadtimeCategory->leadtime_info;
                        
                    }
                }
            }                

        }
        return $dataResult;
    }

    $dataResult = $this->executePaginate($queryBuilder, $limit);

    if(count($dataResult['lists']) > 0){
        $manufacturerModel = new ManufacturerModel();
        $listManufacturer = $manufacturerModel->findAll();
        if(count($listManufacturer) > 0){
            $mapManufacturer = ArrayHelper::parseListObjectToArrayKey($listManufacturer,'maker_seq');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapManufacturer[$product->maker_seq])){
                    $manufacturer = $mapManufacturer[$product->maker_seq];
                    $product->maker_code = $manufacturer->maker_code;
                    $product->name = $manufacturer->name;

                }
            }
        }

        $deliverycodeModel = new DeliverycodeModel();
        $listdeliverycodes = $deliverycodeModel->findAll();
        if(count($listdeliverycodes) > 0){
            $mapDeliverycode = ArrayHelper::parseListObjectToArrayKey($listdeliverycodes,'id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapDeliverycode[$product->delivery_code])){
                    $deliverycode = $mapDeliverycode[$product->delivery_code];
                    $product->delivery_code = $deliverycode->id;
                    $product->delivery_info = $deliverycode->info;
                    $product->delivery_price = $deliverycode->price;
                    
                }
            }
        }

        $stocklocationCategoryModel = new StocklocationCategoryModel();
        $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
        if(count($liststocklocationCategorys) > 0){
            $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapStocklocationCategory[$product->stock_location])){
                    $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                    $product->stock_location = $stocklocationCategory->location_id;
                    $product->location_info = $stocklocationCategory->location_info;
                    
                }
            }
        }         
                    
        $leadtimeCategoryModel = new LeadtimeCategoryModel();
        $listleadtimeCategorys = $leadtimeCategoryModel->findAll();
        if(count($listleadtimeCategorys) > 0){
            $mapLeadtimeCategory = ArrayHelper::parseListObjectToArrayKey($listleadtimeCategorys,'leadtime_id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapLeadtimeCategory[$product->leadtime])){
                    $leadtimeCategory = $mapLeadtimeCategory[$product->leadtime];
                    $product->leadtime = $leadtimeCategory->leadtime_id;
                    $product->leadtime_info = $leadtimeCategory->leadtime_info;
                    
                }
            }
        }   

    }

    return $dataResult;
}

public function updateProductQty($product_code, $adjusted_qty){
    $queryBuilder = $this->set('qty', $adjusted_qty);
    $queryBuilder = $this->where('product_code', $product_code);
    $queryBuilder = $this->update();
 }

/******* Main Info Stop ********************************************************************/

/******************************************************************************************/


public function getApiId($api_code){
    $queryBuilder = $this->where("del_flg", DELETE_FLG_OFF);
    $queryBuilder = $this->like('api_code', $api_code);
    $queryBuilder = $this->select("product_api_id");
    $queryBuilder = $this->findAll();
    
    return $queryBuilder;
}

public function findByProductSeq($product_api_id){
    $tableProduct = ProductModel::getTableName();
    return $this->where('product_api_id', esc($product_api_id))->select("$tableProduct.product_id")->first();
}

/*
public function updateStock($product_id, $apistock){
    $queryBuilder = $this->set('qty', $apistock);
    $queryBuilder = $this->where('product_id', $product_id);
    $queryBuilder = $this->update();
 }
 */

 public function updateRsStock($product_api_id, $apistock){
    $queryBuilder = $this->set('qty', $apistock);
    $queryBuilder = $this->where('api_code', "RS");
    $queryBuilder = $this->where('product_api_id', $product_api_id);
    $queryBuilder = $this->update();
 }

 public function updateRsPrice($product_api_id, $apiprice){
    $queryBuilder = $this->set('unit_mini_quantity1', $apiprice['unit_mini_quantity1']);
    $queryBuilder = $this->set('unit_max_quantity1', $apiprice['unit_max_quantity1']);
    $queryBuilder = $this->set('selling_price1', $apiprice['selling_price1']);
    $queryBuilder = $this->set('unit_mini_quantity2', $apiprice['unit_mini_quantity2']);
    $queryBuilder = $this->set('unit_max_quantity2', $apiprice['unit_max_quantity2']);
    $queryBuilder = $this->set('selling_price2', $apiprice['selling_price2']);
    $queryBuilder = $this->set('unit_mini_quantity3', $apiprice['unit_mini_quantity3']);
    $queryBuilder = $this->set('qtyunit_max_quantity3', $apiprice['unit_max_quantity3']);
    $queryBuilder = $this->set('selling_price3', $apiprice['selling_price3']);
    $queryBuilder = $this->set('unit_mini_quantity4', $apiprice['unit_mini_quantity4']);
    $queryBuilder = $this->set('unit_max_quantity4', $apiprice['unit_max_quantity4']);
    $queryBuilder = $this->set('selling_price4', $apiprice['selling_price4']);
    $queryBuilder = $this->set('unit_mini_quantity5', $apiprice['unit_mini_quantity5']);
    $queryBuilder = $this->set('unit_max_quantity5', $apiprice['unit_max_quantity5']);
    $queryBuilder = $this->set('selling_price5', $apiprice['selling_price5']);
    $queryBuilder = $this->set('unit_mini_quantity6', $apiprice['unit_mini_quantity6']);
    $queryBuilder = $this->set('unit_max_quantity6', $apiprice['unit_max_quantity6']);
    $queryBuilder = $this->set('selling_price6', $apiprice['selling_price6']);
    $queryBuilder = $this->where('api_code', "RS");
    $queryBuilder = $this->where('product_api_id', $product_api_id);
    $queryBuilder = $this->update();
 }

/******************************************************************************************/


}