<?php
namespace App\Models;

use App\Helpers\ArrayHelper;
use http\QueryString;

class ProductModel extends BaseModel {
    protected $table      = 'products';
    protected $primaryKey = 'product_id';
    
    protected $allowedFields = ['product_code','part_category','part_category2','part_category3','maker_seq','maker_name','location_code','display_set','newproduct_chk','bestproduct_chk',
        'recomproduct_chk','brandproduct_chk','event_set','part_number','part_number_sequence','search_word','brief_description','situation','exposure','product_related','replacement_items',
        'date_code','image_dir','delivery_code','api_flg','api_code','tariff_rate','product_api_id','qty','packing_code','packing_name','packsize','wearing_price','price','margin_rate',
        'discount_rate','leadtime','moq','in_moq','mpq','stock_location','taxable','selling_price1','prices_price1','prices_currency1','margin_rate1','unit_mini_quantity1','unit_max_quantity1',
        'selling_price2','prices_price2','prices_currency2','margin_rate2','unit_mini_quantity2','unit_max_quantity2','selling_price3','prices_price3','prices_currency3','margin_rate3','unit_mini_quantity3','unit_max_quantity3',
        'selling_price4','prices_price4','prices_currency4','margin_rate4','unit_mini_quantity4','unit_max_quantity4','selling_price5','prices_price5','prices_currency5','margin_rate5','unit_mini_quantity5','unit_max_quantity5',
        'selling_price6','prices_price6','prices_currency6','margin_rate6','unit_mini_quantity6','unit_max_quantity6','navershop_chk','navershop_status','qty_flag','virtualpn','active_flg','del_flg','api_updated_at'];

    protected $returnType = 'App\Entities\Product';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    /*
    protected $validationRules    = [
        'part_number' => 'required|min_length[3]',
        'qty' => 'required|alpha_numeric',
        'id' => 'required',
    ];
    */

    protected $validationMessages = [];
    protected $skipValidation     = true;

    /*
    public function save($data): bool{
        $data->part_number_sequence = strrev($data->part_number);
        return parent::save($data);
    }
    */

    public function getAdmin($condition = [], $limit = 20 , $allData = false){

        if(!isset($condition)) $condition = [];
        // var_dump($condition);

        $tableProduct = ProductModel::getTableName();
        $tableManufacturer = ManufacturerModel::getTableName();

        $queryBuilder = $this->where("$tableProduct.del_flg", DELETE_FLG_OFF);
        //$queryBuilder = $this->where("$tableProduct.exposure", DELETE_FLG_OFF);

        if(isset($condition['from_date']) && $this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where("$tableProduct.created_at >=", esc($condition['from_date']));
        }
        if(isset($condition['to_date']) && $this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where("$tableProduct.created_at <=", esc($condition['to_date']));
        }

        if(isset($condition['part_number']) && $this->checkSearchItem($condition['part_number'])){
            $queryBuilder->like("$tableProduct.part_number", trim($condition['part_number']));
        }

        if(isset($condition['search_code']) && $this->checkSearchItem($condition['search_code'])){
            $queryBuilder->like("$tableProduct.part_category", trim($condition['search_code']));
        }

        if(isset($condition['part_category']) && $this->checkSearchItem($condition['part_category'])){
            $queryBuilder->like("$tableProduct.part_category", trim($condition['part_category']));
        }
        
        if(isset($condition['part_category2']) && $this->checkSearchItem($condition['part_category2'])){
            $queryBuilder->like("$tableProduct.part_category2", trim($condition['part_category2']));
        }

        if(isset($condition['part_category3']) && $this->checkSearchItem($condition['part_category3'])){
            $queryBuilder->like("$tableProduct.part_category3", trim($condition['part_category3']));
        }

        if(isset($condition['sctype']) && $this->checkSearchItem($condition['sctype'])){
            
            if ($condition['sctype'] == "newproduct"){
                $queryBuilder->like("$tableProduct.newproduct_chk", 1);

            } elseif ($condition['sctype'] == "bestproduct"){
                $queryBuilder->like("$tableProduct.bestproduct_chk", 1);

            } elseif ($condition['sctype'] == "recomproduct"){
                $queryBuilder->like("$tableProduct.recomproduct_chk", 1);

            } elseif ($condition['sctype'] == "brandproduct"){
                $queryBuilder->like("$tableProduct.brandproduct_chk", 1);

            } elseif ($condition['sctype'] == "navershop"){
                $queryBuilder->like("$tableProduct.navershop_chk", 1);

            } elseif ($condition['sctype'] == "event"){
               $queryBuilder->notlike("$tableProduct.event_set", 0);
               
            }
           // exit;
        }

        
        // $queryBuilder->join($tableManufacturer,"$tableManufacturer.maker_seq = $tableProduct.maker_seq");
        // $queryBuilder->select("$tableProduct.* , $tableManufacturer.maker_seq , $tableManufacturer.name as makername");
        $queryBuilder->select("$tableProduct.*");

        if($condition['sort'] == "recent") {
            // var_dump($condition['sort']);
            $queryBuilder->orderBy("$tableProduct.created_at desc");
        } elseif($condition['sort'] == "hprice") {
            // var_dump($condition['sort']);
            $queryBuilder->orderBy("$tableProduct.selling_price1 desc");
        } elseif($condition['sort'] == "lprice") {
            // var_dump($condition['sort']);
            $queryBuilder->orderBy("$tableProduct.selling_price1 ASC");
        } elseif($condition['sort'] == "brand") {
            // var_dump($condition['sort']);
            $queryBuilder->orderBy("$tableProduct.maker_seq ASC");
        } else {
            $queryBuilder->orderBy("$tableProduct.created_at desc");
        }

        if(!isset($limit)) $limit = 20;
        
        if($allData){

            $dataResult = $queryBuilder->findAll($limit);
            if(count($dataResult) > 0){
                //Get data manufacturer for product
                $manufacturerModel = new ManufacturerModel();
                $listManufacturer = $manufacturerModel->findAll();
                if(count($listManufacturer) > 0){
                    $mapManufacturer = ArrayHelper::parseListObjectToArrayKey($listManufacturer,'maker_seq');
                    foreach ($dataResult as $product){
                        if(isset($mapManufacturer[$product->maker_seq])){
                            $manufacturer = $mapManufacturer[$product->maker_seq];
                            $product->maker_code = $manufacturer->maker_code;
                            $product->name = $manufacturer->name;
                        }
                    }
                }
                
                $packagingUnitModel = new PackagingUnitModel();
                $listpackagingUnits = $packagingUnitModel->findAll();
                if(count($listpackagingUnits) > 0){
                    $mapPackagingUnit = ArrayHelper::parseListObjectToArrayKey($listpackagingUnits,'packing_code');
                    foreach ($dataResult['lists'] as $product){
                        if(isset($mapPackagingUnit[$product->packing_code])){
                            $packagingUnit = $mapPackagingUnit[$product->packing_code];
                            $product->packing_code = $packagingUnit->packing_code;
                            $product->packing_name = $packagingUnit->packing_name;
                        }
                    }
                }

                $deliverycodeModel = new DeliverycodeModel();
                $listdeliverycodes = $deliverycodeModel->findAll();
                if(count($listdeliverycodes) > 0){
                    $mapDeliverycode = ArrayHelper::parseListObjectToArrayKey($listdeliverycodes,'id');
                    foreach ($dataResult['lists'] as $product){
                        if(isset($mapDeliverycode[$product->delivery_code])){
                            $deliverycode = $mapDeliverycode[$product->delivery_code];
                            $product->delivery_code = $deliverycode->id;
                            $product->delivery_info = $deliverycode->info;
                            $product->delivery_price = $deliverycode->price;
                            
                        }
                    }
                }

                $stocklocationCategoryModel = new StocklocationCategoryModel();
                $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
                if(count($liststocklocationCategorys) > 0){
                    $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
                    foreach ($dataResult['lists'] as $product){
                        if(isset($mapStocklocationCategory[$product->stock_location])){
                            $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                            $product->stock_location = $stocklocationCategory->location_id;
                            $product->location_info = $stocklocationCategory->location_info;
                            
                        }
                    }
                }

                $stocklocationCategoryModel = new StocklocationCategoryModel();
                $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
                if(count($liststocklocationCategorys) > 0){
                    $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
                    foreach ($dataResult['lists'] as $product){
                        if(isset($mapStocklocationCategory[$product->stock_location])){
                            $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                            $product->stock_location = $stocklocationCategory->location_id;
                            $product->location_info = $stocklocationCategory->location_info;
                            
                        }
                    }
                }

                $leadtimeCategoryModel = new LeadtimeCategoryModel();
                $listleadtimeCategorys = $leadtimeCategoryModel->findAll();
                if(count($listleadtimeCategorys) > 0){
                    $mapLeadtimeCategory = ArrayHelper::parseListObjectToArrayKey($listleadtimeCategorys,'leadtime_id');
                    foreach ($dataResult['lists'] as $product){
                        if(isset($mapLeadtimeCategory[$product->leadtime])){
                            $leadtimeCategory = $mapLeadtimeCategory[$product->leadtime];
                            $product->leadtime = $leadtimeCategory->leadtime_id;
                            $product->leadtime_info = $leadtimeCategory->leadtime_info;
                            
                        }
                    }
                }                
    
            }
            return $dataResult;
        }


        $dataResult = $this->executePaginate($queryBuilder, $limit);
 
    // MDI2020 test
    //var_dump($dataResult);

        if(count($dataResult['lists']) > 0){
            //Get data manufacturer for product
            $manufacturerModel = new ManufacturerModel();
            $listManufacturer = $manufacturerModel->findAll();
            //var_dump($listManufacturer);
            //exit;
            if(count($listManufacturer) > 0){
                $mapManufacturer = ArrayHelper::parseListObjectToArrayKey($listManufacturer,'maker_seq');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapManufacturer[$product->maker_seq])){
                        $manufacturer = $mapManufacturer[$product->maker_seq];
                        $product->maker_code = $manufacturer->maker_code;
                        $product->name = $manufacturer->name;

                    }
                }
            }
            
            $packagingUnitModel = new PackagingUnitModel();
            $listpackagingUnits = $packagingUnitModel->findAll();
            if(count($listpackagingUnits) > 0){
                $mapPackagingUnit = ArrayHelper::parseListObjectToArrayKey($listpackagingUnits,'packing_code');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapPackagingUnit[$product->packing_code])){
                        $packagingUnit = $mapPackagingUnit[$product->packing_code];
                        $product->packing_code = $packagingUnit->packing_code;
                        $product->packing_name = $packagingUnit->packing_name;
                    }
                }
            }

            $deliverycodeModel = new DeliverycodeModel();
            $listdeliverycodes = $deliverycodeModel->findAll();
            if(count($listdeliverycodes) > 0){
                $mapDeliverycode = ArrayHelper::parseListObjectToArrayKey($listdeliverycodes,'id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapDeliverycode[$product->delivery_code])){
                        $deliverycode = $mapDeliverycode[$product->delivery_code];
                        $product->delivery_code = $deliverycode->id;
                        $product->delivery_info = $deliverycode->info;
                        $product->delivery_price = $deliverycode->price;
                        
                    }
                }
            }

            $stocklocationCategoryModel = new StocklocationCategoryModel();
            $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
            if(count($liststocklocationCategorys) > 0){
                $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapStocklocationCategory[$product->stock_location])){
                        $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                        $product->stock_location = $stocklocationCategory->location_id;
                        $product->location_info = $stocklocationCategory->location_info;
                        
                    }
                }
            }         
                        
            $leadtimeCategoryModel = new LeadtimeCategoryModel();
            $listleadtimeCategorys = $leadtimeCategoryModel->findAll();
            if(count($listleadtimeCategorys) > 0){
                $mapLeadtimeCategory = ArrayHelper::parseListObjectToArrayKey($listleadtimeCategorys,'leadtime_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapLeadtimeCategory[$product->leadtime])){
                        $leadtimeCategory = $mapLeadtimeCategory[$product->leadtime];
                        $product->leadtime = $leadtimeCategory->leadtime_id;
                        $product->leadtime_info = $leadtimeCategory->leadtime_info;
                        
                    }
                }
            }   

            // var_dump($product);
            // exit;
        }

      if(count($dataResult['lists']) > 0){

      }

        return $dataResult;
    }

/******************************************************************************************/

/** 쿼리향상 테스트 **/
public function getSearch($condition = [], $limit = 20 , $allData = false){
    
    if(!isset($condition)) $condition = [];

    $tableProduct = ProductModel::getTableName();
    // $tableProductdetail = ProductdetailModel::getTableName();
    $tableManufacturer = ManufacturerModel::getTableName();
    $tableCategorylevel1 = Categorylevel1Model::getTableName();
    $tableCategorylevel2 = Categorylevel2Model::getTableName();
    $tableCategorylevel3 = Categorylevel3Model::getTableName();

    $queryBuilder = $this->where("$tableProduct.del_flg", DELETE_FLG_OFF);
    $queryBuilder = $this->where("$tableProduct.exposure", DELETE_FLG_OFF);

    if(isset($condition['from_date']) && $this->checkSearchItem($condition['from_date'])){
        $queryBuilder->where("$tableProduct.created_at >=", esc($condition['from_date']));
    }
    if(isset($condition['to_date']) && $this->checkSearchItem($condition['to_date'])){
        $queryBuilder->where("$tableProduct.created_at <=", esc($condition['to_date']));
    }

    if(isset($condition['keyword']) && $this->checkSearchItem($condition['keyword'])){
            //$queryBuilder->join($tableManufacturer,"$tableManufacturer.maker_seq = $tableProduct.maker_seq");

            // $str = preg_replace("/\s+/", "", $condition['keyword']);
            // $keyword = str_replace(array("/", "-", "_", "[", "]", "(", ")", ",", "."), '', $str);

            $keyword = $condition['keyword'];

            if(isset($condition['search_code']) && $this->checkSearchItem($condition['search_code'])) {
                $queryBuilder->where("$tableProduct.part_category", trim($condition['search_code']));
            }

            $queryBuilder->like("$tableProduct.part_number", trim($keyword));
            // $queryBuilder->like("$tableProduct.virtualpn", trim($keyword));
            // $queryBuilder->orlike("$tableManufacturer.name", trim($condition['keyword']));
    }

    if(isset($condition['part_number']) && $this->checkSearchItem($condition['part_number'])){
        $queryBuilder->like("$tableProduct.part_number", trim($condition['part_number']));
    }

    if(isset($condition['part_category']) && $this->checkSearchItem($condition['part_category'])){
        $queryBuilder->like("$tableProduct.part_category", trim($condition['part_category']));
    }
    
    if(isset($condition['part_category2']) && $this->checkSearchItem($condition['part_category2'])){
        $queryBuilder->like("$tableProduct.part_category2", trim($condition['part_category2']));
    }

    if(isset($condition['part_category3']) && $this->checkSearchItem($condition['part_category3'])){
        $queryBuilder->like("$tableProduct.part_category3", trim($condition['part_category3']));
    }

    // $this->join($tableProductdetail,"$tableProductdetail.product_code = $tableProduct.product_code");
    // $queryBuilder->select("$tableProduct.*, $tableProductdetail.product_doc");

    $queryBuilder->select("$tableProduct.*");

    if($condition['sort'] == "recent") {
        $queryBuilder->orderBy("$tableProduct.created_at desc");
    } elseif($condition['sort'] == "hprice") {
        $queryBuilder->orderBy("$tableProduct.selling_price1 desc");
    } elseif($condition['sort'] == "lprice") {
        $queryBuilder->orderBy("$tableProduct.selling_price1 ASC");
    } elseif($condition['sort'] == "brand") {
        $queryBuilder->orderBy("$tableProduct.maker_seq ASC");
    } else {
        // $queryBuilder->orderBy("$tableProduct.created_at desc");
        // $queryBuilder->orderBy("rand()"); //랜덤 검색
        $queryBuilder->orderBy("$tableProduct.qty DESC");
        // $queryBuilder->orderBy("$tableProduct.selling_price1 DESC");
        // $queryBuilder->orderBy("$tableProduct.part_number ASC");
    }


    if(!isset($limit)) $limit = 20;

    if($allData){

        $dataResult = $queryBuilder->findAll($limit);


        if(count($dataResult) > 0){
            //Get data manufacturer for product
            $manufacturerModel = new ManufacturerModel();
            $listManufacturer = $manufacturerModel->findAll();
            if(count($listManufacturer) > 0){
                $mapManufacturer = ArrayHelper::parseListObjectToArrayKey($listManufacturer,'maker_seq');
                foreach ($dataResult as $product){
                    if(isset($mapManufacturer[$product->maker_seq])){
                        $manufacturer = $mapManufacturer[$product->maker_seq];
                        $product->maker_code = $manufacturer->maker_code;
                        $product->name = $manufacturer->name;
                    }
                }
            }

            $packagingUnitModel = new PackagingUnitModel();
            $listpackagingUnits = $packagingUnitModel->findAll();
            if(count($listpackagingUnits) > 0){
                $mapPackagingUnit = ArrayHelper::parseListObjectToArrayKey($listpackagingUnits,'packing_code');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapPackagingUnit[$product->packing_code])){
                        $packagingUnit = $mapPackagingUnit[$product->packing_code];
                        $product->packing_code = $packagingUnit->packing_code;
                        $product->packing_name = $packagingUnit->packing_name;
                    }
                }
            }

            $deliverycodeModel = new DeliverycodeModel();
            $listdeliverycodes = $deliverycodeModel->findAll();
            if(count($listdeliverycodes) > 0){
                $mapDeliverycode = ArrayHelper::parseListObjectToArrayKey($listdeliverycodes,'id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapDeliverycode[$product->delivery_code])){
                        $deliverycode = $mapDeliverycode[$product->delivery_code];
                        $product->delivery_code = $deliverycode->id;
                        $product->delivery_info = $deliverycode->info;
                        $product->delivery_price = $deliverycode->price;
                        
                    }
                }
            }

            $stocklocationCategoryModel = new StocklocationCategoryModel();
            $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
            if(count($liststocklocationCategorys) > 0){
                $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapStocklocationCategory[$product->stock_location])){
                        $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                        $product->stock_location = $stocklocationCategory->location_id;
                        $product->location_info = $stocklocationCategory->location_info;
                        
                    }
                }
            }

            $stocklocationCategoryModel = new StocklocationCategoryModel();
            $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
            if(count($liststocklocationCategorys) > 0){
                $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapStocklocationCategory[$product->stock_location])){
                        $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                        $product->stock_location = $stocklocationCategory->location_id;
                        $product->location_info = $stocklocationCategory->location_info;
                        
                    }
                }
            }

            $leadtimeCategoryModel = new LeadtimeCategoryModel();
            $listleadtimeCategorys = $leadtimeCategoryModel->findAll();
            if(count($listleadtimeCategorys) > 0){
                $mapLeadtimeCategory = ArrayHelper::parseListObjectToArrayKey($listleadtimeCategorys,'leadtime_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapLeadtimeCategory[$product->leadtime])){
                        $leadtimeCategory = $mapLeadtimeCategory[$product->leadtime];
                        $product->leadtime = $leadtimeCategory->leadtime_id;
                        $product->leadtime_info = $leadtimeCategory->leadtime_info;
                        
                    }
                }
            }                

        }
        return $dataResult;
    }

    $dataResult = $this->executePaginate($queryBuilder, $limit);

    // echo $this->db->showLastQuery();

    // MDI2020 test
    //var_dump($dataResult);

    if(count($dataResult['lists']) > 0){
        //Get data manufacturer for product
        $manufacturerModel = new ManufacturerModel();
        $listManufacturer = $manufacturerModel->findAll();
        //var_dump($listManufacturer);
        //exit;
        if(count($listManufacturer) > 0){
            $mapManufacturer = ArrayHelper::parseListObjectToArrayKey($listManufacturer,'maker_seq');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapManufacturer[$product->maker_seq])){
                    $manufacturer = $mapManufacturer[$product->maker_seq];
                    $product->maker_code = $manufacturer->maker_code;
                    $product->name = $manufacturer->name;
                }
            }
        }

        $packagingUnitModel = new PackagingUnitModel();
        $listpackagingUnits = $packagingUnitModel->findAll();
        if(count($listpackagingUnits) > 0){
            $mapPackagingUnit = ArrayHelper::parseListObjectToArrayKey($listpackagingUnits,'packing_code');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapPackagingUnit[$product->packing_code])){
                    $packagingUnit = $mapPackagingUnit[$product->packing_code];
                    $product->packing_code = $packagingUnit->packing_code;
                    $product->packing_name = $packagingUnit->packing_name;
                }
            }
        }

        $deliverycodeModel = new DeliverycodeModel();
        $listdeliverycodes = $deliverycodeModel->findAll();
        if(count($listdeliverycodes) > 0){
            $mapDeliverycode = ArrayHelper::parseListObjectToArrayKey($listdeliverycodes,'id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapDeliverycode[$product->delivery_code])){
                    $deliverycode = $mapDeliverycode[$product->delivery_code];
                    $product->delivery_code = $deliverycode->id;
                    $product->delivery_info = $deliverycode->info;
                    $product->delivery_price = $deliverycode->price;
                    
                }
            }
        }

        $stocklocationCategoryModel = new StocklocationCategoryModel();
        $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
        if(count($liststocklocationCategorys) > 0){
            $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapStocklocationCategory[$product->stock_location])){
                    $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                    $product->stock_location = $stocklocationCategory->location_id;
                    $product->location_info = $stocklocationCategory->location_info;
                    
                }
            }
        }         
                    
        $leadtimeCategoryModel = new LeadtimeCategoryModel();
        $listleadtimeCategorys = $leadtimeCategoryModel->findAll();
        if(count($listleadtimeCategorys) > 0){
            $mapLeadtimeCategory = ArrayHelper::parseListObjectToArrayKey($listleadtimeCategorys,'leadtime_id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapLeadtimeCategory[$product->leadtime])){
                    $leadtimeCategory = $mapLeadtimeCategory[$product->leadtime];
                    $product->leadtime = $leadtimeCategory->leadtime_id;
                    $product->leadtime_info = $leadtimeCategory->leadtime_info;
                    
                }
            }
        }   

        // var_dump($product);
        // exit;
    }

  if(count($dataResult['lists']) > 0){

  }

    return $dataResult;
}


/******************************************************************************************/

public function getNavershopping($condition = [], $limit = 50 , $allData = false){

    if(!isset($condition)) $condition = [];
    //var_dump($condition);

    $tableProduct = ProductModel::getTableName();
    $tableManufacturer = ManufacturerModel::getTableName();

    $queryBuilder = $this->where("$tableProduct.del_flg", DELETE_FLG_OFF);

    if(isset($condition['qty_chk']) && $this->checkSearchItem($condition['qty_chk'])){
    $queryBuilder->where("$tableProduct.qty >", esc(0));
    }

    if(isset($condition['price_chk']) && $this->checkSearchItem($condition['price_chk'])){
        $queryBuilder->where("$tableProduct.selling_price1 >", esc(0));
    }

    if(isset($condition['ep_chk']) && $this->checkSearchItem($condition['ep_chk'])){
        $queryBuilder->where("$tableProduct.navershop_chk >", esc(0));
    }

    if(isset($condition['part_number']) && $this->checkSearchItem($condition['part_number'])){
        $queryBuilder->like("$tableProduct.part_number", trim($condition['part_number']));
    }

    if(isset($condition['manufacturer_code']) && $this->checkSearchItem($condition['manufacturer_code'])){
        $queryBuilder->where("$tableProduct.maker_seq", esc($condition['manufacturer_code']));
    }

    if(isset($condition['search_code']) && $this->checkSearchItem($condition['search_code'])){
        $queryBuilder->like("$tableProduct.part_category", trim($condition['search_code']));
    }

    if(isset($condition['part_category']) && $this->checkSearchItem($condition['part_category'])){
        $queryBuilder->like("$tableProduct.part_category", trim($condition['part_category']));
    }
    
    if(isset($condition['part_category2']) && $this->checkSearchItem($condition['part_category2'])){
        $queryBuilder->like("$tableProduct.part_category2", trim($condition['part_category2']));
    }

    if(isset($condition['part_category3']) && $this->checkSearchItem($condition['part_category3'])){
        $queryBuilder->like("$tableProduct.part_category3", trim($condition['part_category3']));
    }

    $queryBuilder->join($tableManufacturer,"$tableManufacturer.maker_seq = $tableProduct.maker_seq");
    $queryBuilder->select("$tableProduct.* , $tableManufacturer.maker_seq , $tableManufacturer.name as maker_name");
    $queryBuilder->orderBy("$tableProduct.created_at desc");

    if(!isset($limit)) $limit = 50;

    $dataResult = $this->executePaginate($queryBuilder, $limit);
    return $dataResult;
}

/******************************************************************************************/

public function getPartList($condition = [], $limit = 10000, $allData = false){
    if(!isset($condition)) $condition = [];

    $tableProduct = ProductModel::getTableName();
    $queryBuilder = $this->where("$tableProduct.del_flg", DELETE_FLG_OFF);

    if(isset($condition['qty_chk']) && $this->checkSearchItem($condition['qty_chk'])){
    $queryBuilder->where("$tableProduct.qty >", esc(0));
    }

    if(isset($condition['price_chk']) && $this->checkSearchItem($condition['price_chk'])){
        $queryBuilder->where("$tableProduct.selling_price1 >", esc(0));
    }

    $queryBuilder->where("$tableProduct.navershop_chk >", esc(0));
    $queryBuilder->select("$tableProduct.part_number, $tableProduct.product_code");
    $queryBuilder->orderBy("$tableProduct.created_at desc");

    if(!isset($limit)) $limit = 10000;

    $dataResult = $this->executePaginate($queryBuilder, $limit);
    return $dataResult;
}

/******************************************************************************************/


public function getSearchTSV($limit){

    if(!isset($condition)) $condition = [];
    $tableProduct = ProductModel::getTableName();
    $tableManufacturer = ManufacturerModel::getTableName();

    $queryBuilder = $this->where("$tableProduct.del_flg", DELETE_FLG_OFF);
    $queryBuilder = $this->like("$tableProduct.navershop_chk", trim('1'));

    $queryBuilder->select("$tableProduct.*");
    $queryBuilder->orderBy("$tableProduct.created_at desc");

    $dataResult = $this->executePaginate($queryBuilder, $limit);

    return $dataResult;
}

/******************************************************************************************/

 public function getSearchExcel($condition = [], $limit = 10000 , $allData = false){
     // $part_number = $condition['part_number'];
     // var_dump($part_number); 
     // exit;
 
    if(!isset($condition)) $condition = [];
    $tableProduct = ProductModel::getTableName();
    $tableManufacturer = ManufacturerModel::getTableName();
    $tableCategorylevel1 = Categorylevel1Model::getTableName();
    $tableCategorylevel2 = Categorylevel2Model::getTableName();
    // $tableCategorylevel3 = Categorylevel3Model::getTableName();

     $queryBuilder = $this->where("$tableProduct.del_flg", DELETE_FLG_OFF);

     if(isset($condition['part_number']) && $this->checkSearchItem($condition['part_number'])){
        $queryBuilder->like("$tableProduct.part_number", trim($condition['part_number']));
    }

 
    $queryBuilder->join($tableManufacturer,"$tableManufacturer.maker_seq = $tableProduct.maker_seq");
    $queryBuilder->join($tableCategorylevel1,"$tableCategorylevel1.categorylevel1_code = $tableProduct.part_category");
    $queryBuilder->join($tableCategorylevel2,"$tableCategorylevel2.categorylevel2_code = $tableProduct.part_category2");
    // $queryBuilder->join($tableCategorylevel3,"$tableCategorylevel3.categorylevel3_code = $tableProduct.part_category3");

    $queryBuilder->select("$tableProduct.product_code, $tableProduct.part_category, $tableCategorylevel1.categorylevel1_name, $tableProduct.part_category2, $tableCategorylevel2.categorylevel2_name, $tableProduct.part_category3, $tableProduct.maker_seq, $tableManufacturer.name as maker_name, 
    $tableProduct.part_number, $tableProduct.part_number_sequence, $tableProduct.search_word, $tableProduct.brief_description, $tableProduct.date_code, $tableProduct.image_dir, $tableProduct.delivery_code, $tableProduct.api_flg, $tableProduct.api_code, $tableProduct.product_api_id, 
    $tableProduct.qty, $tableProduct.packing_code, $tableProduct.leadtime, $tableProduct.moq, $tableProduct.mpq, $tableProduct.stock_location, $tableProduct.selling_price1, $tableProduct.unit_mini_quantity1, $tableProduct.unit_max_quantity1, $tableProduct.selling_price2, $tableProduct.unit_mini_quantity2, 
    $tableProduct.unit_max_quantity2, $tableProduct.selling_price3, $tableProduct.unit_mini_quantity3, $tableProduct.unit_max_quantity3, $tableProduct.selling_price4, $tableProduct.unit_mini_quantity4, $tableProduct.unit_max_quantity4, $tableProduct.selling_price5, $tableProduct.unit_mini_quantity5, 
    $tableProduct.unit_max_quantity5, $tableProduct.selling_price6, $tableProduct.unit_mini_quantity6, $tableProduct.unit_max_quantity6, $tableProduct.updated_at
");

    // $queryBuilder->select("$tableProduct.* $tableCategorylevel1.categorylevel1_name, $tableCategorylevel2.categorylevel2_name, $tableManufacturer.name as maker_name");
    // $queryBuilder->select("$tableProduct.*");
    $queryBuilder->orderBy("$tableProduct.created_at desc");
    $dataResult = $this->executePaginate($queryBuilder, $limit);

    return $dataResult;
 }

/******************************************************************************************/
/******************************************************************************************/
/******************************************************************************************/



public function getProduct($condition, $limit = 20 , $allData = false){

    if(!isset($condition)) $condition = [];

    $tableProduct = ProductModel::getTableName();
    $tableManufacturer = ManufacturerModel::getTableName();

    $queryBuilder = $this->where("$tableProduct.del_flg", DELETE_FLG_OFF);
    $queryBuilder = $this->where("$tableProduct.exposure", DELETE_FLG_OFF);

    if($condition['product_sctype'] == "newproduct") {
        $queryBuilder->like("$tableProduct.newproduct_chk", trim('1'));
    } elseif($condition['product_sctype'] == "bestproduct") {
        $queryBuilder->like("$tableProduct.bestproduct_chk", trim('1'));
    } elseif($condition['product_sctype'] == "brandproduct") {
        $maker_seq = $condition['maker_seq'];
        $queryBuilder->where("$tableProduct.maker_seq", trim($maker_seq));
    } elseif($condition['product_sctype'] == "eventproduct") {
        $id = $condition['id'];
        $queryBuilder->where("$tableProduct.event_set", trim($id));
    } else {

    }

    $queryBuilder->select("$tableProduct.*");

    if($condition['sort'] == "recent") {
        $queryBuilder->orderBy("$tableProduct.created_at desc");

    } elseif($condition['sort'] == "hprice") {
        $queryBuilder->orderBy("$tableProduct.selling_price1 desc");

    } elseif($condition['sort'] == "lprice") {
        $queryBuilder->orderBy("$tableProduct.selling_price1 ASC");

    } elseif($condition['sort'] == "brand") {
        $queryBuilder->orderBy("$tableProduct.maker_seq ASC");

    } else {
        // $queryBuilder->orderBy("$tableProduct.qty_flag ASC");
        // $queryBuilder->orderBy("$tableProduct.part_number ASC");
        $queryBuilder->orderBy("$tableProduct.qty DESC");
        // $queryBuilder->orderBy("$tableProduct.selling_price1 DESC");

    }

    if(!isset($limit)) $limit = 20;
    if($allData){

        $dataResult = $queryBuilder->findAll($limit);
        if(count($dataResult) > 0){
            //Get data manufacturer for product
            $manufacturerModel = new ManufacturerModel();
            $listManufacturer = $manufacturerModel->findAll();
            if(count($listManufacturer) > 0){
                $mapManufacturer = ArrayHelper::parseListObjectToArrayKey($listManufacturer,'maker_seq');
                foreach ($dataResult as $product){
                    if(isset($mapManufacturer[$product->maker_seq])){
                        $manufacturer = $mapManufacturer[$product->maker_seq];
                        $product->maker_code = $manufacturer->maker_code;
                        $product->name = $manufacturer->name;
                    }
                }
            }

            $packagingUnitModel = new PackagingUnitModel();
            $listpackagingUnits = $packagingUnitModel->findAll();
            if(count($listpackagingUnits) > 0){
                $mapPackagingUnit = ArrayHelper::parseListObjectToArrayKey($listpackagingUnits,'packing_code');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapPackagingUnit[$product->packing_code])){
                        $packagingUnit = $mapPackagingUnit[$product->packing_code];
                        $product->packing_code = $packagingUnit->packing_code;
                        $product->packing_name = $packagingUnit->packing_name;
                    }
                }
            }

            $deliverycodeModel = new DeliverycodeModel();
            $listdeliverycodes = $deliverycodeModel->findAll();
            if(count($listdeliverycodes) > 0){
                $mapDeliverycode = ArrayHelper::parseListObjectToArrayKey($listdeliverycodes,'id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapDeliverycode[$product->delivery_code])){
                        $deliverycode = $mapDeliverycode[$product->delivery_code];
                        $product->delivery_code = $deliverycode->id;
                        $product->delivery_info = $deliverycode->info;
                        $product->delivery_price = $deliverycode->price;
                        
                    }
                }
            }

            $stocklocationCategoryModel = new StocklocationCategoryModel();
            $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
            if(count($liststocklocationCategorys) > 0){
                $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapStocklocationCategory[$product->stock_location])){
                        $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                        $product->stock_location = $stocklocationCategory->location_id;
                        $product->location_info = $stocklocationCategory->location_info;
                        
                    }
                }
            }

            $stocklocationCategoryModel = new StocklocationCategoryModel();
            $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
            if(count($liststocklocationCategorys) > 0){
                $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapStocklocationCategory[$product->stock_location])){
                        $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                        $product->stock_location = $stocklocationCategory->location_id;
                        $product->location_info = $stocklocationCategory->location_info;
                        
                    }
                }
            }

            $leadtimeCategoryModel = new LeadtimeCategoryModel();
            $listleadtimeCategorys = $leadtimeCategoryModel->findAll();
            if(count($listleadtimeCategorys) > 0){
                $mapLeadtimeCategory = ArrayHelper::parseListObjectToArrayKey($listleadtimeCategorys,'leadtime_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapLeadtimeCategory[$product->leadtime])){
                        $leadtimeCategory = $mapLeadtimeCategory[$product->leadtime];
                        $product->leadtime = $leadtimeCategory->leadtime_id;
                        $product->leadtime_info = $leadtimeCategory->leadtime_info;
                        
                    }
                }
            }                

        }
        return $dataResult;
    }


    $dataResult = $this->executePaginate($queryBuilder, $limit);

// MDI2020 test
//var_dump($dataResult);

    if(count($dataResult['lists']) > 0){
        //Get data manufacturer for product
        $manufacturerModel = new ManufacturerModel();
        $listManufacturer = $manufacturerModel->findAll();
        //var_dump($listManufacturer);
        //exit;
        if(count($listManufacturer) > 0){
            $mapManufacturer = ArrayHelper::parseListObjectToArrayKey($listManufacturer,'maker_seq');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapManufacturer[$product->maker_seq])){
                    $manufacturer = $mapManufacturer[$product->maker_seq];
                    $product->maker_code = $manufacturer->maker_code;
                    $product->name = $manufacturer->name;

                }
            }
        }

        $packagingUnitModel = new PackagingUnitModel();
        $listpackagingUnits = $packagingUnitModel->findAll();
        if(count($listpackagingUnits) > 0){
            $mapPackagingUnit = ArrayHelper::parseListObjectToArrayKey($listpackagingUnits,'packing_code');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapPackagingUnit[$product->packing_code])){
                    $packagingUnit = $mapPackagingUnit[$product->packing_code];
                    $product->packing_code = $packagingUnit->packing_code;
                    $product->packing_name = $packagingUnit->packing_name;
                }
            }
        }

        $deliverycodeModel = new DeliverycodeModel();
        $listdeliverycodes = $deliverycodeModel->findAll();
        if(count($listdeliverycodes) > 0){
            $mapDeliverycode = ArrayHelper::parseListObjectToArrayKey($listdeliverycodes,'id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapDeliverycode[$product->delivery_code])){
                    $deliverycode = $mapDeliverycode[$product->delivery_code];
                    $product->delivery_code = $deliverycode->id;
                    $product->delivery_info = $deliverycode->info;
                    $product->delivery_price = $deliverycode->price;
                    
                }
            }
        }

        $stocklocationCategoryModel = new StocklocationCategoryModel();
        $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
        if(count($liststocklocationCategorys) > 0){
            $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapStocklocationCategory[$product->stock_location])){
                    $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                    $product->stock_location = $stocklocationCategory->location_id;
                    $product->location_info = $stocklocationCategory->location_info;
                    
                }
            }
        }         
                    
        $leadtimeCategoryModel = new LeadtimeCategoryModel();
        $listleadtimeCategorys = $leadtimeCategoryModel->findAll();
        if(count($listleadtimeCategorys) > 0){
            $mapLeadtimeCategory = ArrayHelper::parseListObjectToArrayKey($listleadtimeCategorys,'leadtime_id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapLeadtimeCategory[$product->leadtime])){
                    $leadtimeCategory = $mapLeadtimeCategory[$product->leadtime];
                    $product->leadtime = $leadtimeCategory->leadtime_id;
                    $product->leadtime_info = $leadtimeCategory->leadtime_info;
                    
                }
            }
        }   

        //var_dump($product);
        //exit;
    }

  if(count($dataResult['lists']) > 0){

  }

    return $dataResult;
}


public function getNewproduct($condition, $limit = 20 , $allData = false){

    $day_7ago = date('Y-m-d H:i:s', strtotime('-7 Day'));
    //var_dump($day_7ago);
    //exit;

    if(!isset($condition)) $condition = [];

    $tableProduct = ProductModel::getTableName();
    $tableManufacturer = ManufacturerModel::getTableName();

    $queryBuilder = $this->where("$tableProduct.del_flg", DELETE_FLG_OFF);
    $queryBuilder = $this->where("$tableProduct.exposure", DELETE_FLG_OFF);
    $queryBuilder = $this->where("$tableProduct.created_at >=", $day_7ago);
    $queryBuilder = $this->orLike("$tableProduct.newproduct_chk", trim('1'));

    // select * from products where `created_at` > date_add(now(),interval -7 day)

    $queryBuilder->select("$tableProduct.*");

    if($condition['sort'] == "recent") {
        $queryBuilder->orderBy("$tableProduct.created_at desc");
    } elseif($condition['sort'] == "hprice") {
        $queryBuilder->orderBy("$tableProduct.selling_price1 desc");
    } elseif($condition['sort'] == "lprice") {
        $queryBuilder->orderBy("$tableProduct.selling_price1 ASC");
    } elseif($condition['sort'] == "brand") {
        $queryBuilder->orderBy("$tableProduct.maker_seq ASC");
    } else {
        $queryBuilder->orderBy("$tableProduct.newproduct_chk desc");
    }

    if(!isset($limit)) $limit = 20;
    if($allData){

        $dataResult = $queryBuilder->findAll($limit);
        if(count($dataResult) > 0){
            //Get data manufacturer for product
            $manufacturerModel = new ManufacturerModel();
            $listManufacturer = $manufacturerModel->findAll();
            if(count($listManufacturer) > 0){
                $mapManufacturer = ArrayHelper::parseListObjectToArrayKey($listManufacturer,'maker_seq');
                foreach ($dataResult as $product){
                    if(isset($mapManufacturer[$product->maker_seq])){
                        $manufacturer = $mapManufacturer[$product->maker_seq];
                        $product->maker_code = $manufacturer->maker_code;
                        $product->name = $manufacturer->name;
                    }
                }
            }

            $packagingUnitModel = new PackagingUnitModel();
            $listpackagingUnits = $packagingUnitModel->findAll();
            if(count($listpackagingUnits) > 0){
                $mapPackagingUnit = ArrayHelper::parseListObjectToArrayKey($listpackagingUnits,'packing_code');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapPackagingUnit[$product->packing_code])){
                        $packagingUnit = $mapPackagingUnit[$product->packing_code];
                        $product->packing_code = $packagingUnit->packing_code;
                        $product->packing_name = $packagingUnit->packing_name;
                    }
                }
            }

            $deliverycodeModel = new DeliverycodeModel();
            $listdeliverycodes = $deliverycodeModel->findAll();
            if(count($listdeliverycodes) > 0){
                $mapDeliverycode = ArrayHelper::parseListObjectToArrayKey($listdeliverycodes,'id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapDeliverycode[$product->delivery_code])){
                        $deliverycode = $mapDeliverycode[$product->delivery_code];
                        $product->delivery_code = $deliverycode->id;
                        $product->delivery_info = $deliverycode->info;
                        $product->delivery_price = $deliverycode->price;
                        
                    }
                }
            }

            $stocklocationCategoryModel = new StocklocationCategoryModel();
            $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
            if(count($liststocklocationCategorys) > 0){
                $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapStocklocationCategory[$product->stock_location])){
                        $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                        $product->stock_location = $stocklocationCategory->location_id;
                        $product->location_info = $stocklocationCategory->location_info;
                        
                    }
                }
            }

            $stocklocationCategoryModel = new StocklocationCategoryModel();
            $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
            if(count($liststocklocationCategorys) > 0){
                $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapStocklocationCategory[$product->stock_location])){
                        $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                        $product->stock_location = $stocklocationCategory->location_id;
                        $product->location_info = $stocklocationCategory->location_info;
                        
                    }
                }
            }

            $leadtimeCategoryModel = new LeadtimeCategoryModel();
            $listleadtimeCategorys = $leadtimeCategoryModel->findAll();
            if(count($listleadtimeCategorys) > 0){
                $mapLeadtimeCategory = ArrayHelper::parseListObjectToArrayKey($listleadtimeCategorys,'leadtime_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapLeadtimeCategory[$product->leadtime])){
                        $leadtimeCategory = $mapLeadtimeCategory[$product->leadtime];
                        $product->leadtime = $leadtimeCategory->leadtime_id;
                        $product->leadtime_info = $leadtimeCategory->leadtime_info;
                        
                    }
                }
            }                

        }
        return $dataResult;
    }


    $dataResult = $this->executePaginate($queryBuilder, $limit);

// MDI2020 test
//var_dump($dataResult);

    if(count($dataResult['lists']) > 0){
        //Get data manufacturer for product
        $manufacturerModel = new ManufacturerModel();
        $listManufacturer = $manufacturerModel->findAll();
        //var_dump($listManufacturer);
        //exit;
        if(count($listManufacturer) > 0){
            $mapManufacturer = ArrayHelper::parseListObjectToArrayKey($listManufacturer,'maker_seq');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapManufacturer[$product->maker_seq])){
                    $manufacturer = $mapManufacturer[$product->maker_seq];
                    $product->maker_code = $manufacturer->maker_code;
                    $product->name = $manufacturer->name;

                }
            }
        }

        $packagingUnitModel = new PackagingUnitModel();
        $listpackagingUnits = $packagingUnitModel->findAll();
        if(count($listpackagingUnits) > 0){
            $mapPackagingUnit = ArrayHelper::parseListObjectToArrayKey($listpackagingUnits,'packing_code');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapPackagingUnit[$product->packing_code])){
                    $packagingUnit = $mapPackagingUnit[$product->packing_code];
                    $product->packing_code = $packagingUnit->packing_code;
                    $product->packing_name = $packagingUnit->packing_name;
                }
            }
        }

        $deliverycodeModel = new DeliverycodeModel();
        $listdeliverycodes = $deliverycodeModel->findAll();
        if(count($listdeliverycodes) > 0){
            $mapDeliverycode = ArrayHelper::parseListObjectToArrayKey($listdeliverycodes,'id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapDeliverycode[$product->delivery_code])){
                    $deliverycode = $mapDeliverycode[$product->delivery_code];
                    $product->delivery_code = $deliverycode->id;
                    $product->delivery_info = $deliverycode->info;
                    $product->delivery_price = $deliverycode->price;
                    
                }
            }
        }

        $stocklocationCategoryModel = new StocklocationCategoryModel();
        $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
        if(count($liststocklocationCategorys) > 0){
            $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapStocklocationCategory[$product->stock_location])){
                    $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                    $product->stock_location = $stocklocationCategory->location_id;
                    $product->location_info = $stocklocationCategory->location_info;
                    
                }
            }
        }         
                    
        $leadtimeCategoryModel = new LeadtimeCategoryModel();
        $listleadtimeCategorys = $leadtimeCategoryModel->findAll();
        if(count($listleadtimeCategorys) > 0){
            $mapLeadtimeCategory = ArrayHelper::parseListObjectToArrayKey($listleadtimeCategorys,'leadtime_id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapLeadtimeCategory[$product->leadtime])){
                    $leadtimeCategory = $mapLeadtimeCategory[$product->leadtime];
                    $product->leadtime = $leadtimeCategory->leadtime_id;
                    $product->leadtime_info = $leadtimeCategory->leadtime_info;
                    
                }
            }
        }   

        //var_dump($product);
        //exit;
    }

  if(count($dataResult['lists']) > 0){

  }

    return $dataResult;
}


/**** 2020-12-05 ***********/
public function getCategorySearch($condition = [], $condition2 = [], $limit = 20 , $allData = false){
    if(!isset($condition)) $condition = [];
    if(!isset($condition2)) $condition2 = [];

    $tableProduct = ProductModel::getTableName();
    $tableManufacturer = ManufacturerModel::getTableName();
    $queryBuilder = $this->where("$tableProduct.del_flg", DELETE_FLG_OFF);
    $queryBuilder = $this->where("$tableProduct.exposure", DELETE_FLG_OFF);

    if(isset($condition2['category']) && $this->checkSearchItem($condition2['category'])){
        $queryBuilder->where("$tableProduct.part_category", trim($condition2['category']));
    }

    if(isset($condition['part_number']) && $this->checkSearchItem($condition['part_number'])){
        $queryBuilder->like("$tableProduct.part_number", trim($condition['part_number'])); //검색어 포함 검색
        //$queryBuilder->where("$tableProduct.part_number", trim($condition['part_number'])); //검색어만 검색
    }

        
	// MDI2020 test
    // var_dump($condition2);
    // var_dump($condition);

    $queryBuilder->select("$tableProduct.*");

    if($condition['sort'] == "recent") {
        // var_dump($condition['sort']);
        $queryBuilder->orderBy("$tableProduct.created_at desc");
    } elseif($condition['sort'] == "hprice") {
        //var_dump($condition['sort']);
        $queryBuilder->orderBy("$tableProduct.selling_price1 desc");
    } elseif($condition['sort'] == "lprice") {
        //var_dump($condition['sort']);
        $queryBuilder->orderBy("$tableProduct.selling_price1 ASC");
    } elseif($condition['sort'] == "brand") {
        // var_dump($condition['sort']);
        $queryBuilder->orderBy("$tableProduct.maker_seq ASC");
    } else {
        $queryBuilder->orderBy("$tableProduct.created_at desc");
    }

    if(!isset($limit)) $limit = 20;

    $dataResult = $this->executePaginate($queryBuilder, $limit);

    if(count($dataResult['lists']) > 0){
        //Get data manufacturer for product
        $manufacturerModel = new ManufacturerModel();
        $listManufacturer = $manufacturerModel->findAll();
        if(count($listManufacturer) > 0){
            $mapManufacturer = ArrayHelper::parseListObjectToArrayKey($listManufacturer,'maker_seq');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapManufacturer[$product->maker_seq])){
                    $manufacturer = $mapManufacturer[$product->maker_seq];
                    $product->maker_code = $manufacturer->maker_code;
                    $product->name = $manufacturer->name;
                }
            }
        }

        $packagingUnitModel = new PackagingUnitModel();
        $listpackagingUnits = $packagingUnitModel->findAll();
        if(count($listpackagingUnits) > 0){
            $mapPackagingUnit = ArrayHelper::parseListObjectToArrayKey($listpackagingUnits,'packing_code');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapPackagingUnit[$product->packing_code])){
                    $packagingUnit = $mapPackagingUnit[$product->packing_code];
                    $product->packing_code = $packagingUnit->packing_code;
                    $product->packing_name = $packagingUnit->packing_name;
                }
            }
        }

    }

    return $dataResult;
}

    public function findByProductId($productId){
        $tableProduct = ProductModel::getTableName();
        $tableManufacturer = ManufacturerModel::getTableName();
        $tablePackagingUnit = PackagingUnitModel::getTableName();
        $tableDeliverycode = DeliverycodeModel::getTableName();
        $tableStocklocationCategory = StocklocationCategoryModel::getTableName();
        $tableLeadtimeCategory = LeadtimeCategoryModel::getTableName();

        $this->join($tableManufacturer,"$tableManufacturer.maker_seq = $tableProduct.maker_seq");
        $this->join($tablePackagingUnit,"$tablePackagingUnit.packing_code = $tableProduct.packing_code");
        $this->join($tableDeliverycode,"$tableDeliverycode.id = $tableProduct.delivery_code");
        $this->join($tableStocklocationCategory,"$tableStocklocationCategory.location_id = $tableProduct.stock_location");
        $this->join($tableLeadtimeCategory,"$tableLeadtimeCategory.leadtime_id = $tableProduct.leadtime");
        $this->where('product_id', esc($productId));
        $this->select("$tableProduct.*, $tableManufacturer.maker_seq, $tableManufacturer.name, $tablePackagingUnit.packing_name, $tableDeliverycode.info as delivery_info, $tableDeliverycode.price as delivery_price, 
            $tableStocklocationCategory.location_id, $tableStocklocationCategory.location_info, $tableLeadtimeCategory.leadtime_id, $tableLeadtimeCategory.leadtime_info");
        return  $this->first();
    }

    /*
    public function findByProductCode($productCode){
        $tableProduct = ProductModel::getTableName();
        $tableManufacturer = ManufacturerModel::getTableName();
        $tablePackagingUnit = PackagingUnitModel::getTableName();
        $tableDeliverycode = DeliverycodeModel::getTableName();
        $tableStocklocationCategory = StocklocationCategoryModel::getTableName();
        $tableLeadtimeCategory = LeadtimeCategoryModel::getTableName();

        $this->join($tableManufacturer,"$tableManufacturer.maker_seq = $tableProduct.maker_seq");
        $this->join($tablePackagingUnit,"$tablePackagingUnit.packing_code = $tableProduct.packing_code");
        $this->join($tableDeliverycode,"$tableDeliverycode.id = $tableProduct.delivery_code");
        $this->join($tableStocklocationCategory,"$tableStocklocationCategory.location_id = $tableProduct.stock_location");
        $this->join($tableLeadtimeCategory,"$tableLeadtimeCategory.leadtime_id = $tableProduct.leadtime");
        $this->where('product_code', esc($productCode));
        $this->select("$tableProduct.*, $tableManufacturer.maker_seq, $tableManufacturer.name, $tablePackagingUnit.packing_name, $tableDeliverycode.info as delivery_info, $tableDeliverycode.price as delivery_price, 
            $tableStocklocationCategory.location_id, $tableStocklocationCategory.location_info, $tableLeadtimeCategory.leadtime_id, $tableLeadtimeCategory.leadtime_info");

        return  $this->first();
    }
    */

    public function findByProductCode($productCode){
        $tableProduct = ProductModel::getTableName();
        $tableManufacturer = ManufacturerModel::getTableName();
        $tableDeliverycode = DeliverycodeModel::getTableName();
        $tableStocklocationCategory = StocklocationCategoryModel::getTableName();
        $tableLeadtimeCategory = LeadtimeCategoryModel::getTableName();

        $this->join($tableManufacturer,"$tableManufacturer.maker_seq = $tableProduct.maker_seq");
        $this->join($tableDeliverycode,"$tableDeliverycode.id = $tableProduct.delivery_code");
        $this->join($tableStocklocationCategory,"$tableStocklocationCategory.location_id = $tableProduct.stock_location");
        $this->join($tableLeadtimeCategory,"$tableLeadtimeCategory.leadtime_id = $tableProduct.leadtime");
        $this->where('product_code', esc($productCode));
        $this->select("$tableProduct.*, $tableManufacturer.maker_seq, $tableManufacturer.name, $tableDeliverycode.info as delivery_info, $tableDeliverycode.price as delivery_price, 
            $tableStocklocationCategory.location_id, $tableStocklocationCategory.location_info, $tableLeadtimeCategory.leadtime_id, $tableLeadtimeCategory.leadtime_info");

        return  $this->first();
    }

    /**
     * @param string $partNumber
     * @return ProductModel|null
     */
    public function findByPartNumber($partNumber){
        $tableProduct = ProductModel::getTableName();
        $tableManufacturer = ManufacturerModel::getTableName();
        $tablePackagingUnit = PackagingUnitModel::getTableName();
        $tableDeliverycode = DeliverycodeModel::getTableName();
        $tableStocklocationCategory = StocklocationCategoryModel::getTableName();
        $tableLeadtimeCategory = LeadtimeCategoryModel::getTableName();

        $this->join($tableManufacturer,"$tableManufacturer.maker_seq = $tableProduct.maker_seq");
        $this->join($tablePackagingUnit,"$tablePackagingUnit.packing_code = $tableProduct.packing_code");
        $this->join($tableDeliverycode,"$tableDeliverycode.id = $tableProduct.delivery_code");
        $this->join($tableStocklocationCategory,"$tableStocklocationCategory.location_id = $tableProduct.stock_location");
        $this->join($tableLeadtimeCategory,"$tableLeadtimeCategory.leadtime_id = $tableProduct.leadtime");
        $this->where('part_number', esc($partNumber));
        $this->select("$tableProduct.*, $tableManufacturer.maker_seq, $tableManufacturer.name, $tablePackagingUnit.packing_name, $tableDeliverycode.info as delivery_info, $tableDeliverycode.price as delivery_price, 
            $tableStocklocationCategory.location_id, $tableStocklocationCategory.location_info, $tableLeadtimeCategory.leadtime_id, $tableLeadtimeCategory.leadtime_info");
        return  $this->first();
    }

    public function getByPartNumber($partNumber){
        if(!is_array($partNumber)) $partNumber = [$partNumber];
        $result = [];
        foreach (array_chunk($partNumber, 10000) as $partNumberIds){
            $resultProduct = $this->where('del_flg', DELETE_FLG_OFF)
                ->whereIn('part_number', $partNumberIds)->findAll();
            $result = array_merge($result, $resultProduct);
        }
        return $result;

    }

    public function getByProductNo($productIds){
        if(!is_array($productIds)) $productIds = [$productIds];
        $result = [];
        foreach (array_chunk($productIds, 10000) as $partProductIds){
            $resultProduct = $this->where('del_flg', DELETE_FLG_OFF)
                ->whereIn('product_id', $partProductIds)->findAll();
            $result = array_merge($result, $resultProduct);
        }
        return $result;

    }

    public function findInfo($productId){
        $tableProduct = ProductModel::getTableName();
        $tableManufacturer = ManufacturerModel::getTableName();
        $tablePackagingUnit = PackagingUnitModel::getTableName();
        $tableDeliverycode = DeliverycodeModel::getTableName();
        $tableStocklocationCategory = StocklocationCategoryModel::getTableName();
        $tableLeadtimeCategory = LeadtimeCategoryModel::getTableName();

        $this->join($tableManufacturer,"$tableManufacturer.maker_seq = $tableProduct.maker_seq");
        $this->join($tablePackagingUnit,"$tablePackagingUnit.packing_code = $tableProduct.packing_code");
        $this->join($tableDeliverycode,"$tableDeliverycode.id = $tableProduct.delivery_code");
        $this->join($tableStocklocationCategory,"$tableStocklocationCategory.location_id = $tableProduct.stock_location");
        $this->join($tableLeadtimeCategory,"$tableLeadtimeCategory.leadtime_id = $tableProduct.leadtime");
        $this->where("$tableProduct.del_flg", DELETE_FLG_OFF)->where("$tableProduct.product_id", $productId);
        $this->select("$tableProduct.*, $tableManufacturer.maker_seq, $tableManufacturer.name, $tablePackagingUnit.packing_name, $tableDeliverycode.info as delivery_info, $tableDeliverycode.price as delivery_price, 
            $tableStocklocationCategory.location_id, $tableStocklocationCategory.location_info, $tableLeadtimeCategory.leadtime_id, $tableLeadtimeCategory.leadtime_info");
        return  $this->first();
    }

    public function findByProductInfo($part_sequence){
        return $this->where('product_code', $part_sequence)->first();
    }


/******* Main Info Start *******************************************************************/

public function getRecommended($condition, $limit = 10 , $allData = false){

    $tableProduct = ProductModel::getTableName();
    $tableManufacturer = ManufacturerModel::getTableName();

    $queryBuilder = $this->where("$tableProduct.del_flg", DELETE_FLG_OFF);
    $queryBuilder = $this->where("$tableProduct.exposure", DELETE_FLG_OFF);

    $queryBuilder->like("$tableProduct.part_category2", trim($condition));

    $queryBuilder->select("$tableProduct.*");

    // $queryBuilder->orderBy("$tableProduct.created_at desc");
    $queryBuilder->orderBy("$tableProduct.qty_flag ASC");
    $queryBuilder->orderBy("$tableProduct.part_number ASC");

    if(!isset($limit)) $limit = 10;

    if($allData){
        $dataResult = $queryBuilder->findAll($limit);
        if(count($dataResult) > 0){
            $manufacturerModel = new ManufacturerModel();
            $listManufacturer = $manufacturerModel->findAll();
            if(count($listManufacturer) > 0){
                $mapManufacturer = ArrayHelper::parseListObjectToArrayKey($listManufacturer,'maker_seq');
                foreach ($dataResult as $product){
                    if(isset($mapManufacturer[$product->maker_seq])){
                        $manufacturer = $mapManufacturer[$product->maker_seq];
                        $product->maker_code = $manufacturer->maker_code;
                        $product->name = $manufacturer->name;
                    }
                }
            }

            $packagingUnitModel = new PackagingUnitModel();
            $listpackagingUnits = $packagingUnitModel->findAll();
            if(count($listpackagingUnits) > 0){
                $mapPackagingUnit = ArrayHelper::parseListObjectToArrayKey($listpackagingUnits,'packing_code');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapPackagingUnit[$product->packing_code])){
                        $packagingUnit = $mapPackagingUnit[$product->packing_code];
                        $product->packing_code = $packagingUnit->packing_code;
                        $product->packing_name = $packagingUnit->packing_name;
                    }
                }
            }

            $deliverycodeModel = new DeliverycodeModel();
            $listdeliverycodes = $deliverycodeModel->findAll();
            if(count($listdeliverycodes) > 0){
                $mapDeliverycode = ArrayHelper::parseListObjectToArrayKey($listdeliverycodes,'id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapDeliverycode[$product->delivery_code])){
                        $deliverycode = $mapDeliverycode[$product->delivery_code];
                        $product->delivery_code = $deliverycode->id;
                        $product->delivery_info = $deliverycode->info;
                        $product->delivery_price = $deliverycode->price;
                        
                    }
                }
            }

            $stocklocationCategoryModel = new StocklocationCategoryModel();
            $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
            if(count($liststocklocationCategorys) > 0){
                $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapStocklocationCategory[$product->stock_location])){
                        $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                        $product->stock_location = $stocklocationCategory->location_id;
                        $product->location_info = $stocklocationCategory->location_info;
                        
                    }
                }
            }

            $stocklocationCategoryModel = new StocklocationCategoryModel();
            $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
            if(count($liststocklocationCategorys) > 0){
                $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapStocklocationCategory[$product->stock_location])){
                        $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                        $product->stock_location = $stocklocationCategory->location_id;
                        $product->location_info = $stocklocationCategory->location_info;
                        
                    }
                }
            }

            $leadtimeCategoryModel = new LeadtimeCategoryModel();
            $listleadtimeCategorys = $leadtimeCategoryModel->findAll();
            if(count($listleadtimeCategorys) > 0){
                $mapLeadtimeCategory = ArrayHelper::parseListObjectToArrayKey($listleadtimeCategorys,'leadtime_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapLeadtimeCategory[$product->leadtime])){
                        $leadtimeCategory = $mapLeadtimeCategory[$product->leadtime];
                        $product->leadtime = $leadtimeCategory->leadtime_id;
                        $product->leadtime_info = $leadtimeCategory->leadtime_info;
                        
                    }
                }
            }                

        }
        return $dataResult;
    }

    $dataResult = $this->executePaginate($queryBuilder, $limit);

    if(count($dataResult['lists']) > 0){
        $manufacturerModel = new ManufacturerModel();
        $listManufacturer = $manufacturerModel->findAll();
        if(count($listManufacturer) > 0){
            $mapManufacturer = ArrayHelper::parseListObjectToArrayKey($listManufacturer,'maker_seq');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapManufacturer[$product->maker_seq])){
                    $manufacturer = $mapManufacturer[$product->maker_seq];
                    $product->maker_code = $manufacturer->maker_code;
                    $product->name = $manufacturer->name;

                }
            }
        }

        $packagingUnitModel = new PackagingUnitModel();
        $listpackagingUnits = $packagingUnitModel->findAll();
        if(count($listpackagingUnits) > 0){
            $mapPackagingUnit = ArrayHelper::parseListObjectToArrayKey($listpackagingUnits,'packing_code');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapPackagingUnit[$product->packing_code])){
                    $packagingUnit = $mapPackagingUnit[$product->packing_code];
                    $product->packing_code = $packagingUnit->packing_code;
                    $product->packing_name = $packagingUnit->packing_name;
                }
            }
        }

        $deliverycodeModel = new DeliverycodeModel();
        $listdeliverycodes = $deliverycodeModel->findAll();
        if(count($listdeliverycodes) > 0){
            $mapDeliverycode = ArrayHelper::parseListObjectToArrayKey($listdeliverycodes,'id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapDeliverycode[$product->delivery_code])){
                    $deliverycode = $mapDeliverycode[$product->delivery_code];
                    $product->delivery_code = $deliverycode->id;
                    $product->delivery_info = $deliverycode->info;
                    $product->delivery_price = $deliverycode->price;
                    
                }
            }
        }

        $stocklocationCategoryModel = new StocklocationCategoryModel();
        $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
        if(count($liststocklocationCategorys) > 0){
            $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapStocklocationCategory[$product->stock_location])){
                    $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                    $product->stock_location = $stocklocationCategory->location_id;
                    $product->location_info = $stocklocationCategory->location_info;
                    
                }
            }
        }         
                    
        $leadtimeCategoryModel = new LeadtimeCategoryModel();
        $listleadtimeCategorys = $leadtimeCategoryModel->findAll();
        if(count($listleadtimeCategorys) > 0){
            $mapLeadtimeCategory = ArrayHelper::parseListObjectToArrayKey($listleadtimeCategorys,'leadtime_id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapLeadtimeCategory[$product->leadtime])){
                    $leadtimeCategory = $mapLeadtimeCategory[$product->leadtime];
                    $product->leadtime = $leadtimeCategory->leadtime_id;
                    $product->leadtime_info = $leadtimeCategory->leadtime_info;
                    
                }
            }
        }   

    }

    return $dataResult;
}

/******* Main Info Stop ********************************************************************/


/******* Main Info Start *******************************************************************/

public function getBestproduct($condition, $limit = 10 , $allData = false){

    $tableProduct = ProductModel::getTableName();
    $tableManufacturer = ManufacturerModel::getTableName();

    $queryBuilder = $this->where("$tableProduct.del_flg", DELETE_FLG_OFF);
    $queryBuilder = $this->where("$tableProduct.exposure", DELETE_FLG_OFF);

    $queryBuilder->like("$tableProduct.part_category2", trim($condition));

    $queryBuilder->select("$tableProduct.*");

    // $queryBuilder->orderBy("$tableProduct.created_at desc");
    $queryBuilder->orderBy("$tableProduct.qty_flag ASC");
    $queryBuilder->orderBy("$tableProduct.part_number ASC");

    if(!isset($limit)) $limit = 10;

    if($allData){
        $dataResult = $queryBuilder->findAll($limit);
        if(count($dataResult) > 0){
            $manufacturerModel = new ManufacturerModel();
            $listManufacturer = $manufacturerModel->findAll();
            if(count($listManufacturer) > 0){
                $mapManufacturer = ArrayHelper::parseListObjectToArrayKey($listManufacturer,'maker_seq');
                foreach ($dataResult as $product){
                    if(isset($mapManufacturer[$product->maker_seq])){
                        $manufacturer = $mapManufacturer[$product->maker_seq];
                        $product->maker_code = $manufacturer->maker_code;
                        $product->name = $manufacturer->name;
                    }
                }
            }

            $packagingUnitModel = new PackagingUnitModel();
            $listpackagingUnits = $packagingUnitModel->findAll();
            if(count($listpackagingUnits) > 0){
                $mapPackagingUnit = ArrayHelper::parseListObjectToArrayKey($listpackagingUnits,'packing_code');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapPackagingUnit[$product->packing_code])){
                        $packagingUnit = $mapPackagingUnit[$product->packing_code];
                        $product->packing_code = $packagingUnit->packing_code;
                        $product->packing_name = $packagingUnit->packing_name;
                    }
                }
            }

            $deliverycodeModel = new DeliverycodeModel();
            $listdeliverycodes = $deliverycodeModel->findAll();
            if(count($listdeliverycodes) > 0){
                $mapDeliverycode = ArrayHelper::parseListObjectToArrayKey($listdeliverycodes,'id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapDeliverycode[$product->delivery_code])){
                        $deliverycode = $mapDeliverycode[$product->delivery_code];
                        $product->delivery_code = $deliverycode->id;
                        $product->delivery_info = $deliverycode->info;
                        $product->delivery_price = $deliverycode->price;
                        
                    }
                }
            }

            $stocklocationCategoryModel = new StocklocationCategoryModel();
            $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
            if(count($liststocklocationCategorys) > 0){
                $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapStocklocationCategory[$product->stock_location])){
                        $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                        $product->stock_location = $stocklocationCategory->location_id;
                        $product->location_info = $stocklocationCategory->location_info;
                        
                    }
                }
            }

            $stocklocationCategoryModel = new StocklocationCategoryModel();
            $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
            if(count($liststocklocationCategorys) > 0){
                $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapStocklocationCategory[$product->stock_location])){
                        $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                        $product->stock_location = $stocklocationCategory->location_id;
                        $product->location_info = $stocklocationCategory->location_info;
                        
                    }
                }
            }

            $leadtimeCategoryModel = new LeadtimeCategoryModel();
            $listleadtimeCategorys = $leadtimeCategoryModel->findAll();
            if(count($listleadtimeCategorys) > 0){
                $mapLeadtimeCategory = ArrayHelper::parseListObjectToArrayKey($listleadtimeCategorys,'leadtime_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapLeadtimeCategory[$product->leadtime])){
                        $leadtimeCategory = $mapLeadtimeCategory[$product->leadtime];
                        $product->leadtime = $leadtimeCategory->leadtime_id;
                        $product->leadtime_info = $leadtimeCategory->leadtime_info;
                        
                    }
                }
            }                

        }
        return $dataResult;
    }

    $dataResult = $this->executePaginate($queryBuilder, $limit);

    if(count($dataResult['lists']) > 0){
        $manufacturerModel = new ManufacturerModel();
        $listManufacturer = $manufacturerModel->findAll();
        if(count($listManufacturer) > 0){
            $mapManufacturer = ArrayHelper::parseListObjectToArrayKey($listManufacturer,'maker_seq');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapManufacturer[$product->maker_seq])){
                    $manufacturer = $mapManufacturer[$product->maker_seq];
                    $product->maker_code = $manufacturer->maker_code;
                    $product->name = $manufacturer->name;

                }
            }
        }

        $packagingUnitModel = new PackagingUnitModel();
        $listpackagingUnits = $packagingUnitModel->findAll();
        if(count($listpackagingUnits) > 0){
            $mapPackagingUnit = ArrayHelper::parseListObjectToArrayKey($listpackagingUnits,'packing_code');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapPackagingUnit[$product->packing_code])){
                    $packagingUnit = $mapPackagingUnit[$product->packing_code];
                    $product->packing_code = $packagingUnit->packing_code;
                    $product->packing_name = $packagingUnit->packing_name;
                }
            }
        }

        $deliverycodeModel = new DeliverycodeModel();
        $listdeliverycodes = $deliverycodeModel->findAll();
        if(count($listdeliverycodes) > 0){
            $mapDeliverycode = ArrayHelper::parseListObjectToArrayKey($listdeliverycodes,'id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapDeliverycode[$product->delivery_code])){
                    $deliverycode = $mapDeliverycode[$product->delivery_code];
                    $product->delivery_code = $deliverycode->id;
                    $product->delivery_info = $deliverycode->info;
                    $product->delivery_price = $deliverycode->price;
                    
                }
            }
        }

        $stocklocationCategoryModel = new StocklocationCategoryModel();
        $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
        if(count($liststocklocationCategorys) > 0){
            $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapStocklocationCategory[$product->stock_location])){
                    $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                    $product->stock_location = $stocklocationCategory->location_id;
                    $product->location_info = $stocklocationCategory->location_info;
                    
                }
            }
        }         
                    
        $leadtimeCategoryModel = new LeadtimeCategoryModel();
        $listleadtimeCategorys = $leadtimeCategoryModel->findAll();
        if(count($listleadtimeCategorys) > 0){
            $mapLeadtimeCategory = ArrayHelper::parseListObjectToArrayKey($listleadtimeCategorys,'leadtime_id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapLeadtimeCategory[$product->leadtime])){
                    $leadtimeCategory = $mapLeadtimeCategory[$product->leadtime];
                    $product->leadtime = $leadtimeCategory->leadtime_id;
                    $product->leadtime_info = $leadtimeCategory->leadtime_info;
                    
                }
            }
        }   

    }

    return $dataResult;
}

/******* Main Info Stop ********************************************************************/


/******* Main Info Start *******************************************************************/

public function getSelectproduct($condition, $limit, $allData = false){

    $tableProduct = ProductModel::getTableName();
    $tableManufacturer = ManufacturerModel::getTableName();

    $queryBuilder = $this->where("$tableProduct.del_flg", DELETE_FLG_OFF);
    $queryBuilder = $this->where("$tableProduct.exposure", DELETE_FLG_OFF);
    // $queryBuilder->like("$tableProduct.part_category2", trim($condition));

    if ($condition == "new") {
    $queryBuilder->like("$tableProduct.newproduct_chk", trim('1'));
    }

    $queryBuilder->select("$tableProduct.*");

    // $queryBuilder->orderBy("$tableProduct.created_at desc");
    $queryBuilder->orderBy("$tableProduct.qty_flag ASC");
    $queryBuilder->orderBy("$tableProduct.part_number ASC");

    if(!isset($limit)) $limit = 5;

    if($allData){
        $dataResult = $queryBuilder->findAll($limit);
        if(count($dataResult) > 0){
            $manufacturerModel = new ManufacturerModel();
            $listManufacturer = $manufacturerModel->findAll();
            if(count($listManufacturer) > 0){
                $mapManufacturer = ArrayHelper::parseListObjectToArrayKey($listManufacturer,'maker_seq');
                foreach ($dataResult as $product){
                    if(isset($mapManufacturer[$product->maker_seq])){
                        $manufacturer = $mapManufacturer[$product->maker_seq];
                        $product->maker_code = $manufacturer->maker_code;
                        $product->name = $manufacturer->name;
                    }
                }
            }

            $packagingUnitModel = new PackagingUnitModel();
            $listpackagingUnits = $packagingUnitModel->findAll();
            if(count($listpackagingUnits) > 0){
                $mapPackagingUnit = ArrayHelper::parseListObjectToArrayKey($listpackagingUnits,'packing_code');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapPackagingUnit[$product->packing_code])){
                        $packagingUnit = $mapPackagingUnit[$product->packing_code];
                        $product->packing_code = $packagingUnit->packing_code;
                        $product->packing_name = $packagingUnit->packing_name;
                    }
                }
            }
            
            $deliverycodeModel = new DeliverycodeModel();
            $listdeliverycodes = $deliverycodeModel->findAll();
            if(count($listdeliverycodes) > 0){
                $mapDeliverycode = ArrayHelper::parseListObjectToArrayKey($listdeliverycodes,'id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapDeliverycode[$product->delivery_code])){
                        $deliverycode = $mapDeliverycode[$product->delivery_code];
                        $product->delivery_code = $deliverycode->id;
                        $product->delivery_info = $deliverycode->info;
                        $product->delivery_price = $deliverycode->price;
                        
                    }
                }
            }

            $stocklocationCategoryModel = new StocklocationCategoryModel();
            $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
            if(count($liststocklocationCategorys) > 0){
                $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapStocklocationCategory[$product->stock_location])){
                        $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                        $product->stock_location = $stocklocationCategory->location_id;
                        $product->location_info = $stocklocationCategory->location_info;
                        
                    }
                }
            }

            $stocklocationCategoryModel = new StocklocationCategoryModel();
            $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
            if(count($liststocklocationCategorys) > 0){
                $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapStocklocationCategory[$product->stock_location])){
                        $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                        $product->stock_location = $stocklocationCategory->location_id;
                        $product->location_info = $stocklocationCategory->location_info;
                        
                    }
                }
            }

            $leadtimeCategoryModel = new LeadtimeCategoryModel();
            $listleadtimeCategorys = $leadtimeCategoryModel->findAll();
            if(count($listleadtimeCategorys) > 0){
                $mapLeadtimeCategory = ArrayHelper::parseListObjectToArrayKey($listleadtimeCategorys,'leadtime_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapLeadtimeCategory[$product->leadtime])){
                        $leadtimeCategory = $mapLeadtimeCategory[$product->leadtime];
                        $product->leadtime = $leadtimeCategory->leadtime_id;
                        $product->leadtime_info = $leadtimeCategory->leadtime_info;
                        
                    }
                }
            }                

        }
        return $dataResult;
    }

    $dataResult = $this->executePaginate($queryBuilder, $limit);

    if(count($dataResult['lists']) > 0){
        $manufacturerModel = new ManufacturerModel();
        $listManufacturer = $manufacturerModel->findAll();
        if(count($listManufacturer) > 0){
            $mapManufacturer = ArrayHelper::parseListObjectToArrayKey($listManufacturer,'maker_seq');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapManufacturer[$product->maker_seq])){
                    $manufacturer = $mapManufacturer[$product->maker_seq];
                    $product->maker_code = $manufacturer->maker_code;
                    $product->name = $manufacturer->name;

                }
            }
        }

        $packagingUnitModel = new PackagingUnitModel();
        $listpackagingUnits = $packagingUnitModel->findAll();
        if(count($listpackagingUnits) > 0){
            $mapPackagingUnit = ArrayHelper::parseListObjectToArrayKey($listpackagingUnits,'packing_code');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapPackagingUnit[$product->packing_code])){
                    $packagingUnit = $mapPackagingUnit[$product->packing_code];
                    $product->packing_code = $packagingUnit->packing_code;
                    $product->packing_name = $packagingUnit->packing_name;
                }
            }
        }

        $deliverycodeModel = new DeliverycodeModel();
        $listdeliverycodes = $deliverycodeModel->findAll();
        if(count($listdeliverycodes) > 0){
            $mapDeliverycode = ArrayHelper::parseListObjectToArrayKey($listdeliverycodes,'id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapDeliverycode[$product->delivery_code])){
                    $deliverycode = $mapDeliverycode[$product->delivery_code];
                    $product->delivery_code = $deliverycode->id;
                    $product->delivery_info = $deliverycode->info;
                    $product->delivery_price = $deliverycode->price;
                    
                }
            }
        }

        $stocklocationCategoryModel = new StocklocationCategoryModel();
        $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
        if(count($liststocklocationCategorys) > 0){
            $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapStocklocationCategory[$product->stock_location])){
                    $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                    $product->stock_location = $stocklocationCategory->location_id;
                    $product->location_info = $stocklocationCategory->location_info;
                    
                }
            }
        }         
                    
        $leadtimeCategoryModel = new LeadtimeCategoryModel();
        $listleadtimeCategorys = $leadtimeCategoryModel->findAll();
        if(count($listleadtimeCategorys) > 0){
            $mapLeadtimeCategory = ArrayHelper::parseListObjectToArrayKey($listleadtimeCategorys,'leadtime_id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapLeadtimeCategory[$product->leadtime])){
                    $leadtimeCategory = $mapLeadtimeCategory[$product->leadtime];
                    $product->leadtime = $leadtimeCategory->leadtime_id;
                    $product->leadtime_info = $leadtimeCategory->leadtime_info;
                    
                }
            }
        }   

    }

    return $dataResult;
}

/******* Main Info Stop ********************************************************************/

// SELECT * FROM "TABLE NAME" ORDER BY "COLUMN NAME" DESC LIMIT 1
public function getLastproduct(){
    $tableProduct = ProductModel::getTableName();
    $queryBuilder = $this->select("$tableProduct.product_code");
    $queryBuilder->orderBy("$tableProduct.product_id DESC");
    return $this->executePaginate($queryBuilder, 1);
}

/******* Main Info Start *******************************************************************/

public function getBrandproduct($condition, $limit, $allData = false){

    $tableProduct = ProductModel::getTableName();
    $tableManufacturer = ManufacturerModel::getTableName();

    $queryBuilder = $this->where("$tableProduct.del_flg", DELETE_FLG_OFF);
    $queryBuilder = $this->where("$tableProduct.exposure", DELETE_FLG_OFF);

    $queryBuilder->where("$tableProduct.maker_seq", trim($condition));

    $queryBuilder->select("$tableProduct.*");

    //$queryBuilder->orderBy("$tableProduct.created_at desc");
    $queryBuilder->orderBy("$tableProduct.qty_flag ASC");
    $queryBuilder->orderBy("$tableProduct.part_number ASC");

    if(!isset($limit)) $limit = 3;

    if($allData){
        $dataResult = $queryBuilder->findAll($limit);
        if(count($dataResult) > 0){
            $manufacturerModel = new ManufacturerModel();
            $listManufacturer = $manufacturerModel->findAll();
            if(count($listManufacturer) > 0){
                $mapManufacturer = ArrayHelper::parseListObjectToArrayKey($listManufacturer,'maker_seq');
                foreach ($dataResult as $product){
                    if(isset($mapManufacturer[$product->maker_seq])){
                        $manufacturer = $mapManufacturer[$product->maker_seq];
                        $product->maker_code = $manufacturer->maker_code;
                        $product->name = $manufacturer->name;
                    }
                }
            }

            $packagingUnitModel = new PackagingUnitModel();
            $listpackagingUnits = $packagingUnitModel->findAll();
            if(count($listpackagingUnits) > 0){
                $mapPackagingUnit = ArrayHelper::parseListObjectToArrayKey($listpackagingUnits,'packing_code');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapPackagingUnit[$product->packing_code])){
                        $packagingUnit = $mapPackagingUnit[$product->packing_code];
                        $product->packing_code = $packagingUnit->packing_code;
                        $product->packing_name = $packagingUnit->packing_name;
                    }
                }
            }
            
            $deliverycodeModel = new DeliverycodeModel();
            $listdeliverycodes = $deliverycodeModel->findAll();
            if(count($listdeliverycodes) > 0){
                $mapDeliverycode = ArrayHelper::parseListObjectToArrayKey($listdeliverycodes,'id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapDeliverycode[$product->delivery_code])){
                        $deliverycode = $mapDeliverycode[$product->delivery_code];
                        $product->delivery_code = $deliverycode->id;
                        $product->delivery_info = $deliverycode->info;
                        $product->delivery_price = $deliverycode->price;
                        
                    }
                }
            }

            $stocklocationCategoryModel = new StocklocationCategoryModel();
            $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
            if(count($liststocklocationCategorys) > 0){
                $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapStocklocationCategory[$product->stock_location])){
                        $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                        $product->stock_location = $stocklocationCategory->location_id;
                        $product->location_info = $stocklocationCategory->location_info;
                        
                    }
                }
            }

            $stocklocationCategoryModel = new StocklocationCategoryModel();
            $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
            if(count($liststocklocationCategorys) > 0){
                $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapStocklocationCategory[$product->stock_location])){
                        $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                        $product->stock_location = $stocklocationCategory->location_id;
                        $product->location_info = $stocklocationCategory->location_info;
                        
                    }
                }
            }

            $leadtimeCategoryModel = new LeadtimeCategoryModel();
            $listleadtimeCategorys = $leadtimeCategoryModel->findAll();
            if(count($listleadtimeCategorys) > 0){
                $mapLeadtimeCategory = ArrayHelper::parseListObjectToArrayKey($listleadtimeCategorys,'leadtime_id');
                foreach ($dataResult['lists'] as $product){
                    if(isset($mapLeadtimeCategory[$product->leadtime])){
                        $leadtimeCategory = $mapLeadtimeCategory[$product->leadtime];
                        $product->leadtime = $leadtimeCategory->leadtime_id;
                        $product->leadtime_info = $leadtimeCategory->leadtime_info;
                        
                    }
                }
            }                

        }
        return $dataResult;
    }

    $dataResult = $this->executePaginate($queryBuilder, $limit);

    if(count($dataResult['lists']) > 0){
        $manufacturerModel = new ManufacturerModel();
        $listManufacturer = $manufacturerModel->findAll();
        if(count($listManufacturer) > 0){
            $mapManufacturer = ArrayHelper::parseListObjectToArrayKey($listManufacturer,'maker_seq');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapManufacturer[$product->maker_seq])){
                    $manufacturer = $mapManufacturer[$product->maker_seq];
                    $product->maker_code = $manufacturer->maker_code;
                    $product->name = $manufacturer->name;

                }
            }
        }
        
        $packagingUnitModel = new PackagingUnitModel();
        $listpackagingUnits = $packagingUnitModel->findAll();
        if(count($listpackagingUnits) > 0){
            $mapPackagingUnit = ArrayHelper::parseListObjectToArrayKey($listpackagingUnits,'packing_code');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapPackagingUnit[$product->packing_code])){
                    $packagingUnit = $mapPackagingUnit[$product->packing_code];
                    $product->packing_code = $packagingUnit->packing_code;
                    $product->packing_name = $packagingUnit->packing_name;
                }
            }
        }

        $deliverycodeModel = new DeliverycodeModel();
        $listdeliverycodes = $deliverycodeModel->findAll();
        if(count($listdeliverycodes) > 0){
            $mapDeliverycode = ArrayHelper::parseListObjectToArrayKey($listdeliverycodes,'id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapDeliverycode[$product->delivery_code])){
                    $deliverycode = $mapDeliverycode[$product->delivery_code];
                    $product->delivery_code = $deliverycode->id;
                    $product->delivery_info = $deliverycode->info;
                    $product->delivery_price = $deliverycode->price;
                    
                }
            }
        }

        $stocklocationCategoryModel = new StocklocationCategoryModel();
        $liststocklocationCategorys = $stocklocationCategoryModel->findAll();
        if(count($liststocklocationCategorys) > 0){
            $mapStocklocationCategory = ArrayHelper::parseListObjectToArrayKey($liststocklocationCategorys,'location_id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapStocklocationCategory[$product->stock_location])){
                    $stocklocationCategory = $mapStocklocationCategory[$product->stock_location];
                    $product->stock_location = $stocklocationCategory->location_id;
                    $product->location_info = $stocklocationCategory->location_info;
                    
                }
            }
        }         
                    
        $leadtimeCategoryModel = new LeadtimeCategoryModel();
        $listleadtimeCategorys = $leadtimeCategoryModel->findAll();
        if(count($listleadtimeCategorys) > 0){
            $mapLeadtimeCategory = ArrayHelper::parseListObjectToArrayKey($listleadtimeCategorys,'leadtime_id');
            foreach ($dataResult['lists'] as $product){
                if(isset($mapLeadtimeCategory[$product->leadtime])){
                    $leadtimeCategory = $mapLeadtimeCategory[$product->leadtime];
                    $product->leadtime = $leadtimeCategory->leadtime_id;
                    $product->leadtime_info = $leadtimeCategory->leadtime_info;
                    
                }
            }
        }   

    }

    return $dataResult;
}

public function updateProductQty($product_code, $adjusted_qty){
    $queryBuilder = $this->set('qty', $adjusted_qty);
    $queryBuilder = $this->where('product_code', $product_code);
    $queryBuilder = $this->update();
 }

/******* Main Info Stop ********************************************************************/

/******************************************************************************************/


public function getApiId($api_code){
    $queryBuilder = $this->where("del_flg", DELETE_FLG_OFF);
    $queryBuilder = $this->like('api_code', $api_code);
    $queryBuilder = $this->select("product_api_id");
    $queryBuilder = $this->findAll();
    
    return $queryBuilder;
}

public function findByProductSeq($product_api_id){
    $tableProduct = ProductModel::getTableName();
    return $this->where('product_api_id', esc($product_api_id))->select("$tableProduct.product_id")->first();
}

public function updateLcscAipup($product_api_id, $upqty, $prices_array, $exchange_rat){

    $queryBuilder = $this->set('qty', $upqty);

    $selling_price1 = ($prices_array[0]["price"]*1.15)*$exchange_rat;
    $queryBuilder = $this->set('selling_price1', $selling_price1);
    $queryBuilder = $this->set('prices_price1', $prices_array[0]["price"]);
    $queryBuilder = $this->set('prices_currency1', $prices_array[0]["currency"]);
    $queryBuilder = $this->set('unit_mini_quantity1', $prices_array[0]["min_qty"]);
    $queryBuilder = $this->set('unit_max_quantity1', $prices_array[0]["max_qty"]);
    
    $selling_price2 = ($prices_array[1]["price"]*1.15)*$exchange_rat;
    $queryBuilder = $this->set('selling_price2', $selling_price2);
    $queryBuilder = $this->set('prices_price2', $prices_array[1]["price"]);
    $queryBuilder = $this->set('prices_currency2', $prices_array[1]["currency"]);
    $queryBuilder = $this->set('unit_mini_quantity2', $prices_array[1]["min_qty"]);
    $queryBuilder = $this->set('unit_max_quantity2', $prices_array[1]["max_qty"]);

    $selling_price3 = ($prices_array[2]["price"]*1.15)*$exchange_rat;
    $queryBuilder = $this->set('selling_price3', $selling_price3);
    $queryBuilder = $this->set('prices_price3', $prices_array[2]["price"]);
    $queryBuilder = $this->set('prices_currency3', $prices_array[2]["currency"]);
    $queryBuilder = $this->set('unit_mini_quantity3', $prices_array[2]["min_qty"]);
    $queryBuilder = $this->set('unit_max_quantity3', $prices_array[2]["max_qty"]);
    
    $selling_price4 = ($prices_array[3]["price"]*1.15)*$exchange_rat;
    $queryBuilder = $this->set('selling_price4', $selling_price4);
    $queryBuilder = $this->set('prices_price4', $prices_array[3]["price"]);
    $queryBuilder = $this->set('prices_currency4', $prices_array[3]["currency"]);
    $queryBuilder = $this->set('unit_mini_quantity4', $prices_array[3]["min_qty"]);
    $queryBuilder = $this->set('unit_max_quantity4', $prices_array[3]["max_qty"]);
    
    $selling_price5 = ($prices_array[4]["price"]*1.15)*$exchange_rat;
    $queryBuilder = $this->set('selling_price5', $selling_price5);
    $queryBuilder = $this->set('prices_price5', $prices_array[4]["price"]);
    $queryBuilder = $this->set('prices_currency5', $prices_array[4]["currency"]);
    $queryBuilder = $this->set('unit_mini_quantity5', $prices_array[4]["min_qty"]);
    $queryBuilder = $this->set('unit_max_quantity5', $prices_array[4]["max_qty"]);

    $selling_price6 = ($prices_array[5]["price"]*1.15)*$exchange_rat;
    $queryBuilder = $this->set('selling_price6', $selling_price6);
    $queryBuilder = $this->set('prices_price6', $prices_array[5]["price"]);
    $queryBuilder = $this->set('prices_currency6', $prices_array[5]["currency"]);
    $queryBuilder = $this->set('unit_mini_quantity6', $prices_array[5]["min_qty"]);
    $queryBuilder = $this->set('unit_max_quantity6', $prices_array[5]["max_qty"]);

    $queryBuilder = $this->set('api_updated_at', date('Y-m-d H:i:s'));

    $queryBuilder = $this->where('api_code', "LC");
    $queryBuilder = $this->where('product_api_id', $product_api_id);
    $queryBuilder = $this->update();
 }

public function updateLcscSpwup($product_code, $productitem, $exchange_rat){

    $queryBuilder = $this->set('part_category', $productitem ["category"]["id1"]);
    $queryBuilder = $this->set('part_category2', $productitem ["category"]["id2"]);
    // $queryBuilder = $this->set('maker_seq', $productitem ["manufacturer"]["id"]);
    $queryBuilder = $this->set('qty', $productitem ["quantity"]);
    $queryBuilder = $this->set('moq', $productitem ["moq"]);
    $queryBuilder = $this->set('mpq', $productitem ["moq"]);
    // $queryBuilder = $this->set('packing_code', $productitem ["packaging_code"]);
    $queryBuilder = $this->set('packing_name', $productitem ["packaging_unit"]);

    $selling_price1 = ($productitem ["prices"][0]["price"]*1.15)*$exchange_rat;
    $queryBuilder = $this->set('selling_price1', $selling_price1);
    $queryBuilder = $this->set('prices_price1', $productitem ["prices"][0]["price"]);
    $queryBuilder = $this->set('prices_currency1', $productitem ["prices"][0]["currency"]);
    $queryBuilder = $this->set('unit_mini_quantity1', $productitem ["prices"][0]["min_qty"]);
    $queryBuilder = $this->set('unit_max_quantity1', $productitem ["prices"][0]["max_qty"]);

    $selling_price2 = ($productitem ["prices"][1]["price"]*1.15)*$exchange_rat;
    $queryBuilder = $this->set('selling_price2', $selling_price2);
    $queryBuilder = $this->set('prices_price2', $productitem ["prices"][1]["price"]);
    $queryBuilder = $this->set('prices_currency2', $productitem ["prices"][1]["currency"]);
    $queryBuilder = $this->set('unit_mini_quantity2', $productitem ["prices"][1]["min_qty"]);
    $queryBuilder = $this->set('unit_max_quantity2', $productitem ["prices"][1]["max_qty"]);
        
    $selling_price3 = ($productitem ["prices"][2]["price"]*1.15)*$exchange_rat;
    $queryBuilder = $this->set('selling_price3', $selling_price3);
    $queryBuilder = $this->set('prices_price3', $productitem ["prices"][2]["price"]);
    $queryBuilder = $this->set('prices_currency3', $productitem ["prices"][2]["currency"]);
    $queryBuilder = $this->set('unit_mini_quantity3', $productitem ["prices"][2]["min_qty"]);
    $queryBuilder = $this->set('unit_max_quantity3', $productitem ["prices"][2]["max_qty"]);

    $selling_price4 = ($productitem ["prices"][3]["price"]*1.15)*$exchange_rat;
    $queryBuilder = $this->set('selling_price4', $selling_price4);
    $queryBuilder = $this->set('prices_price4', $productitem ["prices"][3]["price"]);
    $queryBuilder = $this->set('prices_currency4', $productitem ["prices"][3]["currency"]);
    $queryBuilder = $this->set('unit_mini_quantity4', $productitem ["prices"][3]["min_qty"]);
    $queryBuilder = $this->set('unit_max_quantity4', $productitem ["prices"][3]["max_qty"]);

    $selling_price5 = ($productitem ["prices"][4]["price"]*1.15)*$exchange_rat;
    $queryBuilder = $this->set('selling_price5', $selling_price5);
    $queryBuilder = $this->set('prices_price5', $productitem ["prices"][4]["price"]);
    $queryBuilder = $this->set('prices_currency5', $productitem ["prices"][4]["currency"]);
    $queryBuilder = $this->set('unit_mini_quantity5', $productitem ["prices"][4]["min_qty"]);
    $queryBuilder = $this->set('unit_max_quantity5', $productitem ["prices"][4]["max_qty"]);

    $selling_price6 = ($productitem ["prices"][5]["price"]*1.15)*$exchange_rat;
    $queryBuilder = $this->set('selling_price6', $selling_price6);
    $queryBuilder = $this->set('prices_price6', $productitem ["prices"][5]["price"]);
    $queryBuilder = $this->set('prices_currency6', $productitem ["prices"][5]["currency"]);
    $queryBuilder = $this->set('unit_mini_quantity6', $productitem ["prices"][5]["min_qty"]);
    $queryBuilder = $this->set('unit_max_quantity6', $productitem ["prices"][5]["max_qty"]);
    
    $queryBuilder = $this->set('api_code', "LC");
    $queryBuilder = $this->set('product_api_id', $productitem ["number"]);
    $queryBuilder = $this->set('api_updated_at', date('Y-m-d H:i:s'));
    $queryBuilder = $this->where('product_code', $product_code);
    $queryBuilder = $this->update();

 }


    public function updateIckSpwup($product_code, $productitem, $exchange_rat){

        $queryBuilder = $this->set('qty', $productitem["stock"]);
        $queryBuilder = $this->set('moq', $productitem["moq"]);
        $queryBuilder = $this->set('mpq', $productitem["moq"]);
        // $queryBuilder = $this->set('packing_code', $productitem ["packaging_code"]);
        $queryBuilder = $this->set('packing_name', $productitem["package"]);
        $queryBuilder = $this->set('brief_description', $productitem["pro_desc"]);
        $queryBuilder = $this->set('date_code', $productitem["date_code"]);
        $queryBuilder = $this->set('image_dir', $productitem["img_url"]);

        $selling_price1 = ($productitem["rmb"][0]*1.15)*$exchange_rat;
        $queryBuilder = $this->set('selling_price1', $selling_price1);
        $queryBuilder = $this->set('prices_price1', $productitem["rmb"][0]);
        $queryBuilder = $this->set('unit_mini_quantity1', $productitem["nums"][0]);

        $selling_price2 = ($productitem["rmb"][1]*1.15)*$exchange_rat;
        $queryBuilder = $this->set('selling_price2', $selling_price2);
        $queryBuilder = $this->set('prices_price2', $productitem["rmb"][1]);
        $queryBuilder = $this->set('unit_mini_quantity2', $productitem["nums"][1]);

        $selling_price3 = ($productitem["rmb"][2]*1.15)*$exchange_rat;
        $queryBuilder = $this->set('selling_price3', $selling_price3);
        $queryBuilder = $this->set('prices_price3', $productitem["rmb"][2]);
        $queryBuilder = $this->set('unit_mini_quantity3', $productitem["nums"][2]);

        $selling_price4 = ($productitem["rmb"][3]*1.15)*$exchange_rat;
        $queryBuilder = $this->set('selling_price4', $selling_price4);
        $queryBuilder = $this->set('prices_price4', $productitem["rmb"][3]);
        $queryBuilder = $this->set('unit_mini_quantity4', $productitem["nums"][3]);

        $selling_price5 = ($productitem["rmb"][4]*1.15)*$exchange_rat;
        $queryBuilder = $this->set('selling_price5', $selling_price5);
        $queryBuilder = $this->set('prices_price5', $productitem["rmb"][4]);
        $queryBuilder = $this->set('unit_mini_quantity5', $productitem["nums"][4]);

        $selling_price6 = ($productitem["rmb"][5]*1.15)*$exchange_rat;
        $queryBuilder = $this->set('selling_price6', $selling_price6);
        $queryBuilder = $this->set('prices_price6', $productitem["rmb"][5]);
        $queryBuilder = $this->set('unit_mini_quantity6', $productitem["nums"][5]);

        $queryBuilder = $this->set('api_updated_at', date('Y-m-d H:i:s'));

        $queryBuilder = $this->where('api_code', "ICK");
        $queryBuilder = $this->set('product_api_id', $productitem["sku"]);
        $queryBuilder = $this->set('api_updated_at', date('Y-m-d H:i:s'));
        $queryBuilder = $this->where('product_code', $product_code);
        $queryBuilder = $this->update();

    }

 /*
 public function updateRsStock($product_api_id, $apistock){
    $queryBuilder = $this->set('qty', $apistock);
    $queryBuilder = $this->where('api_code', "RS");
    $queryBuilder = $this->where('product_api_id', $product_api_id);
    $queryBuilder = $this->update();
 }

 public function updateRsPrice($product_api_id, $apiprice){
    $queryBuilder = $this->set('unit_mini_quantity1', $apiprice['unit_mini_quantity1']);
    $queryBuilder = $this->set('unit_max_quantity1', $apiprice['unit_max_quantity1']);
    $queryBuilder = $this->set('selling_price1', $apiprice['selling_price1']);
    $queryBuilder = $this->set('unit_mini_quantity2', $apiprice['unit_mini_quantity2']);
    $queryBuilder = $this->set('unit_max_quantity2', $apiprice['unit_max_quantity2']);
    $queryBuilder = $this->set('selling_price2', $apiprice['selling_price2']);
    $queryBuilder = $this->set('unit_mini_quantity3', $apiprice['unit_mini_quantity3']);
    $queryBuilder = $this->set('qtyunit_max_quantity3', $apiprice['unit_max_quantity3']);
    $queryBuilder = $this->set('selling_price3', $apiprice['selling_price3']);
    $queryBuilder = $this->set('unit_mini_quantity4', $apiprice['unit_mini_quantity4']);
    $queryBuilder = $this->set('unit_max_quantity4', $apiprice['unit_max_quantity4']);
    $queryBuilder = $this->set('selling_price4', $apiprice['selling_price4']);
    $queryBuilder = $this->set('unit_mini_quantity5', $apiprice['unit_mini_quantity5']);
    $queryBuilder = $this->set('unit_max_quantity5', $apiprice['unit_max_quantity5']);
    $queryBuilder = $this->set('selling_price5', $apiprice['selling_price5']);
    $queryBuilder = $this->set('unit_mini_quantity6', $apiprice['unit_mini_quantity6']);
    $queryBuilder = $this->set('unit_max_quantity6', $apiprice['unit_max_quantity6']);
    $queryBuilder = $this->set('selling_price6', $apiprice['selling_price6']);
    $queryBuilder = $this->where('api_code', "RS");
    $queryBuilder = $this->where('product_api_id', $product_api_id);
    $queryBuilder = $this->update();
 }
*/

    public function updateIckAipup($sku, $results, $exchange_rat){

        $queryBuilder = $this->set('qty', $results[$sku]["stock"]);

        $selling_price1 = ($results[$sku]["rmb"][0]*1.15)*$exchange_rat;
        $queryBuilder = $this->set('selling_price1', $selling_price1);
        $queryBuilder = $this->set('prices_price1', $results[$sku]["rmb"][0]);
        $queryBuilder = $this->set('unit_mini_quantity1', $results[$sku]["nums"][0]);

        $selling_price2 = ($results[$sku]["rmb"][1]*1.15)*$exchange_rat;
        $queryBuilder = $this->set('selling_price2', $selling_price2);
        $queryBuilder = $this->set('prices_price2', $results[$sku]["rmb"][1]);
        $queryBuilder = $this->set('unit_mini_quantity2', $results[$sku]["nums"][1]);

        $selling_price3 = ($results[$sku]["rmb"][2]*1.15)*$exchange_rat;
        $queryBuilder = $this->set('selling_price3', $selling_price3);
        $queryBuilder = $this->set('prices_price3', $results[$sku]["rmb"][2]);
        $queryBuilder = $this->set('unit_mini_quantity3', $results[$sku]["nums"][2]);

        $selling_price4 = ($results[$sku]["rmb"][3]*1.15)*$exchange_rat;
        $queryBuilder = $this->set('selling_price4', $selling_price4);
        $queryBuilder = $this->set('prices_price4', $results[$sku]["rmb"][3]);
        $queryBuilder = $this->set('unit_mini_quantity4', $results[$sku]["nums"][3]);

        
        $selling_price5 = ($results[$sku]["rmb"][4]*1.15)*$exchange_rat;
        $queryBuilder = $this->set('selling_price5', $selling_price5);
        $queryBuilder = $this->set('prices_price5', $results[$sku]["rmb"][4]);
        $queryBuilder = $this->set('unit_mini_quantity5', $results[$sku]["nums"][4]);

        $selling_price6 = ($results[$sku]["rmb"][5]*1.15)*$exchange_rat;
        $queryBuilder = $this->set('selling_price6', $selling_price6);
        $queryBuilder = $this->set('prices_price6', $results[$sku]["rmb"][5]);
        $queryBuilder = $this->set('unit_mini_quantity6', $results[$sku]["nums"][5]);

        $queryBuilder = $this->set('api_updated_at', date('Y-m-d H:i:s'));

        $queryBuilder = $this->where('api_code', "ICK");
        $queryBuilder = $this->where('product_api_id', $sku);
        $queryBuilder = $this->update();

    }

    /******************************************************************************************/

    public function insertShowwindow($id, $showwindow_mode){

        if ($showwindow_mode == "new") {
            $insertSql = 'INSERT INTO showwindow (
            `product_code`,`part_category`,`part_category2`,`part_category3`,`maker_seq`,`location_code`,`display_set`,`newproduct_chk`,`bestproduct_chk`,`recomproduct_chk`,`brandproduct_chk`,`event_set`,`part_number`,`brief_description`,`situation`,`exposure`,`product_related`,`date_code`,`image_dir`,
            `api_flg`,`api_code`,`tariff_rate`,`product_api_id`,`qty`,`packing_code`,`price`,`leadtime`,`moq`,`mpq`,`stock_location`,`taxable`,`selling_price1`,`margin_rate1`,`unit_mini_quantity1`,`unit_max_quantity1`,`created_at`,`updated_at`) SELECT `product_code`,`part_category`,`part_category2`,
            `part_category3`,`maker_seq`,`location_code`,`display_set`,1,`bestproduct_chk`,`recomproduct_chk`,`brandproduct_chk`,`event_set`,`part_number`,`brief_description`,`situation`,`exposure`,`product_related`,`date_code`,`image_dir`,`api_flg`,`api_code`,`tariff_rate`,`product_api_id`,
            `qty`,`packing_code`,`price`,`leadtime`,`moq`,`mpq`,`stock_location`,`taxable`,`selling_price1`,`margin_rate1`,`unit_mini_quantity1`,`unit_max_quantity1`, NOW(), NOW() FROM `products` WHERE `product_id`='.$id;

        } elseif ($showwindow_mode == "best") {
            $insertSql = 'INSERT INTO showwindow (
            `product_code`,`part_category`,`part_category2`,`part_category3`,`maker_seq`,`location_code`,`display_set`,`newproduct_chk`,`bestproduct_chk`,`recomproduct_chk`,`brandproduct_chk`,`event_set`,`part_number`,`brief_description`,`situation`,`exposure`,`product_related`,`date_code`,`image_dir`,
            `api_flg`,`api_code`,`tariff_rate`,`product_api_id`,`qty`,`packing_code`,`price`,`leadtime`,`moq`,`mpq`,`stock_location`,`taxable`,`selling_price1`,`margin_rate1`,`unit_mini_quantity1`,`unit_max_quantity1`,`created_at`,`updated_at`) SELECT `product_code`,`part_category`,`part_category2`,
            `part_category3`,`maker_seq`,`location_code`,`display_set`,`newproduct_chk`,1,`recomproduct_chk`,`brandproduct_chk`,`event_set`,`part_number`,`brief_description`,`situation`,`exposure`,`product_related`,`date_code`,`image_dir`,`api_flg`,`api_code`,`tariff_rate`,`product_api_id`,
            `qty`,`packing_code`,`price`,`leadtime`,`moq`,`mpq`,`stock_location`,`taxable`,`selling_price1`,`margin_rate1`,`unit_mini_quantity1`,`unit_max_quantity1`, NOW(), NOW() FROM `products` WHERE `product_id`='.$id;

        } elseif ($showwindow_mode == "recom") {
            $insertSql = 'INSERT INTO showwindow (
            `product_code`,`part_category`,`part_category2`,`part_category3`,`maker_seq`,`location_code`,`display_set`,`newproduct_chk`,`bestproduct_chk`,`recomproduct_chk`,`brandproduct_chk`,`event_set`,`part_number`,`brief_description`,`situation`,`exposure`,`product_related`,`date_code`,`image_dir`,
            `api_flg`,`api_code`,`tariff_rate`,`product_api_id`,`qty`,`packing_code`,`price`,`leadtime`,`moq`,`mpq`,`stock_location`,`taxable`,`selling_price1`,`margin_rate1`,`unit_mini_quantity1`,`unit_max_quantity1`,`created_at`,`updated_at`) SELECT `product_code`,`part_category`,`part_category2`,
            `part_category3`,`maker_seq`,`location_code`,`display_set`,`newproduct_chk`,`bestproduct_chk`,1,`brandproduct_chk`,`event_set`,`part_number`,`brief_description`,`situation`,`exposure`,`product_related`,`date_code`,`image_dir`,`api_flg`,`api_code`,`tariff_rate`,`product_api_id`,
            `qty`,`packing_code`,`price`,`leadtime`,`moq`,`mpq`,`stock_location`,`taxable`,`selling_price1`,`margin_rate1`,`unit_mini_quantity1`,`unit_max_quantity1`, NOW(), NOW() FROM `products` WHERE `product_id`='.$id;

        } elseif ($showwindow_mode == "brand") {
            $insertSql = 'INSERT INTO showwindow (
            `product_code`,`part_category`,`part_category2`,`part_category3`,`maker_seq`,`location_code`,`display_set`,`newproduct_chk`,`bestproduct_chk`,`recomproduct_chk`,`brandproduct_chk`,`event_set`,`part_number`,`brief_description`,`situation`,`exposure`,`product_related`,`date_code`,`image_dir`,
            `api_flg`,`api_code`,`tariff_rate`,`product_api_id`,`qty`,`packing_code`,`price`,`leadtime`,`moq`,`mpq`,`stock_location`,`taxable`,`selling_price1`,`margin_rate1`,`unit_mini_quantity1`,`unit_max_quantity1`,`created_at`,`updated_at`) SELECT `product_code`,`part_category`,`part_category2`,
            `part_category3`,`maker_seq`,`location_code`,`display_set`,`newproduct_chk`,`bestproduct_chk`,`recomproduct_chk`,1,`event_set`,`part_number`,`brief_description`,`situation`,`exposure`,`product_related`,`date_code`,`image_dir`,`api_flg`,`api_code`,`tariff_rate`,`product_api_id`,
            `qty`,`packing_code`,`price`,`leadtime`,`moq`,`mpq`,`stock_location`,`taxable`,`selling_price1`,`margin_rate1`,`unit_mini_quantity1`,`unit_max_quantity1`, NOW(), NOW() FROM `products` WHERE `product_id`='.$id;

        } else {
            $insertSql = 'INSERT INTO showwindow (
            `product_code`,`part_category`,`part_category2`,`part_category3`,`maker_seq`,`location_code`,`display_set`,`newproduct_chk`,`bestproduct_chk`,`recomproduct_chk`,`brandproduct_chk`,`event_set`,`part_number`,`brief_description`,`situation`,`exposure`,`product_related`,`date_code`,`image_dir`,
            `api_flg`,`api_code`,`tariff_rate`,`product_api_id`,`qty`,`packing_code`,`price`,`leadtime`,`moq`,`mpq`,`stock_location`,`taxable`,`selling_price1`,`margin_rate1`,`unit_mini_quantity1`,`unit_max_quantity1`,`created_at`,`updated_at`) SELECT `product_code`,`part_category`,`part_category2`,
            `part_category3`,`maker_seq`,`location_code`,`display_set`,1,`bestproduct_chk`,`recomproduct_chk`,`brandproduct_chk`,`event_set`,`part_number`,`brief_description`,`situation`,`exposure`,`product_related`,`date_code`,`image_dir`,`api_flg`,`api_code`,`tariff_rate`,`product_api_id`,
            `qty`,`packing_code`,`price`,`leadtime`,`moq`,`mpq`,`stock_location`,`taxable`,`selling_price1`,`margin_rate1`,`unit_mini_quantity1`,`unit_max_quantity1`, NOW(), NOW() FROM `products` WHERE `product_id`='.$id;

        }

        return $this->db->query($insertSql);

    }


    /******************************************************************************************/

    public function updatePriceExch(){
        
        $priceExchSql01 = "update products x left join (SELECT a.counrty_code, a.standard_amount FROM exchange_rate a, (SELECT counrty_code, MAX(id) AS maxid FROM exchange_rate group by counrty_code HAVING counrty_code IS NOT null) b WHERE a.id=b.maxid) c on x.prices_currency1=c.counrty_code set x.selling_price1=round(x.prices_price1*c.standard_amount*1.15,0)";
        $this->db->query($priceExchSql01);

        $priceExchSql02 = "update products x left join (SELECT a.counrty_code, a.standard_amount FROM exchange_rate a, (SELECT counrty_code, MAX(id) AS maxid FROM exchange_rate group by counrty_code HAVING counrty_code IS NOT null) b WHERE a.id=b.maxid) c on x.prices_currency2=c.counrty_code set x.selling_price2=round(x.prices_price2*c.standard_amount*1.15,0)";
        $this->db->query($priceExchSql02);

        $priceExchSql03 = "update products x left join (SELECT a.counrty_code, a.standard_amount FROM exchange_rate a, (SELECT counrty_code, MAX(id) AS maxid FROM exchange_rate group by counrty_code HAVING counrty_code IS NOT null) b WHERE a.id=b.maxid) c on x.prices_currency3=c.counrty_code set x.selling_price3=round(x.prices_price3*c.standard_amount*1.15,0)";
        $this->db->query($priceExchSql03);

        $priceExchSql04 = "update products x left join (SELECT a.counrty_code, a.standard_amount FROM exchange_rate a, (SELECT counrty_code, MAX(id) AS maxid FROM exchange_rate group by counrty_code HAVING counrty_code IS NOT null) b WHERE a.id=b.maxid) c on x.prices_currency4=c.counrty_code set x.selling_price4=round(x.prices_price4*c.standard_amount*1.15,0)";
        $this->db->query($priceExchSql04);

        $priceExchSql05 = "update products x left join (SELECT a.counrty_code, a.standard_amount FROM exchange_rate a, (SELECT counrty_code, MAX(id) AS maxid FROM exchange_rate group by counrty_code HAVING counrty_code IS NOT null) b WHERE a.id=b.maxid) c on x.prices_currency5=c.counrty_code set x.selling_price5=round(x.prices_price5*c.standard_amount*1.15,0)";
        $this->db->query($priceExchSql05);

        $priceExchSql06 = "update products x left join (SELECT a.counrty_code, a.standard_amount FROM exchange_rate a, (SELECT counrty_code, MAX(id) AS maxid FROM exchange_rate group by counrty_code HAVING counrty_code IS NOT null) b WHERE a.id=b.maxid) c on x.prices_currency6=c.counrty_code set x.selling_price6=round(x.prices_price6*c.standard_amount*1.15,0)";
        $this->db->query($priceExchSql06);

    }

    /******************************************************************************************/

    /******************************************************************************************/
    public function naverToInsert($product_code, $product_newcode, $exchange_rat){

        $insertSql = 'INSERT INTO products (`product_code`,`part_category`,`part_category2`,`part_category3`,`maker_seq`,`maker_name`,`location_code`,`display_set`,`newproduct_chk`,`bestproduct_chk`,`recomproduct_chk`,`brandproduct_chk`,`event_set`,`part_number`,`part_number_sequence`,`search_word`,`brief_description`,
        `situation`,`exposure`,`product_related`,`replacement_items`,`date_code`,`image_dir`,`delivery_code`,`api_flg`,`api_code`,`tariff_rate`,`product_api_id`,`qty`,`packing_code`,`packing_name`,`packsize`,`wearing_price`,`price`,`margin_rate`,`discount_rate`,`leadtime`,`moq`,`in_moq`,`mpq`,`stock_location`,`taxable`,
        `selling_price1`,`prices_price1`,`prices_currency1`,`margin_rate1`,`unit_mini_quantity1`,`unit_max_quantity1`,`selling_price2`,`prices_price2`,`prices_currency2`,`margin_rate2`,`unit_mini_quantity2`,`unit_max_quantity2`,`selling_price3`,`prices_price3`,`prices_currency3`,`margin_rate3`,`unit_mini_quantity3`,`unit_max_quantity3`,
        `selling_price4`,`prices_price4`,`prices_currency4`,`margin_rate4`,`unit_mini_quantity4`,`unit_max_quantity4`,`selling_price5`,`prices_price5`,`prices_currency5`,`margin_rate5`,`unit_mini_quantity5`,`unit_max_quantity5`,`selling_price6`,`prices_price6`,`prices_currency6`,`margin_rate6`,`unit_mini_quantity6`,`unit_max_quantity6`,
        `navershop_chk`,`navershop_status`,`qty_flag`,`virtualpn`,`active_flg`,`del_flg`,`api_updated_at`,`created_at`,`updated_at`)
        SELECT "'.$product_newcode.'",`part_category`,`part_category2`,`part_category3`,`maker_seq`,`maker_name`,`location_code`,`display_set`,`newproduct_chk`,`bestproduct_chk`,`recomproduct_chk`,`brandproduct_chk`,`event_set`,`part_number`,`part_number_sequence`,`search_word`,`brief_description`,`situation`,`exposure`,`product_related`,
        `replacement_items`,`date_code`,`image_dir`,`delivery_code`,1,"SP",`tariff_rate`,`product_api_id`,`qty`,`packing_code`,`packing_name`,`packsize`,`wearing_price`,`price`,`margin_rate`,`discount_rate`,`leadtime`,`moq`,`in_moq`,`mpq`,`stock_location`,`taxable`,
        (`prices_price1`*1.15)*'.$exchange_rat.',(`prices_price1`*1.15)*'.$exchange_rat.',"KRW",`margin_rate1`,`unit_mini_quantity1`,`unit_max_quantity1`,
        (`prices_price2`*1.15)*'.$exchange_rat.',(`prices_price2`*1.15)*'.$exchange_rat.',"KRW",`margin_rate2`,`unit_mini_quantity2`,`unit_max_quantity2`,
        (`prices_price3`*1.15)*'.$exchange_rat.',(`prices_price3`*1.15)*'.$exchange_rat.',"KRW",`margin_rate3`,`unit_mini_quantity3`,`unit_max_quantity3`,
        (`prices_price4`*1.15)*'.$exchange_rat.',(`prices_price4`*1.15)*'.$exchange_rat.',"KRW",`margin_rate4`,`unit_mini_quantity4`,`unit_max_quantity4`,
        (`prices_price5`*1.15)*'.$exchange_rat.',(`prices_price5`*1.15)*'.$exchange_rat.',"KRW",`margin_rate5`,`unit_mini_quantity5`,`unit_max_quantity5`,
        (`prices_price6`*1.15)*'.$exchange_rat.',(`prices_price6`*1.15)*'.$exchange_rat.',"KRW",`margin_rate6`,`unit_mini_quantity6`,`unit_max_quantity6`,
        1,"I",`qty_flag`,`virtualpn`,`active_flg`,`del_flg`,`api_updated_at`, NOW(), NOW() FROM products WHERE `product_code` = "'.$product_code.'"';
        $this->db->query($insertSql);

        $insertDetailSql = 'INSERT INTO products_detail (`product_code`,`api_flg`,`api_code`,`product_api_id`,`product_doc`,`product_image1`,`product_image2`,`product_image3`,`product_image4`,`product_image5`,`product_pdf`,`active_flg`,`del_flg`,`created_at`,`updated_at`) 
        SELECT "'.$product_newcode.'", 1,"SP",`product_api_id`,`product_doc`,`product_image1`,`product_image2`,`product_image3`,`product_image4`,`product_image5`,`product_pdf`,`active_flg`,`del_flg`, NOW(), NOW() FROM products_detail WHERE `product_code` = "'.$product_code.'"';
        $this->db->query($insertDetailSql);

    }
    /******************************************************************************************/

}