<?php
namespace App\Models;

use App\Helpers\DateHelper;

class ProductdetailModel extends BaseModel {
    protected $table      = 'products_detail';
    protected $primaryKey = 'product_id';

    protected $allowedFields = ['product_code', 'api_flg', 'api_code', 'product_api_id', 'product_doc', 'product_image1', 'product_image2', 'product_image3', 'product_image4', 'product_image5', 'product_pdf', 'active_flg', 'del_flg'];

    protected $returnType = 'App\Entities\Poductdetail';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules    = [
        'product_api_id' => 'required',
        'product_code' => 'required|min_length[5]',
        'api_code' => 'required',
    ];
    
    protected $validationMessages = [];
    protected $skipValidation     = true;

    public function getPopup($limit){
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);
        $queryBuilder = $this->where('active_flg', 1);
        $queryBuilder = $this->orderBy('product_api_id', 'ASC');

        return $this->executePaginate($queryBuilder, $limit);
    }

    public function findInfoById($id){
        $tableProductdetail = $this::getTableName();
        $tableApiinfo = ApiinfoModel::getTableName();
        
        return $this->where('id', esc($id))->join($tableApiinfo,"$tableProductdetail.api_code = $tableApiinfo.api_code")
            ->select("$tableProductdetail.* , $tableApiinfo.provider_name")->first();
        
    }

    public function getSearch($condition = [], $limit = 20){
        $tableProductdetail = $this::getTableName();
        $tableApiinfo = ApiinfoModel::getTableName();
        $queryBuilder = $this->where("$tableProductdetail.del_flg", DELETE_FLG_OFF);

        if(isset($condition['api_code']) && $this->checkSearchItem($condition['api_code'])){
            $queryBuilder->where("$tableProductdetail.api_code", esc($condition['api_code']));
        }
        if(isset($condition['product_code']) && $this->checkSearchItem($condition['product_code'])){
            $queryBuilder->like("$tableProductdetail.product_code", esc($condition['product_code']));
        }

        $queryBuilder->join($tableApiinfo,"$tableApiinfo.api_code = $tableProductdetail.api_code");
        $queryBuilder->select("$tableProductdetail.* , $tableApiinfo.provider_name");
        $queryBuilder->orderBy('created_at desc');
        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }

    public function updateDetailLcscSpwup($product_code, $productitem){

        /*
        var_dump($productitem ["attributes"]);
        */

        $queryBuilder = $this->set('api_code', "LC");
        $queryBuilder = $this->set('product_api_id', $productitem ["number"]);
        $queryBuilder = $this->set('product_pdf', $productitem ["datasheet"]["pdf"]);
        $queryBuilder = $this->set('api_updated_at', date('Y-m-d H:i:s'));
        $queryBuilder = $this->where('product_code', $product_code);
        $queryBuilder = $this->update();

    }

    public function updateDetailIckSpwup($product_code, $productitem){

        // var_dump($productitem ["sku"]);
        // var_dump($productitem ["data_sheet"][0]);
        // exit;

        $queryBuilder = $this->set('api_code', "ICK");
        $queryBuilder = $this->set('product_api_id', $productitem["sku"]);
        $queryBuilder = $this->set('product_pdf', $productitem ["data_sheet"][0]);
        $queryBuilder = $this->set('api_updated_at', date('Y-m-d H:i:s'));
        $queryBuilder = $this->where('product_code', $product_code);
        $queryBuilder = $this->update();

    }

}