<?php
namespace App\Models;

use App\Helpers\ArrayHelper;
use http\QueryString;

class ProductmpEventModel extends BaseModel {
    protected $table      = 'tmp_products_event';
    protected $primaryKey = 'product_id';
  
    protected $allowedFields = ['product_code','part_number','replacement_items','active_flg','del_flg'];

    protected $returnType = 'App\Entities\ProductmpEvent';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    /*
    protected $validationRules    = [
        'part_number' => 'required|min_length[3]',
        'qty' => 'required|alpha_numeric',
        'id' => 'required',
    ];
    */

    protected $validationMessages = [];
    protected $skipValidation     = true;

    /*
    public function save($data): bool{
        $data->part_number_sequence = strrev($data->part_number);
        return parent::save($data);
    }
    */

    public function getAdmin($condition = [], $limit = 20 , $allData = false){

        if(!isset($condition)) $condition = [];

        $tableProduct = ProductmpEventModel::getTableName();

        $queryBuilder = $this->where("$tableProduct.del_flg", DELETE_FLG_OFF);

        if(isset($condition['from_date']) && $this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where("$tableProduct.created_at >=", esc($condition['from_date']));
        }
        if(isset($condition['to_date']) && $this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where("$tableProduct.created_at <=", esc($condition['to_date']));
        }

        if(isset($condition['part_number']) && $this->checkSearchItem($condition['part_number'])){
            $queryBuilder->like("$tableProduct.part_number", trim($condition['part_number']));
        }

        $queryBuilder->select("$tableProduct.*");

        if(!isset($limit)) $limit = 20;
        if($allData){
            $dataResult = $queryBuilder->findAll($limit);
                    
            return $dataResult;
        }

        $dataResult = $this->executePaginate($queryBuilder, $limit);

        return $dataResult;
    }

    public function getSearchExl($limit){
        if(!isset($condition)) $condition = [];

        $tableProduct = ProductmpEventModel::getTableName();
        $queryBuilder = $this->where("$tableProduct.del_flg", DELETE_FLG_OFF);
        $queryBuilder->select("$tableProduct.*");
        $queryBuilder->orderBy("$tableProduct.created_at desc");

        $dataResult = $this->executePaginate($queryBuilder, $limit);
        return $dataResult;
    }


    public function updateReplacItems(){
        $insql = 'UPDATE products a INNER JOIN tmp_products_event b ON a.product_code=b.product_code SET a.replacement_items=b.replacement_items';
        $this->db->query($insql);
    }

    public function updatEventItems($event_set){
        $insql = 'UPDATE products a INNER JOIN tmp_products_event b ON a.product_code=b.product_code SET a.event_set="'.$event_set.'"';
        $this->db->query($insql);
    }

    public function updatNavershopItems($navershop_chk, $navershop_status){
        $insql = 'UPDATE products a INNER JOIN tmp_products_event b ON a.product_code=b.product_code SET a.navershop_chk="'.$navershop_chk.'", a.navershop_status="'.$navershop_status.'"';

        $this->db->query($insql);
    }

    public function eraseTempProducts(){
        return $this->db->query('truncate `tmp_products_event`'); 
    }

}