<?php
namespace App\Models;

use App\Helpers\ArrayHelper;
use http\QueryString;

class QsProductModel extends BaseModel {
    protected $table      = 'products';
    protected $primaryKey = 'product_id';

    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;

    protected $allowedFields = ['product_code','part_category','part_category2','part_category3','maker_seq','location_code','display_set','newproduct_chk','bestproduct_chk','recomproduct_chk','brandproduct_chk','event_set','part_number','part_number_sequence','search_word','brief_description','situation',
        'exposure','product_related','date_code','image_dir','image_thumbnail_dir','delivery_code','api_flg','api_code','tariff_rate','product_api_id','qty','packing_code','packsize','wearing_price','price','leadtime','moq','in_moq','mpq','stock_location','taxable',
        'selling_price1','margin_rate1','unit_mini_quantity1','unit_max_quantity1',
        'selling_price2','margin_rate2','unit_mini_quantity2','unit_max_quantity2',
        'selling_price3','margin_rate3','unit_mini_quantity3','unit_max_quantity3',
        'selling_price4','margin_rate4','unit_mini_quantity4','unit_max_quantity4',
        'selling_price5','margin_rate5','unit_mini_quantity5','unit_max_quantity5',
        'selling_price6','margin_rate6','unit_mini_quantity6','unit_max_quantity6',
        'navershop_chk','navershop_status','qty_flag','virtualpn','active_flg','del_flg'];

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';


    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];
}