<?php
namespace App\Models;

use App\Helpers\DateHelper;

class RefundInfoModel extends BaseModel {
    protected $table      = 'refunds_info';
    protected $primaryKey = 'info_id';

    protected $allowedFields = ['refund_code','refund_type','refund_reason','return_status','refund_status','return_shipping','return_zipocode','return_add1','return_add2','order_code','order_status','member_code','orderer_name','orderer_email','orderer_phone','shipping_recipient',
    'shipping_name','delivery_phone','shipping_phone','company_name','shipping_zipocode','shipping_add1','shipping_add2','shipping_message','notice','content','answer_content','firstitem_code','firstitem_number','firstitem_image','item_counts','supply_price','vat',
    'amount_total','delivery_fee','change_flg','refund_flg','payment_date','payment_flg','deposit_name','deposit_bank','deposit_date','resultCode','resultMsg','tid','MOID','TotPrice','goodName','applDate','applTime','payMethod','applNum','P_FN_NM','VACT_Num',
    'VACT_BankCode','vactBankName','VACT_Date','payDevice','sales_proof_flg','amount_payment','active_flg','del_flg'];

    protected $returnType = 'App\Entities\RefundInfo';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    /*
    protected $validationRules    = [
        'refund_code'        => 'required',
        'orderer_name'      => 'required',
        'orderer_email'     => 'required|valid_email',
        'orderer_phone'     => 'required',
        'shipping_message'  => 'required',
        'notice'            => 'required'
    ];
    */

    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function getSearch($condition = [], $limit = 20){
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);
        if($this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where('created_at >=', DateHelper::setFirstHourMinuteDate(esc($condition['from_date'])));
        }
        if($this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where('created_at <=',DateHelper::setLastHourMinuteDate(esc($condition['to_date'])));
        }

        
        $queryBuilder->orderBy('created_at desc');

        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }

    public function getSearchMem($condition = [], $limit = 20){
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);
        $queryBuilder = $this->where('member_code', $condition['member_code']);
        if($this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where('created_at >=', DateHelper::setFirstHourMinuteDate(esc($condition['from_date'])));
        }
        if($this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where('created_at <=',DateHelper::setLastHourMinuteDate(esc($condition['to_date'])));
        }

        $queryBuilder->orderBy('created_at desc');

        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }

    public function findInfoById($refundInfoId){
        $tableRefund = $this::getTableName();
        return $this->where('info_id', esc($refundInfoId))->select("$tableRefund.*")->first();
    }

    public function findByRefundCode($refund_code){
        $tableRefund = $this::getTableName();
        return $this->where('refund_code', esc($refund_code))->select("$tableRefund.*")->first();
    }

    public function findByOrderCode($order_code){
        $tableRefund = $this::getTableName();
        return $this->where('order_code', esc($order_code))->select("$tableRefund.info_id")->first();
    }

    public function findByRefundUser($phone_num){
        $tableRefund = $this::getTableName();
        return $this->where('orderer_phone', esc($phone_num))->select("$tableRefund.*")->first();
    }

}
