<?php
namespace App\Models;

use App\Helpers\DateHelper;

class ReviewModel extends BaseModel {
    protected $table      = 'review';
    protected $primaryKey = 'id';

    protected $allowedFields = ['title','category_id','item_code','part_number','manufacturer_code','member_code','user_name','user_email','replyemeil_chk','user_phone','password','content','hit_number','public_flg','member_code','item_code','part_number','del_flg'];

    protected $returnType = 'App\Entities\Review';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';


    protected $validationRules    = [
        'category_id' => 'required',
        'title' => 'required|min_length[5]',
        'content' => 'required',
    ];


    protected $validationMessages = [];
    protected $skipValidation     = true;


    public function findInfoById($id){
        $tableReview = $this::getTableName();
        $tableCategory = ReviewCategoryModel::getTableName();
        return $this->where('id', esc($id))->join($tableCategory,"$tableReview.category_id = $tableCategory.category_id")
            ->select("$tableReview.* , $tableCategory.category_name")->first();
    }

    public function getSearch($condition = [], $limit = 20){
        $tableReviewCategory = ReviewCategoryModel::getTableName();
        $tableReview = $this::getTableName();
        // $tableAccountManager = AccountManagerModel::getTableName();
        $queryBuilder = $this->where("$tableReview.del_flg", DELETE_FLG_OFF);
        if(isset($condition['category_id']) && $this->checkSearchItem($condition['category_id'])){
            $queryBuilder->where("$tableReview.category_id", esc($condition['category_id']));
        }
        if(isset($condition['title']) && $this->checkSearchItem($condition['title'])){
            $queryBuilder->like("$tableReview.title", esc($condition['title']));
        }
        if(isset($condition['title']) && $this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where("$tableReview.created_at >=", DateHelper::setFirstHourMinuteDate(esc($condition['from_date'])));
        }
        if(isset($condition['to_date']) && $this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where("$tableReview.created_at <=",DateHelper::setLastHourMinuteDate(esc($condition['to_date'])));
        }

        // 관리자 정보 사용
        // $queryBuilder->join($tableReviewCategory,"$tableReviewCategory.category_id = $tableReview.category_id");
        // $queryBuilder->join($tableAccountManager,"$tableAccountManager.account_id = $tableReview.account_manager_id");
        // $queryBuilder->select("$tableReview.* , $tableReviewCategory.category_name , $tableAccountManager.full_name");
        // $queryBuilder->orderBy('created_at desc');

        $queryBuilder->join($tableReviewCategory,"$tableReviewCategory.category_id = $tableReview.category_id");
        $queryBuilder->select("$tableReview.* , $tableReviewCategory.category_name");
        $queryBuilder->orderBy('created_at desc');


        if(!isset($limit)) $limit = 20;

        return $this->executePaginate($queryBuilder, $limit);
    }

    public function review_add($data) {
        $tableReview = $this::getTableName();
        $query = $this->table($tableReview)->insert($data);
        
        return $this->insertID();
    }

}