<?php
namespace App\Models;

use App\Helpers\DateHelper;

class SelpaDataInfoModel extends BaseModel {
    protected $table      = 'selpadata_info';
    protected $primaryKey = 'id';

	protected $allowedFields = [ 'product_code','categorylevel1_code','category_id1','category_name1','categorylevel2_code','category_id2','category_name2','maker_seq','pro_name','pro_maf','pro_desc','date_code','package',
                'stock','moq','mpq','price1','price2','price3','price4','price5','price6','nums1','nums2','nums3','nums4','nums5','nums6','data_sheet','img_url','detail_url','active_flg','del_flg'];

    protected $returnType = 'App\Entities\SelpaDataInfo';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules    = [
        'pro_name' => 'required|min_length[2]',
    ];
    protected $validationMessages = [];
    protected $skipValidation     = true;

    public function findInfoById($id){
        $tableSelpaDataInfo = $this::getTableName();
        return $this->where('id', esc($id))->select("$tableSelpaDataInfo.*")->first();
    }
    
    public function selectAll(){
        return $this->where('del_flg', DELETE_FLG_OFF,true)->findAll();
    }

    public function getAdmin($condition = [], $limit = 20 , $allData = false){

        if(!isset($condition)) $condition = [];
        $tableSelpaDataInfo = $this::getTableName();
        $queryBuilder = $this->where("$tableSelpaDataInfo.del_flg", DELETE_FLG_OFF);

        if(isset($condition['from_date']) && $this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where("$tableSelpaDataInfo.created_at >=", esc($condition['from_date']));
        }
        if(isset($condition['to_date']) && $this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where("$tableSelpaDataInfo.created_at <=", esc($condition['to_date']));
        }

        if(isset($condition['pro_name']) && $this->checkSearchItem($condition['pro_name'])){
            $queryBuilder->like("$tableSelpaDataInfo.pro_name", trim($condition['pro_name']));
        }

        $queryBuilder->select("$tableSelpaDataInfo.*");

        if(!isset($limit)) $limit = 20;
        
        if($allData){
            $dataResult = $queryBuilder->findAll($limit);
            return $dataResult;
        }

        $dataResult = $this->executePaginate($queryBuilder, $limit);
        return $dataResult;
    }

    public function getSearch($condition = [], $limit = 20){
        $tableSelpaDataInfo = $this::getTableName();
        $queryBuilder = $this->where("$tableSelpaDataInfo.del_flg", DELETE_FLG_OFF);
        
        if($this->checkSearchItem($condition['pro_name'])){
            $queryBuilder->like("$tableSelpaDataInfo.pro_name", esc($condition['pro_name']));
        }
        if($this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where("$tableSelpaDataInfo.created_at >=", DateHelper::setFirstHourMinuteDate(esc($condition['from_date'])));
        }
        if($this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where("$tableSelpaDataInfo.created_at <=",DateHelper::setLastHourMinuteDate(esc($condition['to_date'])));
        }
        
        $queryBuilder->orderBy("$tableSelpaDataInfo.created_at desc");
        $queryBuilder->select("$tableSelpaDataInfo.*");

        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }


    public function getSku($limit){
        $tableSelpaDataInfo = $this::getTableName();
        $queryBuilder = $this->where("$tableSelpaDataInfo.del_flg", DELETE_FLG_OFF);
        $queryBuilder = $this->where("$tableSelpaDataInfo.active_flg", DELETE_FLG_OFF);
        $queryBuilder->orderBy("$tableSelpaDataInfo.created_at desc");
        $queryBuilder->select("$tableSelpaDataInfo.sku");

        if(!isset($limit)) $limit = 30;
        return $this->executePaginate($queryBuilder, $limit);
    }


    public function eraseTempProducts(){
        return $this->db->query('truncate `icking_info`'); 
    }

    public function insertProductInfo(){
        // $tidyupSql02 = "INSERT INTO manufacturers (maker_code, NAME, created_at, updated_at) SELECT 'SPW' as maker_code, TRIM(a.pro_maf) AS NAME, NOW() AS created_at, NOW() AS updated_at FROM selpadata_info a WHERE NOT EXISTS(SELECT name FROM manufacturers b WHERE a.pro_maf=b.`name`) group BY TRIM(a.pro_maf)";
        // $this->db->query($tidyupSql02);
        // $tidyupSql03 = "update selpadata_info a inner join manufacturers b on a.pro_maf=b.name set a.maker_seq=b.maker_seq";
        // $this->db->query($tidyupSql03);

        $insertSql = 'INSERT INTO products (`product_code`,`part_category`,`part_category2`,`maker_seq`,`maker_name`,`part_number`,`part_number_sequence`,`brief_description`,
        `delivery_code`,`api_flg`,`api_code`,`qty`,`leadtime`,`moq`,`mpq`,`stock_location`,
        `selling_price1`, `prices_price1`, `prices_currency1`, `unit_mini_quantity1`,
        `selling_price2`, `prices_price2`, `prices_currency2`, `unit_mini_quantity2`,
        `selling_price3`, `prices_price3`, `prices_currency3`, `unit_mini_quantity3`,
        `selling_price4`, `prices_price4`, `prices_currency4`, `unit_mini_quantity4`,
        `selling_price5`, `prices_price5`, `prices_currency5`, `unit_mini_quantity5`,
        `selling_price6`, `prices_price6`, `prices_currency6`, `unit_mini_quantity6`,
        `virtualpn`,`created_at`,`updated_at`) 
        SELECT `product_code`,`categorylevel1_code`,`categorylevel2_code`,`maker_seq`,CONCAT(pro_maf),CONCAT(pro_name),CONCAT(pro_maf,pro_name),CONCAT(pro_name,"|^|",pro_desc),
        1,1,"SPW",1000,2,`moq`,`mpq`,3,
        `price1`, `price1`, "USD", `nums1`,
        `price2`, `price2`, "USD", `nums2`,
        `price3`, `price3`, "USD", `nums3`,
        `price4`, `price4`, "USD", `nums4`,
        `price5`, `price5`, "USD", `nums5`,
        `price6`, `price6`, "USD", `nums6`,
        CONCAT(pro_name,product_code,pro_maf),NOW(), NOW() FROM selpadata_info';
        $this->db->query($insertSql);

        $insertDetailSql = 'INSERT INTO products_detail (`product_code`,`api_flg`,`api_code`,`product_doc`,`created_at`,`updated_at`) 
        SELECT `product_code`,1,"SPW", `pro_desc`, NOW(), NOW() FROM selpadata_info';
        $this->db->query($insertDetailSql);

        // $insertUpImagedirSql = 'UPDATE `products` SET image_dir = REPLACE(image_dir, "http://static.ickimg.com/assets/release3.001/img/pic/default_list_logo.jpg?utm_source=api", "") WHERE image_dir="http://static.ickimg.com/assets/release3.001/img/pic/default_list_logo.jpg?utm_source=api" AND api_code="SPW"';
        // $this->db->query($insertUpImagedirSql);
        // $insertUpMarginSql = 'UPDATE `products` SET `margin_rate` = 15';
        // $this->db->query($insertUpMarginSql);

        $insertUpActiveSql = 'UPDATE `selpadata_info` SET `active_flg` = 1';
        $this->db->query($insertUpActiveSql);

    }


    /*
    public function insertProductInfo($exchange_rat){
        $insertSql = 'INSERT INTO products (`product_code`,`part_category`,`part_category2`,`maker_seq`,`maker_name`,`part_number`,`part_number_sequence`,`search_word`,`brief_description`,
        `image_dir`,`delivery_code`,`api_flg`,`api_code`,`product_api_id`,`qty`,`packing_code`,`packing_name`,`leadtime`,`moq`,`in_moq`,`mpq`,`stock_location`,
        `selling_price1`,`prices_price1`,`prices_currency1`,`unit_mini_quantity1`,
        `selling_price2`,`prices_price2`,`prices_currency2`,`unit_mini_quantity2`,
        `selling_price3`,`prices_price3`,`prices_currency3`,`unit_mini_quantity3`,
        `selling_price4`,`prices_price4`,`prices_currency4`,`unit_mini_quantity4`,
        `selling_price5`,`prices_price5`,`prices_currency5`,`unit_mini_quantity5`,
        `selling_price6`,`prices_price6`,`prices_currency6`,`unit_mini_quantity6`,
        `virtualpn`,`created_at`,`updated_at`) 
        SELECT `product_code`,`categorylevel1_code`,`categorylevel2_code`,`maker_seq`,CONCAT(pro_maf),CONCAT(pro_name),CONCAT(pro_maf,pro_name),`sku`,CONCAT(pro_name,"|^|",pro_desc),
        CONCAT("http:",img_url),1,1,"ICK",`sku`,`stock`,`packing_code`,`package`,2,`moq`,`spq`,`mpq`,3,
        (`price0`*1.15)*'.$exchange_rat.',`price0`,"CNY",`nums0`,
        (`price1`*1.15)*'.$exchange_rat.',`price1`,"CNY",`nums1`,
        (`price2`*1.15)*'.$exchange_rat.',`price2`,"CNY",`nums2`,
        (`price3`*1.15)*'.$exchange_rat.',`price3`,"CNY",`nums3`,
        (`price4`*1.15)*'.$exchange_rat.',`price4`,"CNY",`nums4`,
        (`price5`*1.15)*'.$exchange_rat.',`price5`,"CNY",`nums5`,
        CONCAT(pro_name,product_code,pro_maf),NOW(), NOW() FROM icking_info WHERE `active_flg` = 0';
        $this->db->query($insertSql);

        $insertDetailSql = 'INSERT INTO products_detail (`product_code`,`api_flg`,`api_code`,`product_api_id`,`product_doc`,`product_pdf`,`created_at`,`updated_at`) 
        SELECT `product_code`,1,"ICK",`sku`,`pro_desc`,`data_sheet`, NOW(), NOW() FROM icking_info WHERE `active_flg` = 0';
        $this->db->query($insertDetailSql);

        $insertUpImagedirSql = 'UPDATE `products` SET image_dir = REPLACE(image_dir, "http://static.ickimg.com/assets/release3.001/img/pic/default_list_logo.jpg?utm_source=api", "") WHERE image_dir="http://static.ickimg.com/assets/release3.001/img/pic/default_list_logo.jpg?utm_source=api" AND api_code="ICK"';
        $this->db->query($insertUpImagedirSql);

        $insertUpMarginSql = 'UPDATE `products` SET `margin_rate` = 15';
        $this->db->query($insertUpMarginSql);

        $insertUpActiveSql = 'UPDATE `icking_info` SET `active_flg` = 1';
        $this->db->query($insertUpActiveSql);

    }
    */

    public function replaceProductInfo(){
        $replaceSql01 = "update products set virtualpn = replace(virtualpn, '[`~!#$%^&*|\\\'\";:\/?]', '')";
        $this->db->query($replaceSql01);
        $replaceSql02 = "update products set virtualpn = replace(virtualpn, '-', '')";
        $this->db->query($replaceSql02);
        $replaceSql03 = "update products set virtualpn = replace(virtualpn, '/', '')";
        $this->db->query($replaceSql03);
        $replaceSql04 = "update products set virtualpn = replace(virtualpn, ' ', '')";
        $this->db->query($replaceSql04);
        $replaceSql05 = "update products set virtualpn = replace(virtualpn, '#', '')";
        $this->db->query($replaceSql05);
        $replaceSql06 = "update products set virtualpn = replace(virtualpn, '*', '')";
        $this->db->query($replaceSql06);
        $replaceSql07 = "update products set virtualpn = replace(virtualpn, ',', '')";
        $this->db->query($replaceSql07);
    }

    /*
    public function sortingData(){
        $tidyupSql01 = "DELETE a FROM icking_info a WHERE NOT EXISTS (SELECT 1 FROM (SELECT sku, min(id) AS id FROM icking_info GROUP BY sku) b WHERE a.id=b.id)";
        $this->db->query($tidyupSql01);
        $tidyupSql02 = "INSERT INTO manufacturers (maker_code, NAME, created_at, updated_at) SELECT 'ICK' as maker_code, TRIM(a.pro_maf) AS NAME, NOW() AS created_at, NOW() AS updated_at FROM icking_info a WHERE NOT EXISTS(SELECT name FROM manufacturers b WHERE a.pro_maf=b.`name`) group BY TRIM(a.pro_maf)";
        $this->db->query($tidyupSql02);
        $tidyupSql03 = "update icking_info a inner join manufacturers b on a.pro_maf=b.name set a.maker_seq=b.maker_seq";
        $this->db->query($tidyupSql03);
        $tidyupSql04 = "update icking_info a inner join packaging_unit b on a.package = b.packing_name_eng and b.supplier_code = 'ICK' set a.packing_code=b.packing_code";
        $this->db->query($tidyupSql04);
        
    }
    */

    public function tidyupProductInfo(){
        $setSql01 = "ALTER TABLE products AUTO_INCREMENT = 1";
        $this->db->query($setSql01);
        $setSql02 = "SET @COUNT = 0";
        $this->db->query($setSql02);
        $setSql03 = "UPDATE products SET product_id = @COUNT:=@COUNT+1";
        $this->db->query($setSql03);

        $setSql04 = "ALTER TABLE products_detail AUTO_INCREMENT = 1";
        $this->db->query($setSql04);
        $setSql05 = "SET @COUNT = 0";
        $this->db->query($setSql05);
        $setSql06 = "UPDATE products_detail SET product_id = @COUNT:=@COUNT+1";
        $this->db->query($setSql06);

        $setSql07 = "ALTER TABLE icking_info AUTO_INCREMENT = 1";
        $this->db->query($setSql07);
        $setSql08 = "SET @COUNT = 0";
        $this->db->query($setSql08);
        $setSql09 = "UPDATE icking_info SET id = @COUNT:=@COUNT+1";
        $this->db->query($setSql09);

        $setSql10 = "SELECT @maxProduct_id:=AUTO_INCREMENT FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME = 'products' AND TABLE_SCHEMA = DATABASE( )";
        $this->db->query($setSql10);
        $setSql11 = "UPDATE icking_info y inner join (SELECT a.id, a.row_num, CONCAT('C',LPAD(a.row_num+@maxProduct_id-1,9,'0')) AS new_product_code FROM ( select id, product_code, ROW_NUMBER() OVER(ORDER BY id asc) AS row_num FROM icking_info where product_code='' OR product_code IS NULL) a) x on x.id=y.id set y.product_code=x.new_product_code";
        $this->db->query($setSql11);

    }

    public function insertSeqdata(){
        // $this->db->query('truncate `api_pndata`');
        $insertSql = 'INSERT INTO api_pndata (`api_code`, `api_partnumber`, `active_flg`, `created_at`, `updated_at`) SELECT "ICK", `sku`, 0, NOW(), NOW() FROM icking_info';
        $this->db->query($insertSql);
    }

}