<?php
namespace App\Models;

use App\Helpers\DateHelper;

class ShippingCompanyModel extends BaseModel {
    protected $table      = 'shipping_company';
    protected $primaryKey = 'shipping_id';

    protected $allowedFields = ['shipping_code','shipping_name','shipping_name_eng','never_code','active_flg','del_flg'];

    protected $returnType = 'App\Entities\ShippingCompany';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules    = [
        'shipping_code' => 'required',
        'shipping_name' => 'required',
    ];
    
    protected $validationMessages = [];
    protected $skipValidation     = true;

    public function getSearch($condition = [], $limit = 20){
        $tablePackagingunit = $this::getTableName();
        $queryBuilder = $this->where("$tablePackagingunit.del_flg", DELETE_FLG_OFF);
        if(isset($condition['shipping_code']) && $this->checkSearchItem($condition['shipping_code'])){
            $queryBuilder->where("$tablePackagingunit.shipping_code", esc($condition['shipping_code']));
        }
        if(isset($condition['shipping_name']) && $this->checkSearchItem($condition['shipping_name'])){
            $queryBuilder->like("$tablePackagingunit.shipping_name", esc($condition['shipping_name']));
        }
        $queryBuilder->orderBy('created_at desc');
        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }

    public function findByCategoryInfo($shipping_code){
        return $this->where('shipping_code', $shipping_code)->first();
    }

    public function findByCategoryId($shipCompanyid){
        return $this->where('shipping_id', $shipCompanyid)->first();
    }

}