<?php
namespace App\Models;

use App\Helpers\DateHelper;

class SitemapdataModel extends BaseModel {
    protected $table      = 'sitemap_data';
    protected $primaryKey = 'id';
    
    protected $allowedFields = ['product_code','active_flg'];

    protected $returnType = 'App\Entities\Sitemapdata';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function getSitemapId($incount){
        $queryBuilder = $this->where('active_flg', 0);
        $queryBuilder = $this->select("product_code");
        $queryBuilder = $this->findAll($incount);
        
        return $queryBuilder;
    }


    public function updateActiveFlg($product_code){
        $queryBuilder = $this->set('active_flg', '1');
        $queryBuilder = $this->where('product_code', $product_code);
        $queryBuilder = $this->update();
    }

    public function deleteSitemapdata(){
        // $this->delete(['id' => $id]);
        $deleteSql = 'DELETE FROM sitemap_data WHERE `active_flg` = 1';
        $this->db->query($deleteSql);
    }

    public function insertSitemapdata(){
        $this->db->query('truncate `sitemap_data`');
        $insertSql = 'INSERT INTO sitemap_data (`product_code`, `active_flg`, `created_at`, `updated_at`) SELECT `product_code`, 0, NOW(), NOW() FROM products';
        $this->db->query($insertSql);
    }

    
    public function getActiveCount(){
        $queryBuilder = $this->where('active_flg', 0);
        $queryBuilder = $this->countAllResults();
        return $queryBuilder;
    }

}
