<?php
namespace App\Models;

class StocklocationCategoryModel extends BaseModel {
    protected $table      = 'stocklocation_categories';
    protected $primaryKey = 'location_id';

    protected $allowedFields = ['location_info','location_info_eng','active_flg','del_flg'];

    protected $returnType = 'App\Entities\StocklocationCategory';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules    = [
        'location_info' => 'required',
    ];
    
    protected $validationMessages = [];
    protected $skipValidation     = true;

    public function getSearch($condition = [], $limit = 20){
        $tableStocklocationCategory = $this::getTableName();
        $queryBuilder = $this->where("$tableStocklocationCategory.del_flg", DELETE_FLG_OFF);
        if(isset($condition['location_info']) && $this->checkSearchItem($condition['location_info'])){
            $queryBuilder->like("$tableStocklocationCategory.location_info", esc($condition['location_info']));
        }
        $queryBuilder->orderBy('created_at desc');
        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }

    public function findByCategoryInfo($location_info){
        return $this->where('location_info', $location_info)->first();
    }
}